/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extension;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.FieldValidateable;
import io.fabric8.kubernetes.client.extension.ExtensibleResource;
import io.fabric8.kubernetes.client.extension.ResourceAdapter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class ExtensibleResourceAdapter<T>
extends ResourceAdapter<T>
implements ExtensibleResource<T> {
    protected ExtensibleResource<T> resource;
    protected Client client;

    public abstract ExtensibleResourceAdapter<T> newInstance();

    public ExtensibleResourceAdapter<T> init(ExtensibleResource<T> resource, Client client) {
        ((ResourceAdapter)this).resource = resource;
        this.resource = resource;
        this.client = client;
        return this;
    }

    @Override
    public ExtensibleResource<T> lockResourceVersion(String resourceVersion) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.lockResourceVersion(resourceVersion), this.client);
    }

    @Override
    public ExtensibleResource<T> withResourceVersion(String resourceVersion) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withResourceVersion(resourceVersion), this.client);
    }

    @Override
    public ExtensibleResource<T> fromServer() {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.fromServer(), this.client);
    }

    @Override
    public ExtensibleResource<T> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withGracePeriod(gracePeriodSeconds), this.client);
    }

    @Override
    public ExtensibleResource<T> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withPropagationPolicy(propagationPolicy), this.client);
    }

    @Override
    public ExtensibleResource<T> withIndexers(Map<String, Function<T, List<String>>> indexers) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withIndexers((Map)indexers), this.client);
    }

    @Override
    public ExtensibleResource<T> dryRun(boolean isDryRun) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.dryRun(isDryRun), this.client);
    }

    @Override
    public ExtensibleResource<T> withLimit(Long limit) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withLimit(limit), this.client);
    }

    @Override
    public <C extends Client> C inWriteContext(Class<C> clazz) {
        return this.resource.inWriteContext(clazz);
    }

    @Override
    public ExtensibleResource<T> lockResourceVersion() {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.lockResourceVersion(), this.client);
    }

    @Override
    public T getItem() {
        return this.resource.getItem();
    }

    @Override
    public ExtensibleResource<T> fieldValidation(FieldValidateable.Validation fieldValidation) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.fieldValidation(fieldValidation), this.client);
    }

    @Override
    public ExtensibleResource<T> fieldManager(String manager) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.fieldManager(manager), this.client);
    }

    @Override
    public ExtensibleResource<T> forceConflicts() {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.forceConflicts(), this.client);
    }

    @Override
    public ExtensibleResource<T> withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.withTimeout(timeout, unit), this.client);
    }

    @Override
    public ExtensibleResource<T> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ExtensibleResource<T> unlock() {
        return this.newInstance().init((ExtensibleResource<T>)this.resource.unlock(), this.client);
    }
}

