package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.client.http.TlsVersion;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.io.File;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SundrioConfigFluent<A extends SundrioConfigFluent<A>> extends BaseFluent<A>{
  public SundrioConfigFluent() {
  }
  
  public SundrioConfigFluent(SundrioConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean trustCerts;
  private Boolean disableHostnameVerification;
  private String masterUrl;
  private String apiVersion;
  private String namespace;
  private String caCertFile;
  private String caCertData;
  private String clientCertFile;
  private String clientCertData;
  private String clientKeyFile;
  private String clientKeyData;
  private String clientKeyAlgo;
  private String clientKeyPassphrase;
  private String trustStoreFile;
  private String trustStorePassphrase;
  private String keyStoreFile;
  private String keyStorePassphrase;
  private AuthProviderConfig authProvider;
  private String username;
  private String password;
  private String oauthToken;
  private String autoOAuthToken;
  private OAuthTokenProvider oauthTokenProvider;
  private Long websocketPingInterval;
  private Integer connectionTimeout;
  private Integer maxConcurrentRequests;
  private Integer maxConcurrentRequestsPerHost;
  private List<NamedContext> contexts = new ArrayList<NamedContext>();
  private NamedContext currentContext;
  private Integer watchReconnectInterval;
  private Integer watchReconnectLimit;
  private Integer uploadRequestTimeout;
  private Integer requestRetryBackoffLimit;
  private Integer requestRetryBackoffInterval;
  private Integer requestTimeout;
  private Long scaleTimeout;
  private Integer loggingInterval;
  private String impersonateUsername;
  private List<String> impersonateGroups = new ArrayList<String>();
  private Map<String,List<String>> impersonateExtras = new LinkedHashMap<String,List<String>>();
  private Boolean http2Disable;
  private String httpProxy;
  private String httpsProxy;
  private String proxyUsername;
  private String proxyPassword;
  private List<String> noProxy = new ArrayList<String>();
  private String userAgent;
  private List<TlsVersion> tlsVersions = new ArrayList<TlsVersion>();
  private Boolean onlyHttpWatches;
  private Map<Integer,String> errorMessages = new LinkedHashMap<Integer,String>();
  private Map<String,String> customHeaders = new LinkedHashMap<String,String>();
  private Boolean autoConfigure;
  private File file;
  
  protected void copyInstance(SundrioConfig instance) {
    if (instance != null) {
          this.withMasterUrl(instance.getMasterUrl());
          this.withApiVersion(instance.getApiVersion());
          this.withNamespace(instance.getNamespace());
          this.withTrustCerts(instance.isTrustCerts());
          this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
          this.withCaCertFile(instance.getCaCertFile());
          this.withCaCertData(instance.getCaCertData());
          this.withClientCertFile(instance.getClientCertFile());
          this.withClientCertData(instance.getClientCertData());
          this.withClientKeyFile(instance.getClientKeyFile());
          this.withClientKeyData(instance.getClientKeyData());
          this.withClientKeyAlgo(instance.getClientKeyAlgo());
          this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
          this.withUsername(instance.getUsername());
          this.withPassword(instance.getPassword());
          this.withOauthToken(instance.getOauthToken());
          this.withAutoOAuthToken(instance.getAutoOAuthToken());
          this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
          this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
          this.withConnectionTimeout(instance.getConnectionTimeout());
          this.withRequestTimeout(instance.getRequestTimeout());
          this.withScaleTimeout(instance.getScaleTimeout());
          this.withLoggingInterval(instance.getLoggingInterval());
          this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
          this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
          this.withHttp2Disable(instance.isHttp2Disable());
          this.withHttpProxy(instance.getHttpProxy());
          this.withHttpsProxy(instance.getHttpsProxy());
          this.withNoProxy(instance.getNoProxy());
          this.withUserAgent(instance.getUserAgent());
          this.withTlsVersions(instance.getTlsVersions());
          this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
          this.withProxyUsername(instance.getProxyUsername());
          this.withProxyPassword(instance.getProxyPassword());
          this.withTrustStoreFile(instance.getTrustStoreFile());
          this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
          this.withKeyStoreFile(instance.getKeyStoreFile());
          this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
          this.withImpersonateUsername(instance.getImpersonateUsername());
          this.withImpersonateGroups(instance.getImpersonateGroups());
          this.withImpersonateExtras(instance.getImpersonateExtras());
          this.withOauthTokenProvider(instance.getOauthTokenProvider());
          this.withCustomHeaders(instance.getCustomHeaders());
          this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
          this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
          this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
          this.withOnlyHttpWatches(instance.isOnlyHttpWatches());
          this.withCurrentContext(instance.getCurrentContext());
          this.withContexts(instance.getContexts());
          this.withAutoConfigure(instance.getAutoConfigure());
          this.withAuthProvider(instance.getAuthProvider());
          this.withErrorMessages(instance.getErrorMessages());
          this.withFile(instance.getFile());
        }
  }
  
  public Boolean getTrustCerts() {
    return this.trustCerts;
  }
  
  public A withTrustCerts(Boolean trustCerts) {
    this.trustCerts = trustCerts;
    return (A) this;
  }
  
  public boolean hasTrustCerts() {
    return this.trustCerts != null;
  }
  
  public Boolean getDisableHostnameVerification() {
    return this.disableHostnameVerification;
  }
  
  public A withDisableHostnameVerification(Boolean disableHostnameVerification) {
    this.disableHostnameVerification = disableHostnameVerification;
    return (A) this;
  }
  
  public boolean hasDisableHostnameVerification() {
    return this.disableHostnameVerification != null;
  }
  
  public String getMasterUrl() {
    return this.masterUrl;
  }
  
  public A withMasterUrl(String masterUrl) {
    this.masterUrl = masterUrl;
    return (A) this;
  }
  
  public boolean hasMasterUrl() {
    return this.masterUrl != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getCaCertFile() {
    return this.caCertFile;
  }
  
  public A withCaCertFile(String caCertFile) {
    this.caCertFile = caCertFile;
    return (A) this;
  }
  
  public boolean hasCaCertFile() {
    return this.caCertFile != null;
  }
  
  public String getCaCertData() {
    return this.caCertData;
  }
  
  public A withCaCertData(String caCertData) {
    this.caCertData = caCertData;
    return (A) this;
  }
  
  public boolean hasCaCertData() {
    return this.caCertData != null;
  }
  
  public String getClientCertFile() {
    return this.clientCertFile;
  }
  
  public A withClientCertFile(String clientCertFile) {
    this.clientCertFile = clientCertFile;
    return (A) this;
  }
  
  public boolean hasClientCertFile() {
    return this.clientCertFile != null;
  }
  
  public String getClientCertData() {
    return this.clientCertData;
  }
  
  public A withClientCertData(String clientCertData) {
    this.clientCertData = clientCertData;
    return (A) this;
  }
  
  public boolean hasClientCertData() {
    return this.clientCertData != null;
  }
  
  public String getClientKeyFile() {
    return this.clientKeyFile;
  }
  
  public A withClientKeyFile(String clientKeyFile) {
    this.clientKeyFile = clientKeyFile;
    return (A) this;
  }
  
  public boolean hasClientKeyFile() {
    return this.clientKeyFile != null;
  }
  
  public String getClientKeyData() {
    return this.clientKeyData;
  }
  
  public A withClientKeyData(String clientKeyData) {
    this.clientKeyData = clientKeyData;
    return (A) this;
  }
  
  public boolean hasClientKeyData() {
    return this.clientKeyData != null;
  }
  
  public String getClientKeyAlgo() {
    return this.clientKeyAlgo;
  }
  
  public A withClientKeyAlgo(String clientKeyAlgo) {
    this.clientKeyAlgo = clientKeyAlgo;
    return (A) this;
  }
  
  public boolean hasClientKeyAlgo() {
    return this.clientKeyAlgo != null;
  }
  
  public String getClientKeyPassphrase() {
    return this.clientKeyPassphrase;
  }
  
  public A withClientKeyPassphrase(String clientKeyPassphrase) {
    this.clientKeyPassphrase = clientKeyPassphrase;
    return (A) this;
  }
  
  public boolean hasClientKeyPassphrase() {
    return this.clientKeyPassphrase != null;
  }
  
  public String getTrustStoreFile() {
    return this.trustStoreFile;
  }
  
  public A withTrustStoreFile(String trustStoreFile) {
    this.trustStoreFile = trustStoreFile;
    return (A) this;
  }
  
  public boolean hasTrustStoreFile() {
    return this.trustStoreFile != null;
  }
  
  public String getTrustStorePassphrase() {
    return this.trustStorePassphrase;
  }
  
  public A withTrustStorePassphrase(String trustStorePassphrase) {
    this.trustStorePassphrase = trustStorePassphrase;
    return (A) this;
  }
  
  public boolean hasTrustStorePassphrase() {
    return this.trustStorePassphrase != null;
  }
  
  public String getKeyStoreFile() {
    return this.keyStoreFile;
  }
  
  public A withKeyStoreFile(String keyStoreFile) {
    this.keyStoreFile = keyStoreFile;
    return (A) this;
  }
  
  public boolean hasKeyStoreFile() {
    return this.keyStoreFile != null;
  }
  
  public String getKeyStorePassphrase() {
    return this.keyStorePassphrase;
  }
  
  public A withKeyStorePassphrase(String keyStorePassphrase) {
    this.keyStorePassphrase = keyStorePassphrase;
    return (A) this;
  }
  
  public boolean hasKeyStorePassphrase() {
    return this.keyStorePassphrase != null;
  }
  
  public AuthProviderConfig getAuthProvider() {
    return this.authProvider;
  }
  
  public A withAuthProvider(AuthProviderConfig authProvider) {
    this.authProvider = authProvider;
    return (A) this;
  }
  
  public boolean hasAuthProvider() {
    return this.authProvider != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public String getOauthToken() {
    return this.oauthToken;
  }
  
  public A withOauthToken(String oauthToken) {
    this.oauthToken = oauthToken;
    return (A) this;
  }
  
  public boolean hasOauthToken() {
    return this.oauthToken != null;
  }
  
  public String getAutoOAuthToken() {
    return this.autoOAuthToken;
  }
  
  public A withAutoOAuthToken(String autoOAuthToken) {
    this.autoOAuthToken = autoOAuthToken;
    return (A) this;
  }
  
  public boolean hasAutoOAuthToken() {
    return this.autoOAuthToken != null;
  }
  
  public OAuthTokenProvider getOauthTokenProvider() {
    return this.oauthTokenProvider;
  }
  
  public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
    this.oauthTokenProvider = oauthTokenProvider;
    return (A) this;
  }
  
  public boolean hasOauthTokenProvider() {
    return this.oauthTokenProvider != null;
  }
  
  public Long getWebsocketPingInterval() {
    return this.websocketPingInterval;
  }
  
  public A withWebsocketPingInterval(Long websocketPingInterval) {
    this.websocketPingInterval = websocketPingInterval;
    return (A) this;
  }
  
  public boolean hasWebsocketPingInterval() {
    return this.websocketPingInterval != null;
  }
  
  public Integer getConnectionTimeout() {
    return this.connectionTimeout;
  }
  
  public A withConnectionTimeout(Integer connectionTimeout) {
    this.connectionTimeout = connectionTimeout;
    return (A) this;
  }
  
  public boolean hasConnectionTimeout() {
    return this.connectionTimeout != null;
  }
  
  public Integer getMaxConcurrentRequests() {
    return this.maxConcurrentRequests;
  }
  
  public A withMaxConcurrentRequests(Integer maxConcurrentRequests) {
    this.maxConcurrentRequests = maxConcurrentRequests;
    return (A) this;
  }
  
  public boolean hasMaxConcurrentRequests() {
    return this.maxConcurrentRequests != null;
  }
  
  public Integer getMaxConcurrentRequestsPerHost() {
    return this.maxConcurrentRequestsPerHost;
  }
  
  public A withMaxConcurrentRequestsPerHost(Integer maxConcurrentRequestsPerHost) {
    this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
    return (A) this;
  }
  
  public boolean hasMaxConcurrentRequestsPerHost() {
    return this.maxConcurrentRequestsPerHost != null;
  }
  
  public A addToContexts(int index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    this.contexts.add(index, item);
    return (A)this;
  }
  
  public A setToContexts(int index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    this.contexts.set(index, item); return (A)this;
  }
  
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    for (NamedContext item : items) {this.contexts.add(item);} return (A)this;
  }
  
  public A addAllToContexts(Collection<NamedContext> items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    for (NamedContext item : items) {this.contexts.add(item);} return (A)this;
  }
  
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) return (A)this;
    for (NamedContext item : items) { this.contexts.remove(item);} return (A)this;
  }
  
  public A removeAllFromContexts(Collection<NamedContext> items) {
    if (this.contexts == null) return (A)this;
    for (NamedContext item : items) { this.contexts.remove(item);} return (A)this;
  }
  
  public List<NamedContext> getContexts() {
    return this.contexts;
  }
  
  public NamedContext getContext(int index) {
    return this.contexts.get(index);
  }
  
  public NamedContext getFirstContext() {
    return this.contexts.get(0);
  }
  
  public NamedContext getLastContext() {
    return this.contexts.get(contexts.size() - 1);
  }
  
  public NamedContext getMatchingContext(Predicate<NamedContext> predicate) {
      for (NamedContext item : contexts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingContext(Predicate<NamedContext> predicate) {
      for (NamedContext item : contexts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContexts(List<NamedContext> contexts) {
    if (contexts != null) {
        this.contexts = new ArrayList();
        for (NamedContext item : contexts) {
          this.addToContexts(item);
        }
    } else {
      this.contexts = null;
    }
    return (A) this;
  }
  
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
    if (this.contexts != null) {
        this.contexts.clear();
        _visitables.remove("contexts");
    }
    if (contexts != null) {
      for (NamedContext item : contexts) {
        this.addToContexts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContexts() {
    return this.contexts != null && !this.contexts.isEmpty();
  }
  
  public NamedContext getCurrentContext() {
    return this.currentContext;
  }
  
  public A withCurrentContext(NamedContext currentContext) {
    this.currentContext = currentContext;
    return (A) this;
  }
  
  public boolean hasCurrentContext() {
    return this.currentContext != null;
  }
  
  public Integer getWatchReconnectInterval() {
    return this.watchReconnectInterval;
  }
  
  public A withWatchReconnectInterval(Integer watchReconnectInterval) {
    this.watchReconnectInterval = watchReconnectInterval;
    return (A) this;
  }
  
  public boolean hasWatchReconnectInterval() {
    return this.watchReconnectInterval != null;
  }
  
  public Integer getWatchReconnectLimit() {
    return this.watchReconnectLimit;
  }
  
  public A withWatchReconnectLimit(Integer watchReconnectLimit) {
    this.watchReconnectLimit = watchReconnectLimit;
    return (A) this;
  }
  
  public boolean hasWatchReconnectLimit() {
    return this.watchReconnectLimit != null;
  }
  
  public Integer getUploadRequestTimeout() {
    return this.uploadRequestTimeout;
  }
  
  public A withUploadRequestTimeout(Integer uploadRequestTimeout) {
    this.uploadRequestTimeout = uploadRequestTimeout;
    return (A) this;
  }
  
  public boolean hasUploadRequestTimeout() {
    return this.uploadRequestTimeout != null;
  }
  
  public Integer getRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit;
  }
  
  public A withRequestRetryBackoffLimit(Integer requestRetryBackoffLimit) {
    this.requestRetryBackoffLimit = requestRetryBackoffLimit;
    return (A) this;
  }
  
  public boolean hasRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit != null;
  }
  
  public Integer getRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval;
  }
  
  public A withRequestRetryBackoffInterval(Integer requestRetryBackoffInterval) {
    this.requestRetryBackoffInterval = requestRetryBackoffInterval;
    return (A) this;
  }
  
  public boolean hasRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval != null;
  }
  
  public Integer getRequestTimeout() {
    return this.requestTimeout;
  }
  
  public A withRequestTimeout(Integer requestTimeout) {
    this.requestTimeout = requestTimeout;
    return (A) this;
  }
  
  public boolean hasRequestTimeout() {
    return this.requestTimeout != null;
  }
  
  public Long getScaleTimeout() {
    return this.scaleTimeout;
  }
  
  public A withScaleTimeout(Long scaleTimeout) {
    this.scaleTimeout = scaleTimeout;
    return (A) this;
  }
  
  public boolean hasScaleTimeout() {
    return this.scaleTimeout != null;
  }
  
  public Integer getLoggingInterval() {
    return this.loggingInterval;
  }
  
  public A withLoggingInterval(Integer loggingInterval) {
    this.loggingInterval = loggingInterval;
    return (A) this;
  }
  
  public boolean hasLoggingInterval() {
    return this.loggingInterval != null;
  }
  
  public String getImpersonateUsername() {
    return this.impersonateUsername;
  }
  
  public A withImpersonateUsername(String impersonateUsername) {
    this.impersonateUsername = impersonateUsername;
    return (A) this;
  }
  
  public boolean hasImpersonateUsername() {
    return this.impersonateUsername != null;
  }
  
  public A withImpersonateGroups(java.lang.String... impersonateGroups) {
    if (this.impersonateGroups != null) {
        this.impersonateGroups.clear();
        _visitables.remove("impersonateGroups");
    }
    if (impersonateGroups != null) {
      for (String item : impersonateGroups) {
        this.addToImpersonateGroups(item);
      }
    }
    return (A) this;
  }
  
  public String[] getImpersonateGroups() {
    int size = impersonateGroups != null ? impersonateGroups.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : impersonateGroups) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.add(index, item);
    return (A)this;
  }
  
  public A setToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.set(index, item); return (A)this;
  }
  
  public A addToImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  
  public A addAllToImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  
  public A removeFromImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  
  public A removeAllFromImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  
  public boolean hasImpersonateGroups() {
    return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
  }
  
  public A addToImpersonateExtras(String key,List<String> value) {
    if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
  }
  
  public A addToImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
  }
  
  public A removeFromImpersonateExtras(String key) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
  }
  
  public A removeFromImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<String>> getImpersonateExtras() {
    return this.impersonateExtras;
  }
  
  public <K,V>A withImpersonateExtras(Map<String,List<String>> impersonateExtras) {
    if (impersonateExtras == null) {
      this.impersonateExtras = null;
    } else {
      this.impersonateExtras = new LinkedHashMap(impersonateExtras);
    }
    return (A) this;
  }
  
  public boolean hasImpersonateExtras() {
    return this.impersonateExtras != null;
  }
  
  public Boolean getHttp2Disable() {
    return this.http2Disable;
  }
  
  public A withHttp2Disable(Boolean http2Disable) {
    this.http2Disable = http2Disable;
    return (A) this;
  }
  
  public boolean hasHttp2Disable() {
    return this.http2Disable != null;
  }
  
  public String getHttpProxy() {
    return this.httpProxy;
  }
  
  public A withHttpProxy(String httpProxy) {
    this.httpProxy = httpProxy;
    return (A) this;
  }
  
  public boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy = httpsProxy;
    return (A) this;
  }
  
  public boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  
  public String getProxyUsername() {
    return this.proxyUsername;
  }
  
  public A withProxyUsername(String proxyUsername) {
    this.proxyUsername = proxyUsername;
    return (A) this;
  }
  
  public boolean hasProxyUsername() {
    return this.proxyUsername != null;
  }
  
  public String getProxyPassword() {
    return this.proxyPassword;
  }
  
  public A withProxyPassword(String proxyPassword) {
    this.proxyPassword = proxyPassword;
    return (A) this;
  }
  
  public boolean hasProxyPassword() {
    return this.proxyPassword != null;
  }
  
  public A withNoProxy(java.lang.String... noProxy) {
    if (this.noProxy != null) {
        this.noProxy.clear();
        _visitables.remove("noProxy");
    }
    if (noProxy != null) {
      for (String item : noProxy) {
        this.addToNoProxy(item);
      }
    }
    return (A) this;
  }
  
  public String[] getNoProxy() {
    int size = noProxy != null ? noProxy.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : noProxy) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToNoProxy(int index,String item) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    this.noProxy.add(index, item);
    return (A)this;
  }
  
  public A setToNoProxy(int index,String item) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    this.noProxy.set(index, item); return (A)this;
  }
  
  public A addToNoProxy(java.lang.String... items) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    for (String item : items) {this.noProxy.add(item);} return (A)this;
  }
  
  public A addAllToNoProxy(Collection<String> items) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    for (String item : items) {this.noProxy.add(item);} return (A)this;
  }
  
  public A removeFromNoProxy(java.lang.String... items) {
    if (this.noProxy == null) return (A)this;
    for (String item : items) { this.noProxy.remove(item);} return (A)this;
  }
  
  public A removeAllFromNoProxy(Collection<String> items) {
    if (this.noProxy == null) return (A)this;
    for (String item : items) { this.noProxy.remove(item);} return (A)this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null && !this.noProxy.isEmpty();
  }
  
  public String getUserAgent() {
    return this.userAgent;
  }
  
  public A withUserAgent(String userAgent) {
    this.userAgent = userAgent;
    return (A) this;
  }
  
  public boolean hasUserAgent() {
    return this.userAgent != null;
  }
  
  public A withTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... tlsVersions) {
    if (this.tlsVersions != null) {
        this.tlsVersions.clear();
        _visitables.remove("tlsVersions");
    }
    if (tlsVersions != null) {
      for (TlsVersion item : tlsVersions) {
        this.addToTlsVersions(item);
      }
    }
    return (A) this;
  }
  
  public TlsVersion[] getTlsVersions() {
    int size = tlsVersions != null ? tlsVersions.size() : 0;;
    TlsVersion[] result = new TlsVersion[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (TlsVersion item : tlsVersions) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToTlsVersions(int index,TlsVersion item) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    this.tlsVersions.add(index, item);
    return (A)this;
  }
  
  public A setToTlsVersions(int index,TlsVersion item) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    this.tlsVersions.set(index, item); return (A)this;
  }
  
  public A addToTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    for (TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
  }
  
  public A addAllToTlsVersions(Collection<TlsVersion> items) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    for (TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
  }
  
  public A removeFromTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items) {
    if (this.tlsVersions == null) return (A)this;
    for (TlsVersion item : items) { this.tlsVersions.remove(item);} return (A)this;
  }
  
  public A removeAllFromTlsVersions(Collection<TlsVersion> items) {
    if (this.tlsVersions == null) return (A)this;
    for (TlsVersion item : items) { this.tlsVersions.remove(item);} return (A)this;
  }
  
  public boolean hasTlsVersions() {
    return this.tlsVersions != null && !this.tlsVersions.isEmpty();
  }
  
  public Boolean getOnlyHttpWatches() {
    return this.onlyHttpWatches;
  }
  
  public A withOnlyHttpWatches(Boolean onlyHttpWatches) {
    this.onlyHttpWatches = onlyHttpWatches;
    return (A) this;
  }
  
  public boolean hasOnlyHttpWatches() {
    return this.onlyHttpWatches != null;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addToErrorMessages(Integer key,String value) {
    if(this.errorMessages == null && key != null && value != null) { this.errorMessages = new LinkedHashMap(); }
    if(key != null && value != null) {this.errorMessages.put(key, value);} return (A)this;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addToErrorMessages(Map<Integer,String> map) {
    if(this.errorMessages == null && map != null) { this.errorMessages = new LinkedHashMap(); }
    if(map != null) { this.errorMessages.putAll(map);} return (A)this;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A removeFromErrorMessages(Integer key) {
    if(this.errorMessages == null) { return (A) this; }
    if(key != null && this.errorMessages != null) {this.errorMessages.remove(key);} return (A)this;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A removeFromErrorMessages(Map<Integer,String> map) {
    if(this.errorMessages == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.errorMessages != null){this.errorMessages.remove(key);}}} return (A)this;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public Map<Integer,String> getErrorMessages() {
    return this.errorMessages;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public <K,V>A withErrorMessages(Map<Integer,String> errorMessages) {
    if (errorMessages == null) {
      this.errorMessages = null;
    } else {
      this.errorMessages = new LinkedHashMap(errorMessages);
    }
    return (A) this;
  }
  
  
  /**
   * The field errorMessages has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public boolean hasErrorMessages() {
    return this.errorMessages != null;
  }
  
  public A addToCustomHeaders(String key,String value) {
    if(this.customHeaders == null && key != null && value != null) { this.customHeaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.customHeaders.put(key, value);} return (A)this;
  }
  
  public A addToCustomHeaders(Map<String,String> map) {
    if(this.customHeaders == null && map != null) { this.customHeaders = new LinkedHashMap(); }
    if(map != null) { this.customHeaders.putAll(map);} return (A)this;
  }
  
  public A removeFromCustomHeaders(String key) {
    if(this.customHeaders == null) { return (A) this; }
    if(key != null && this.customHeaders != null) {this.customHeaders.remove(key);} return (A)this;
  }
  
  public A removeFromCustomHeaders(Map<String,String> map) {
    if(this.customHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.customHeaders != null){this.customHeaders.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getCustomHeaders() {
    return this.customHeaders;
  }
  
  public <K,V>A withCustomHeaders(Map<String,String> customHeaders) {
    if (customHeaders == null) {
      this.customHeaders = null;
    } else {
      this.customHeaders = new LinkedHashMap(customHeaders);
    }
    return (A) this;
  }
  
  public boolean hasCustomHeaders() {
    return this.customHeaders != null;
  }
  
  public Boolean getAutoConfigure() {
    return this.autoConfigure;
  }
  
  public A withAutoConfigure(Boolean autoConfigure) {
    this.autoConfigure = autoConfigure;
    return (A) this;
  }
  
  public boolean hasAutoConfigure() {
    return this.autoConfigure != null;
  }
  
  public File getFile() {
    return this.file;
  }
  
  public A withFile(File file) {
    this.file = file;
    return (A) this;
  }
  
  public boolean hasFile() {
    return this.file != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SundrioConfigFluent that = (SundrioConfigFluent) o;
    if (!java.util.Objects.equals(trustCerts, that.trustCerts)) return false;
    if (!java.util.Objects.equals(disableHostnameVerification, that.disableHostnameVerification)) return false;
    if (!java.util.Objects.equals(masterUrl, that.masterUrl)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(caCertFile, that.caCertFile)) return false;
    if (!java.util.Objects.equals(caCertData, that.caCertData)) return false;
    if (!java.util.Objects.equals(clientCertFile, that.clientCertFile)) return false;
    if (!java.util.Objects.equals(clientCertData, that.clientCertData)) return false;
    if (!java.util.Objects.equals(clientKeyFile, that.clientKeyFile)) return false;
    if (!java.util.Objects.equals(clientKeyData, that.clientKeyData)) return false;
    if (!java.util.Objects.equals(clientKeyAlgo, that.clientKeyAlgo)) return false;
    if (!java.util.Objects.equals(clientKeyPassphrase, that.clientKeyPassphrase)) return false;
    if (!java.util.Objects.equals(trustStoreFile, that.trustStoreFile)) return false;
    if (!java.util.Objects.equals(trustStorePassphrase, that.trustStorePassphrase)) return false;
    if (!java.util.Objects.equals(keyStoreFile, that.keyStoreFile)) return false;
    if (!java.util.Objects.equals(keyStorePassphrase, that.keyStorePassphrase)) return false;
    if (!java.util.Objects.equals(authProvider, that.authProvider)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (!java.util.Objects.equals(oauthToken, that.oauthToken)) return false;
    if (!java.util.Objects.equals(autoOAuthToken, that.autoOAuthToken)) return false;
    if (!java.util.Objects.equals(oauthTokenProvider, that.oauthTokenProvider)) return false;
    if (!java.util.Objects.equals(websocketPingInterval, that.websocketPingInterval)) return false;
    if (!java.util.Objects.equals(connectionTimeout, that.connectionTimeout)) return false;
    if (!java.util.Objects.equals(maxConcurrentRequests, that.maxConcurrentRequests)) return false;
    if (!java.util.Objects.equals(maxConcurrentRequestsPerHost, that.maxConcurrentRequestsPerHost)) return false;
    if (!java.util.Objects.equals(contexts, that.contexts)) return false;
    if (!java.util.Objects.equals(currentContext, that.currentContext)) return false;
    if (!java.util.Objects.equals(watchReconnectInterval, that.watchReconnectInterval)) return false;
    if (!java.util.Objects.equals(watchReconnectLimit, that.watchReconnectLimit)) return false;
    if (!java.util.Objects.equals(uploadRequestTimeout, that.uploadRequestTimeout)) return false;
    if (!java.util.Objects.equals(requestRetryBackoffLimit, that.requestRetryBackoffLimit)) return false;
    if (!java.util.Objects.equals(requestRetryBackoffInterval, that.requestRetryBackoffInterval)) return false;
    if (!java.util.Objects.equals(requestTimeout, that.requestTimeout)) return false;
    if (!java.util.Objects.equals(scaleTimeout, that.scaleTimeout)) return false;
    if (!java.util.Objects.equals(loggingInterval, that.loggingInterval)) return false;
    if (!java.util.Objects.equals(impersonateUsername, that.impersonateUsername)) return false;
    if (!java.util.Objects.equals(impersonateGroups, that.impersonateGroups)) return false;
    if (!java.util.Objects.equals(impersonateExtras, that.impersonateExtras)) return false;
    if (!java.util.Objects.equals(http2Disable, that.http2Disable)) return false;
    if (!java.util.Objects.equals(httpProxy, that.httpProxy)) return false;
    if (!java.util.Objects.equals(httpsProxy, that.httpsProxy)) return false;
    if (!java.util.Objects.equals(proxyUsername, that.proxyUsername)) return false;
    if (!java.util.Objects.equals(proxyPassword, that.proxyPassword)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(userAgent, that.userAgent)) return false;
    if (!java.util.Objects.equals(tlsVersions, that.tlsVersions)) return false;
    if (!java.util.Objects.equals(onlyHttpWatches, that.onlyHttpWatches)) return false;
    if (!java.util.Objects.equals(errorMessages, that.errorMessages)) return false;
    if (!java.util.Objects.equals(customHeaders, that.customHeaders)) return false;
    if (!java.util.Objects.equals(autoConfigure, that.autoConfigure)) return false;
    if (!java.util.Objects.equals(file, that.file)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(trustCerts,  disableHostnameVerification,  masterUrl,  apiVersion,  namespace,  caCertFile,  caCertData,  clientCertFile,  clientCertData,  clientKeyFile,  clientKeyData,  clientKeyAlgo,  clientKeyPassphrase,  trustStoreFile,  trustStorePassphrase,  keyStoreFile,  keyStorePassphrase,  authProvider,  username,  password,  oauthToken,  autoOAuthToken,  oauthTokenProvider,  websocketPingInterval,  connectionTimeout,  maxConcurrentRequests,  maxConcurrentRequestsPerHost,  contexts,  currentContext,  watchReconnectInterval,  watchReconnectLimit,  uploadRequestTimeout,  requestRetryBackoffLimit,  requestRetryBackoffInterval,  requestTimeout,  scaleTimeout,  loggingInterval,  impersonateUsername,  impersonateGroups,  impersonateExtras,  http2Disable,  httpProxy,  httpsProxy,  proxyUsername,  proxyPassword,  noProxy,  userAgent,  tlsVersions,  onlyHttpWatches,  errorMessages,  customHeaders,  autoConfigure,  file,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (trustCerts != null) { sb.append("trustCerts:"); sb.append(trustCerts + ","); }
    if (disableHostnameVerification != null) { sb.append("disableHostnameVerification:"); sb.append(disableHostnameVerification + ","); }
    if (masterUrl != null) { sb.append("masterUrl:"); sb.append(masterUrl + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (caCertFile != null) { sb.append("caCertFile:"); sb.append(caCertFile + ","); }
    if (caCertData != null) { sb.append("caCertData:"); sb.append(caCertData + ","); }
    if (clientCertFile != null) { sb.append("clientCertFile:"); sb.append(clientCertFile + ","); }
    if (clientCertData != null) { sb.append("clientCertData:"); sb.append(clientCertData + ","); }
    if (clientKeyFile != null) { sb.append("clientKeyFile:"); sb.append(clientKeyFile + ","); }
    if (clientKeyData != null) { sb.append("clientKeyData:"); sb.append(clientKeyData + ","); }
    if (clientKeyAlgo != null) { sb.append("clientKeyAlgo:"); sb.append(clientKeyAlgo + ","); }
    if (clientKeyPassphrase != null) { sb.append("clientKeyPassphrase:"); sb.append(clientKeyPassphrase + ","); }
    if (trustStoreFile != null) { sb.append("trustStoreFile:"); sb.append(trustStoreFile + ","); }
    if (trustStorePassphrase != null) { sb.append("trustStorePassphrase:"); sb.append(trustStorePassphrase + ","); }
    if (keyStoreFile != null) { sb.append("keyStoreFile:"); sb.append(keyStoreFile + ","); }
    if (keyStorePassphrase != null) { sb.append("keyStorePassphrase:"); sb.append(keyStorePassphrase + ","); }
    if (authProvider != null) { sb.append("authProvider:"); sb.append(authProvider + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (oauthToken != null) { sb.append("oauthToken:"); sb.append(oauthToken + ","); }
    if (autoOAuthToken != null) { sb.append("autoOAuthToken:"); sb.append(autoOAuthToken + ","); }
    if (oauthTokenProvider != null) { sb.append("oauthTokenProvider:"); sb.append(oauthTokenProvider + ","); }
    if (websocketPingInterval != null) { sb.append("websocketPingInterval:"); sb.append(websocketPingInterval + ","); }
    if (connectionTimeout != null) { sb.append("connectionTimeout:"); sb.append(connectionTimeout + ","); }
    if (maxConcurrentRequests != null) { sb.append("maxConcurrentRequests:"); sb.append(maxConcurrentRequests + ","); }
    if (maxConcurrentRequestsPerHost != null) { sb.append("maxConcurrentRequestsPerHost:"); sb.append(maxConcurrentRequestsPerHost + ","); }
    if (contexts != null && !contexts.isEmpty()) { sb.append("contexts:"); sb.append(contexts + ","); }
    if (currentContext != null) { sb.append("currentContext:"); sb.append(currentContext + ","); }
    if (watchReconnectInterval != null) { sb.append("watchReconnectInterval:"); sb.append(watchReconnectInterval + ","); }
    if (watchReconnectLimit != null) { sb.append("watchReconnectLimit:"); sb.append(watchReconnectLimit + ","); }
    if (uploadRequestTimeout != null) { sb.append("uploadRequestTimeout:"); sb.append(uploadRequestTimeout + ","); }
    if (requestRetryBackoffLimit != null) { sb.append("requestRetryBackoffLimit:"); sb.append(requestRetryBackoffLimit + ","); }
    if (requestRetryBackoffInterval != null) { sb.append("requestRetryBackoffInterval:"); sb.append(requestRetryBackoffInterval + ","); }
    if (requestTimeout != null) { sb.append("requestTimeout:"); sb.append(requestTimeout + ","); }
    if (scaleTimeout != null) { sb.append("scaleTimeout:"); sb.append(scaleTimeout + ","); }
    if (loggingInterval != null) { sb.append("loggingInterval:"); sb.append(loggingInterval + ","); }
    if (impersonateUsername != null) { sb.append("impersonateUsername:"); sb.append(impersonateUsername + ","); }
    if (impersonateGroups != null && !impersonateGroups.isEmpty()) { sb.append("impersonateGroups:"); sb.append(impersonateGroups + ","); }
    if (impersonateExtras != null && !impersonateExtras.isEmpty()) { sb.append("impersonateExtras:"); sb.append(impersonateExtras + ","); }
    if (http2Disable != null) { sb.append("http2Disable:"); sb.append(http2Disable + ","); }
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (proxyUsername != null) { sb.append("proxyUsername:"); sb.append(proxyUsername + ","); }
    if (proxyPassword != null) { sb.append("proxyPassword:"); sb.append(proxyPassword + ","); }
    if (noProxy != null && !noProxy.isEmpty()) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (userAgent != null) { sb.append("userAgent:"); sb.append(userAgent + ","); }
    if (tlsVersions != null && !tlsVersions.isEmpty()) { sb.append("tlsVersions:"); sb.append(tlsVersions + ","); }
    if (onlyHttpWatches != null) { sb.append("onlyHttpWatches:"); sb.append(onlyHttpWatches + ","); }
    if (errorMessages != null && !errorMessages.isEmpty()) { sb.append("errorMessages:"); sb.append(errorMessages + ","); }
    if (customHeaders != null && !customHeaders.isEmpty()) { sb.append("customHeaders:"); sb.append(customHeaders + ","); }
    if (autoConfigure != null) { sb.append("autoConfigure:"); sb.append(autoConfigure + ","); }
    if (file != null) { sb.append("file:"); sb.append(file); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withTrustCerts() {
    return withTrustCerts(true);
  }
  
  public A withDisableHostnameVerification() {
    return withDisableHostnameVerification(true);
  }
  
  public A withHttp2Disable() {
    return withHttp2Disable(true);
  }
  
  public A withOnlyHttpWatches() {
    return withOnlyHttpWatches(true);
  }
  
  public A withAutoConfigure() {
    return withAutoConfigure(true);
  }
  

}