/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.duck.v1.CloudEventOverrides;
import io.fabric8.knative.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.duck.v1.CloudEventOverridesFluent;
import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.sources.v1.PingSourceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PingSourceSpecFluent<A extends PingSourceSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private CloudEventOverridesBuilder ceOverrides;
    private String contentType;
    private String data;
    private String dataBase64;
    private String schedule;
    private DestinationBuilder sink;
    private String timezone;

    public PingSourceSpecFluent() {
    }

    public PingSourceSpecFluent(PingSourceSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    protected void copyInstance(PingSourceSpec instance) {
        PingSourceSpec pingSourceSpec = instance = instance != null ? instance : new PingSourceSpec();
        if (instance != null) {
            this.withCeOverrides(instance.getCeOverrides());
            this.withContentType(instance.getContentType());
            this.withData(instance.getData());
            this.withDataBase64(instance.getDataBase64());
            this.withSchedule(instance.getSchedule());
            this.withSink(instance.getSink());
            this.withTimezone(instance.getTimezone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(null));
    }

    public CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
    }

    public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(item));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PingSourceSpecFluent that = (PingSourceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.ceOverrides, (Object)that.ceOverrides)) {
            return false;
        }
        if (!Objects.equals(this.contentType, that.contentType)) {
            return false;
        }
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.dataBase64, that.dataBase64)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        if (!Objects.equals(this.timezone, that.timezone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getData() {
        return this.data;
    }

    public String getDataBase64() {
        return this.dataBase64;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public boolean hasContentType() {
        return this.contentType != null;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasDataBase64() {
        return this.dataBase64 != null;
    }

    public boolean hasSchedule() {
        return this.schedule != null;
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public boolean hasTimezone() {
        return this.timezone != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ceOverrides, this.contentType, this.data, this.dataBase64, this.schedule, this.sink, this.timezone, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ceOverrides != null) {
            sb.append("ceOverrides:");
            sb.append((Object)this.ceOverrides);
            sb.append(",");
        }
        if (this.contentType != null) {
            sb.append("contentType:");
            sb.append(this.contentType);
            sb.append(",");
        }
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data);
            sb.append(",");
        }
        if (this.dataBase64 != null) {
            sb.append("dataBase64:");
            sb.append(this.dataBase64);
            sb.append(",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule);
            sb.append(",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append((Object)this.sink);
            sb.append(",");
        }
        if (this.timezone != null) {
            sb.append("timezone:");
            sb.append(this.timezone);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.remove((Object)"ceOverrides");
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        } else {
            this.ceOverrides = null;
            this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        }
        return (A)((Object)this);
    }

    public A withContentType(String contentType) {
        this.contentType = contentType;
        return (A)((Object)this);
    }

    public A withData(String data) {
        this.data = data;
        return (A)((Object)this);
    }

    public A withDataBase64(String dataBase64) {
        this.dataBase64 = dataBase64;
        return (A)((Object)this);
    }

    public CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNested(null);
    }

    public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNested(item);
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)((Object)this);
    }

    public A withSink(Destination sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public A withTimezone(String timezone) {
        this.timezone = timezone;
        return (A)((Object)this);
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)PingSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class CeOverridesNested<N>
    extends CloudEventOverridesFluent<CeOverridesNested<N>>
    implements Nested<N> {
        CloudEventOverridesBuilder builder;

        CeOverridesNested(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        public N and() {
            return (N)PingSourceSpecFluent.this.withCeOverrides(this.builder.build());
        }

        public N endCeOverrides() {
            return this.and();
        }
    }
}

