/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.duck.v1.DeliverySpec;
import io.fabric8.knative.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.duck.v1.KReference;
import io.fabric8.knative.duck.v1.KReferenceBuilder;
import io.fabric8.knative.duck.v1.KReferenceFluent;
import io.fabric8.knative.messaging.v1.SubscriptionSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private KReferenceBuilder channel;
    private DeliverySpecBuilder delivery;
    private DestinationBuilder reply;
    private DestinationBuilder subscriber;

    public SubscriptionSpecFluent() {
    }

    public SubscriptionSpecFluent(SubscriptionSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public KReference buildChannel() {
        return this.channel != null ? this.channel.build() : null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    public Destination buildReply() {
        return this.reply != null ? this.reply.build() : null;
    }

    public Destination buildSubscriber() {
        return this.subscriber != null ? this.subscriber.build() : null;
    }

    protected void copyInstance(SubscriptionSpec instance) {
        SubscriptionSpec subscriptionSpec = instance = instance != null ? instance : new SubscriptionSpec();
        if (instance != null) {
            this.withChannel(instance.getChannel());
            this.withDelivery(instance.getDelivery());
            this.withReply(instance.getReply());
            this.withSubscriber(instance.getSubscriber());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ChannelNested<A> editChannel() {
        return this.withNewChannelLike(Optional.ofNullable(this.buildChannel()).orElse(null));
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public ChannelNested<A> editOrNewChannel() {
        return this.withNewChannelLike(Optional.ofNullable(this.buildChannel()).orElse(new KReferenceBuilder().build()));
    }

    public ChannelNested<A> editOrNewChannelLike(KReference item) {
        return this.withNewChannelLike(Optional.ofNullable(this.buildChannel()).orElse(item));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public ReplyNested<A> editOrNewReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(new DestinationBuilder().build()));
    }

    public ReplyNested<A> editOrNewReplyLike(Destination item) {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(item));
    }

    public SubscriberNested<A> editOrNewSubscriber() {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(new DestinationBuilder().build()));
    }

    public SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(item));
    }

    public ReplyNested<A> editReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(null));
    }

    public SubscriberNested<A> editSubscriber() {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionSpecFluent that = (SubscriptionSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.channel, (Object)that.channel)) {
            return false;
        }
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals((Object)this.reply, (Object)that.reply)) {
            return false;
        }
        if (!Objects.equals((Object)this.subscriber, (Object)that.subscriber)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasChannel() {
        return this.channel != null;
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public boolean hasReply() {
        return this.reply != null;
    }

    public boolean hasSubscriber() {
        return this.subscriber != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channel, this.delivery, this.reply, this.subscriber, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channel != null) {
            sb.append("channel:");
            sb.append((Object)this.channel);
            sb.append(",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append((Object)this.delivery);
            sb.append(",");
        }
        if (this.reply != null) {
            sb.append("reply:");
            sb.append((Object)this.reply);
            sb.append(",");
        }
        if (this.subscriber != null) {
            sb.append("subscriber:");
            sb.append((Object)this.subscriber);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withChannel(KReference channel) {
        this._visitables.remove((Object)"channel");
        if (channel != null) {
            this.channel = new KReferenceBuilder(channel);
            this._visitables.get((Object)"channel").add(this.channel);
        } else {
            this.channel = null;
            this._visitables.get((Object)"channel").remove((Object)this.channel);
        }
        return (A)((Object)this);
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.remove((Object)"delivery");
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public ChannelNested<A> withNewChannel() {
        return new ChannelNested(null);
    }

    public ChannelNested<A> withNewChannelLike(KReference item) {
        return new ChannelNested(item);
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public ReplyNested<A> withNewReply() {
        return new ReplyNested(null);
    }

    public ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNested(item);
    }

    public SubscriberNested<A> withNewSubscriber() {
        return new SubscriberNested(null);
    }

    public SubscriberNested<A> withNewSubscriberLike(Destination item) {
        return new SubscriberNested(item);
    }

    public A withReply(Destination reply) {
        this._visitables.remove((Object)"reply");
        if (reply != null) {
            this.reply = new DestinationBuilder(reply);
            this._visitables.get((Object)"reply").add(this.reply);
        } else {
            this.reply = null;
            this._visitables.get((Object)"reply").remove((Object)this.reply);
        }
        return (A)((Object)this);
    }

    public A withSubscriber(Destination subscriber) {
        this._visitables.remove((Object)"subscriber");
        if (subscriber != null) {
            this.subscriber = new DestinationBuilder(subscriber);
            this._visitables.get((Object)"subscriber").add(this.subscriber);
        } else {
            this.subscriber = null;
            this._visitables.get((Object)"subscriber").remove((Object)this.subscriber);
        }
        return (A)((Object)this);
    }

    public class SubscriberNested<N>
    extends DestinationFluent<SubscriberNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SubscriberNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)SubscriptionSpecFluent.this.withSubscriber(this.builder.build());
        }

        public N endSubscriber() {
            return this.and();
        }
    }

    public class ReplyNested<N>
    extends DestinationFluent<ReplyNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        ReplyNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)SubscriptionSpecFluent.this.withReply(this.builder.build());
        }

        public N endReply() {
            return this.and();
        }
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)SubscriptionSpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }

    public class ChannelNested<N>
    extends KReferenceFluent<ChannelNested<N>>
    implements Nested<N> {
        KReferenceBuilder builder;

        ChannelNested(KReference item) {
            this.builder = new KReferenceBuilder(this, item);
        }

        public N and() {
            return (N)SubscriptionSpecFluent.this.withChannel(this.builder.build());
        }

        public N endChannel() {
            return this.and();
        }
    }
}

