/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.duck.v1.DeliverySpec;
import io.fabric8.knative.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.duck.v1.SubscriberSpec;
import io.fabric8.knative.duck.v1.SubscriberSpecBuilder;
import io.fabric8.knative.duck.v1.SubscriberSpecFluent;
import io.fabric8.knative.messaging.v1.KafkaChannelSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaChannelSpecFluent<A extends KafkaChannelSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private DeliverySpecBuilder delivery;
    private Integer numPartitions;
    private Integer replicationFactor;
    private String retentionDuration;
    private ArrayList<SubscriberSpecBuilder> subscribers = new ArrayList();

    public KafkaChannelSpecFluent() {
    }

    public KafkaChannelSpecFluent(KafkaChannelSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)((Object)this);
    }

    public SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNested(-1, null);
    }

    public SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
        return new SubscribersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSubscribers(SubscriberSpec ... items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    public SubscriberSpec buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    public SubscriberSpec buildLastSubscriber() {
        return this.subscribers.get(this.subscribers.size() - 1).build();
    }

    public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SubscriberSpec buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    public List<SubscriberSpec> buildSubscribers() {
        return this.subscribers != null ? KafkaChannelSpecFluent.build(this.subscribers) : null;
    }

    protected void copyInstance(KafkaChannelSpec instance) {
        KafkaChannelSpec kafkaChannelSpec = instance = instance != null ? instance : new KafkaChannelSpec();
        if (instance != null) {
            this.withDelivery(instance.getDelivery());
            this.withNumPartitions(instance.getNumPartitions());
            this.withReplicationFactor(instance.getReplicationFactor());
            this.withRetentionDuration(instance.getRetentionDuration());
            this.withSubscribers(instance.getSubscribers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public SubscribersNested<A> editFirstSubscriber() {
        if (this.subscribers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "subscribers"));
        }
        return this.setNewSubscriberLike(0, this.buildSubscriber(0));
    }

    public SubscribersNested<A> editLastSubscriber() {
        int index = this.subscribers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "subscribers"));
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!predicate.test(this.subscribers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "subscribers"));
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public SubscribersNested<A> editSubscriber(int index) {
        if (this.subscribers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "subscribers"));
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaChannelSpecFluent that = (KafkaChannelSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals(this.numPartitions, that.numPartitions)) {
            return false;
        }
        if (!Objects.equals(this.replicationFactor, that.replicationFactor)) {
            return false;
        }
        if (!Objects.equals(this.retentionDuration, that.retentionDuration)) {
            return false;
        }
        if (!Objects.equals(this.subscribers, that.subscribers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getRetentionDuration() {
        return this.retentionDuration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNumPartitions() {
        return this.numPartitions != null;
    }

    public boolean hasReplicationFactor() {
        return this.replicationFactor != null;
    }

    public boolean hasRetentionDuration() {
        return this.retentionDuration != null;
    }

    public boolean hasSubscribers() {
        return this.subscribers != null && !this.subscribers.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delivery, this.numPartitions, this.replicationFactor, this.retentionDuration, this.subscribers, this.additionalProperties});
    }

    public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {
            return (A)((Object)this);
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove((Object)builder);
            this.subscribers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSubscribers(SubscriberSpec ... items) {
        if (this.subscribers == null) {
            return (A)((Object)this);
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove((Object)builder);
            this.subscribers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
        if (this.subscribers == null) {
            return (A)((Object)this);
        }
        Iterator<SubscriberSpecBuilder> each = this.subscribers.iterator();
        List visitables = this._visitables.get((Object)"subscribers");
        while (each.hasNext()) {
            SubscriberSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public SubscribersNested<A> setNewSubscriberLike(int index, SubscriberSpec item) {
        return new SubscribersNested(index, item);
    }

    public A setToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append((Object)this.delivery);
            sb.append(",");
        }
        if (this.numPartitions != null) {
            sb.append("numPartitions:");
            sb.append(this.numPartitions);
            sb.append(",");
        }
        if (this.replicationFactor != null) {
            sb.append("replicationFactor:");
            sb.append(this.replicationFactor);
            sb.append(",");
        }
        if (this.retentionDuration != null) {
            sb.append("retentionDuration:");
            sb.append(this.retentionDuration);
            sb.append(",");
        }
        if (this.subscribers != null && !this.subscribers.isEmpty()) {
            sb.append("subscribers:");
            sb.append(this.subscribers);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.remove((Object)"delivery");
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public A withNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
        return (A)((Object)this);
    }

    public A withReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return (A)((Object)this);
    }

    public A withRetentionDuration(String retentionDuration) {
        this.retentionDuration = retentionDuration;
        return (A)((Object)this);
    }

    public A withSubscribers(List<SubscriberSpec> subscribers) {
        if (this.subscribers != null) {
            this._visitables.get((Object)"subscribers").clear();
        }
        if (subscribers != null) {
            this.subscribers = new ArrayList();
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        } else {
            this.subscribers = null;
        }
        return (A)((Object)this);
    }

    public A withSubscribers(SubscriberSpec ... subscribers) {
        if (this.subscribers != null) {
            this.subscribers.clear();
            this._visitables.remove((Object)"subscribers");
        }
        if (subscribers != null) {
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        }
        return (A)((Object)this);
    }

    public class SubscribersNested<N>
    extends SubscriberSpecFluent<SubscribersNested<N>>
    implements Nested<N> {
        SubscriberSpecBuilder builder;
        int index;

        SubscribersNested(int index, SubscriberSpec item) {
            this.index = index;
            this.builder = new SubscriberSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaChannelSpecFluent.this.setToSubscribers(this.index, this.builder.build());
        }

        public N endSubscriber() {
            return this.and();
        }
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaChannelSpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }
}

