/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.IngressBackendSplit;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressBackendSplitFluent<A extends IngressBackendSplitFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, String> appendHeaders;
    private Integer percent;
    private String serviceName;
    private String serviceNamespace;
    private IntOrStringBuilder servicePort;

    public IngressBackendSplitFluent() {
    }

    public IngressBackendSplitFluent(IngressBackendSplit instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null && map != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.appendHeaders.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAppendHeaders(String key, String value) {
        if (this.appendHeaders == null && key != null && value != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.appendHeaders.put(key, value);
        }
        return (A)((Object)this);
    }

    public IntOrString buildServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    protected void copyInstance(IngressBackendSplit instance) {
        IngressBackendSplit ingressBackendSplit = instance = instance != null ? instance : new IngressBackendSplit();
        if (instance != null) {
            this.withAppendHeaders(instance.getAppendHeaders());
            this.withPercent(instance.getPercent());
            this.withServiceName(instance.getServiceName());
            this.withServiceNamespace(instance.getServiceNamespace());
            this.withServicePort(instance.getServicePort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ServicePortNested<A> editOrNewServicePort() {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(new IntOrStringBuilder().build()));
    }

    public ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(item));
    }

    public ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendSplitFluent that = (IngressBackendSplitFluent)((Object)o);
        if (!Objects.equals(this.appendHeaders, that.appendHeaders)) {
            return false;
        }
        if (!Objects.equals(this.percent, that.percent)) {
            return false;
        }
        if (!Objects.equals(this.serviceName, that.serviceName)) {
            return false;
        }
        if (!Objects.equals(this.serviceNamespace, that.serviceNamespace)) {
            return false;
        }
        if (!Objects.equals(this.servicePort, that.servicePort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAppendHeaders() {
        return this.appendHeaders;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAppendHeaders() {
        return this.appendHeaders != null;
    }

    public boolean hasPercent() {
        return this.percent != null;
    }

    public boolean hasServiceName() {
        return this.serviceName != null;
    }

    public boolean hasServiceNamespace() {
        return this.serviceNamespace != null;
    }

    public boolean hasServicePort() {
        return this.servicePort != null;
    }

    public int hashCode() {
        return Objects.hash(this.appendHeaders, this.percent, this.serviceName, this.serviceNamespace, this.servicePort, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAppendHeaders(String key) {
        if (this.appendHeaders == null) {
            return (A)((Object)this);
        }
        if (key != null && this.appendHeaders != null) {
            this.appendHeaders.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.appendHeaders == null) continue;
                this.appendHeaders.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appendHeaders != null && !this.appendHeaders.isEmpty()) {
            sb.append("appendHeaders:");
            sb.append(this.appendHeaders);
            sb.append(",");
        }
        if (this.percent != null) {
            sb.append("percent:");
            sb.append(this.percent);
            sb.append(",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName);
            sb.append(",");
        }
        if (this.serviceNamespace != null) {
            sb.append("serviceNamespace:");
            sb.append(this.serviceNamespace);
            sb.append(",");
        }
        if (this.servicePort != null) {
            sb.append("servicePort:");
            sb.append(this.servicePort);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withAppendHeaders(Map<String, String> appendHeaders) {
        this.appendHeaders = appendHeaders == null ? null : new LinkedHashMap<String, String>(appendHeaders);
        return (A)((Object)this);
    }

    public ServicePortNested<A> withNewServicePort() {
        return new ServicePortNested(null);
    }

    public A withNewServicePort(Object value) {
        return this.withServicePort(new IntOrString(value));
    }

    public ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNested(item);
    }

    public A withPercent(Integer percent) {
        this.percent = percent;
        return (A)((Object)this);
    }

    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)((Object)this);
    }

    public A withServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
        return (A)((Object)this);
    }

    public A withServicePort(IntOrString servicePort) {
        this._visitables.remove((Object)"servicePort");
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.get((Object)"servicePort").add(this.servicePort);
        } else {
            this.servicePort = null;
            this._visitables.get((Object)"servicePort").remove(this.servicePort);
        }
        return (A)((Object)this);
    }

    public class ServicePortNested<N>
    extends IntOrStringFluent<ServicePortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ServicePortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)IngressBackendSplitFluent.this.withServicePort(this.builder.build());
        }

        public N endServicePort() {
            return this.and();
        }
    }
}

