/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.knative.duck.v1.AddressStatus;
import io.fabric8.knative.duck.v1.AddressStatusBuilder;
import io.fabric8.knative.duck.v1.AddressStatusFluent;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRef;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRefBuilder;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRefFluent;
import io.fabric8.knative.eventing.v1alpha1.KafkaSinkStatus;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaSinkStatusFluent<A extends KafkaSinkStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AddressStatusBuilder addressStatus;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private ArrayList<AppliedEventPolicyRefBuilder> policies = new ArrayList();

    public KafkaSinkStatusFluent() {
    }

    public KafkaSinkStatusFluent(KafkaSinkStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicies(Collection<AppliedEventPolicyRef> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public A addNewPolicy(String apiVersion, String name) {
        return this.addToPolicies(new AppliedEventPolicyRef(apiVersion, name));
    }

    public PoliciesNested<A> addNewPolicyLike(AppliedEventPolicyRef item) {
        return new PoliciesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(AppliedEventPolicyRef ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(int index, AppliedEventPolicyRef item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public AddressStatus buildAddressStatus() {
        return this.addressStatus != null ? this.addressStatus.build() : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? KafkaSinkStatusFluent.build(this.conditions) : null;
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public AppliedEventPolicyRef buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public AppliedEventPolicyRef buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AppliedEventPolicyRef buildMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        for (AppliedEventPolicyRefBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<AppliedEventPolicyRef> buildPolicies() {
        return this.policies != null ? KafkaSinkStatusFluent.build(this.policies) : null;
    }

    public AppliedEventPolicyRef buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    protected void copyInstance(KafkaSinkStatus instance) {
        KafkaSinkStatus kafkaSinkStatus = instance = instance != null ? instance : new KafkaSinkStatus();
        if (instance != null) {
            this.withAddressStatus(instance.getAddressStatus());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPolicies(instance.getPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressStatusNested<A> editAddressStatus() {
        return this.withNewAddressStatusLike(Optional.ofNullable(this.buildAddressStatus()).orElse(null));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public AddressStatusNested<A> editOrNewAddressStatus() {
        return this.withNewAddressStatusLike(Optional.ofNullable(this.buildAddressStatus()).orElse(new AddressStatusBuilder().build()));
    }

    public AddressStatusNested<A> editOrNewAddressStatusLike(AddressStatus item) {
        return this.withNewAddressStatusLike(Optional.ofNullable(this.buildAddressStatus()).orElse(item));
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSinkStatusFluent that = (KafkaSinkStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.addressStatus, (Object)that.addressStatus)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddressStatus() {
        return this.addressStatus != null;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        for (AppliedEventPolicyRefBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressStatus, this.annotations, this.conditions, this.observedGeneration, this.policies, this.additionalProperties});
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicies(Collection<AppliedEventPolicyRef> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(AppliedEventPolicyRef ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<AppliedEventPolicyRefBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            AppliedEventPolicyRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, AppliedEventPolicyRef item) {
        return new PoliciesNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPolicies(int index, AppliedEventPolicyRef item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addressStatus != null) {
            sb.append("addressStatus:");
            sb.append((Object)this.addressStatus);
            sb.append(",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddressStatus(AddressStatus addressStatus) {
        this._visitables.remove((Object)"addressStatus");
        if (addressStatus != null) {
            this.addressStatus = new AddressStatusBuilder(addressStatus);
            this._visitables.get((Object)"addressStatus").add(this.addressStatus);
        } else {
            this.addressStatus = null;
            this._visitables.get((Object)"addressStatus").remove((Object)this.addressStatus);
        }
        return (A)((Object)this);
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public AddressStatusNested<A> withNewAddressStatus() {
        return new AddressStatusNested(null);
    }

    public AddressStatusNested<A> withNewAddressStatusLike(AddressStatus item) {
        return new AddressStatusNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withPolicies(List<AppliedEventPolicyRef> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (AppliedEventPolicyRef item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(AppliedEventPolicyRef ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (AppliedEventPolicyRef item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public class PoliciesNested<N>
    extends AppliedEventPolicyRefFluent<PoliciesNested<N>>
    implements Nested<N> {
        AppliedEventPolicyRefBuilder builder;
        int index;

        PoliciesNested(int index, AppliedEventPolicyRef item) {
            this.index = index;
            this.builder = new AppliedEventPolicyRefBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSinkStatusFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSinkStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressStatusNested<N>
    extends AddressStatusFluent<AddressStatusNested<N>>
    implements Nested<N> {
        AddressStatusBuilder builder;

        AddressStatusNested(AddressStatus item) {
            this.builder = new AddressStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSinkStatusFluent.this.withAddressStatus(this.builder.build());
        }

        public N endAddressStatus() {
            return this.and();
        }
    }
}

