/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.knative.duck.v1.Addressable;
import io.fabric8.knative.duck.v1.AddressableBuilder;
import io.fabric8.knative.duck.v1.AddressableFluent;
import io.fabric8.knative.duck.v1.AuthStatus;
import io.fabric8.knative.duck.v1.AuthStatusBuilder;
import io.fabric8.knative.duck.v1.AuthStatusFluent;
import io.fabric8.knative.duck.v1.CloudEventAttributes;
import io.fabric8.knative.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.knative.duck.v1.CloudEventAttributesFluent;
import io.fabric8.knative.eventing.v1alpha1.EventTransformStatus;
import io.fabric8.knative.eventing.v1alpha1.JsonataEventTransformationStatus;
import io.fabric8.knative.eventing.v1alpha1.JsonataEventTransformationStatusBuilder;
import io.fabric8.knative.eventing.v1alpha1.JsonataEventTransformationStatusFluent;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EventTransformStatusFluent<A extends EventTransformStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AddressableBuilder address;
    private ArrayList<AddressableBuilder> addresses = new ArrayList();
    private Map<String, String> annotations;
    private AuthStatusBuilder auth;
    private ArrayList<CloudEventAttributesBuilder> ceAttributes = new ArrayList();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private JsonataEventTransformationStatusBuilder jsonata;
    private Long observedGeneration;
    private String sinkAudience;
    private String sinkCACerts;
    private String sinkUri;

    public EventTransformStatusFluent() {
    }

    public EventTransformStatusFluent(EventTransformStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public A addNewAddress(String cACerts, String audience, String name, String url) {
        return this.addToAddresses(new Addressable(cACerts, audience, name, url));
    }

    public AddressesNested<A> addNewAddressLike(Addressable item) {
        return new AddressesNested(-1, item);
    }

    public CeAttributesNested<A> addNewCeAttribute() {
        return new CeAttributesNested(-1, null);
    }

    public A addNewCeAttribute(String source, String type) {
        return this.addToCeAttributes(new CloudEventAttributes(source, type));
    }

    public CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
        return new CeAttributesNested(-1, item);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(Addressable ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCeAttributes(CloudEventAttributes ... items) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToCeAttributes(int index, CloudEventAttributes item) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
        if (index < 0 || index >= this.ceAttributes.size()) {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        } else {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public Addressable buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<Addressable> buildAddresses() {
        return this.addresses != null ? EventTransformStatusFluent.build(this.addresses) : null;
    }

    public AuthStatus buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public CloudEventAttributes buildCeAttribute(int index) {
        return this.ceAttributes.get(index).build();
    }

    public List<CloudEventAttributes> buildCeAttributes() {
        return this.ceAttributes != null ? EventTransformStatusFluent.build(this.ceAttributes) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? EventTransformStatusFluent.build(this.conditions) : null;
    }

    public Addressable buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public CloudEventAttributes buildFirstCeAttribute() {
        return this.ceAttributes.get(0).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public JsonataEventTransformationStatus buildJsonata() {
        return this.jsonata != null ? this.jsonata.build() : null;
    }

    public Addressable buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public CloudEventAttributes buildLastCeAttribute() {
        return this.ceAttributes.get(this.ceAttributes.size() - 1).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Addressable buildMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item : this.ceAttributes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(EventTransformStatus instance) {
        EventTransformStatus eventTransformStatus = instance = instance != null ? instance : new EventTransformStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
            this.withAnnotations(instance.getAnnotations());
            this.withAuth(instance.getAuth());
            this.withCeAttributes(instance.getCeAttributes());
            this.withConditions(instance.getConditions());
            this.withJsonata(instance.getJsonata());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withSinkAudience(instance.getSinkAudience());
            this.withSinkCACerts(instance.getSinkCACerts());
            this.withSinkUri(instance.getSinkUri());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public CeAttributesNested<A> editCeAttribute(int index) {
        if (this.ceAttributes.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ceAttributes"));
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public CeAttributesNested<A> editFirstCeAttribute() {
        if (this.ceAttributes.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ceAttributes"));
        }
        return this.setNewCeAttributeLike(0, this.buildCeAttribute(0));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public JsonataNested<A> editJsonata() {
        return this.withNewJsonataLike(Optional.ofNullable(this.buildJsonata()).orElse(null));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public CeAttributesNested<A> editLastCeAttribute() {
        int index = this.ceAttributes.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ceAttributes"));
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<AddressableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ceAttributes.size(); ++i) {
            if (!predicate.test(this.ceAttributes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ceAttributes"));
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthStatusBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public JsonataNested<A> editOrNewJsonata() {
        return this.withNewJsonataLike(Optional.ofNullable(this.buildJsonata()).orElse(new JsonataEventTransformationStatusBuilder().build()));
    }

    public JsonataNested<A> editOrNewJsonataLike(JsonataEventTransformationStatus item) {
        return this.withNewJsonataLike(Optional.ofNullable(this.buildJsonata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventTransformStatusFluent that = (EventTransformStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.ceAttributes, that.ceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.jsonata, (Object)that.jsonata)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.sinkAudience, that.sinkAudience)) {
            return false;
        }
        if (!Objects.equals(this.sinkCACerts, that.sinkCACerts)) {
            return false;
        }
        if (!Objects.equals(this.sinkUri, that.sinkUri)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public String getSinkAudience() {
        return this.sinkAudience;
    }

    public String getSinkCACerts() {
        return this.sinkCACerts;
    }

    public String getSinkUri() {
        return this.sinkUri;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public boolean hasCeAttributes() {
        return this.ceAttributes != null && !this.ceAttributes.isEmpty();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasJsonata() {
        return this.jsonata != null;
    }

    public boolean hasMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item : this.ceAttributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasSinkAudience() {
        return this.sinkAudience != null;
    }

    public boolean hasSinkCACerts() {
        return this.sinkCACerts != null;
    }

    public boolean hasSinkUri() {
        return this.sinkUri != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addresses, this.annotations, this.auth, this.ceAttributes, this.conditions, this.jsonata, this.observedGeneration, this.sinkAudience, this.sinkCACerts, this.sinkUri, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").remove((Object)builder);
            this.ceAttributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(Addressable ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCeAttributes(CloudEventAttributes ... items) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").remove((Object)builder);
            this.ceAttributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<AddressableBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<AddressableBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            AddressableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        Iterator<CloudEventAttributesBuilder> each = this.ceAttributes.iterator();
        List visitables = this._visitables.get((Object)"ceAttributes");
        while (each.hasNext()) {
            CloudEventAttributesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, Addressable item) {
        return new AddressesNested(index, item);
    }

    public CeAttributesNested<A> setNewCeAttributeLike(int index, CloudEventAttributes item) {
        return new CeAttributesNested(index, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public A setToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCeAttributes(int index, CloudEventAttributes item) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
        if (index < 0 || index >= this.ceAttributes.size()) {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        } else {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append((Object)this.address);
            sb.append(",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.auth != null) {
            sb.append("auth:");
            sb.append((Object)this.auth);
            sb.append(",");
        }
        if (this.ceAttributes != null && !this.ceAttributes.isEmpty()) {
            sb.append("ceAttributes:");
            sb.append(this.ceAttributes);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.jsonata != null) {
            sb.append("jsonata:");
            sb.append((Object)this.jsonata);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.sinkAudience != null) {
            sb.append("sinkAudience:");
            sb.append(this.sinkAudience);
            sb.append(",");
        }
        if (this.sinkCACerts != null) {
            sb.append("sinkCACerts:");
            sb.append(this.sinkCACerts);
            sb.append(",");
        }
        if (this.sinkUri != null) {
            sb.append("sinkUri:");
            sb.append(this.sinkUri);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddress(Addressable address) {
        this._visitables.remove((Object)"address");
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public A withAddresses(List<Addressable> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(Addressable ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public A withAuth(AuthStatus auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthStatusBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
        if (this.ceAttributes != null) {
            this._visitables.get((Object)"ceAttributes").clear();
        }
        if (ceAttributes != null) {
            this.ceAttributes = new ArrayList();
            for (CloudEventAttributes item : ceAttributes) {
                this.addToCeAttributes(item);
            }
        } else {
            this.ceAttributes = null;
        }
        return (A)((Object)this);
    }

    public A withCeAttributes(CloudEventAttributes ... ceAttributes) {
        if (this.ceAttributes != null) {
            this.ceAttributes.clear();
            this._visitables.remove((Object)"ceAttributes");
        }
        if (ceAttributes != null) {
            for (CloudEventAttributes item : ceAttributes) {
                this.addToCeAttributes(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withJsonata(JsonataEventTransformationStatus jsonata) {
        this._visitables.remove((Object)"jsonata");
        if (jsonata != null) {
            this.jsonata = new JsonataEventTransformationStatusBuilder(jsonata);
            this._visitables.get((Object)"jsonata").add(this.jsonata);
        } else {
            this.jsonata = null;
            this._visitables.get((Object)"jsonata").remove((Object)this.jsonata);
        }
        return (A)((Object)this);
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public A withNewAddress(String cACerts, String audience, String name, String url) {
        return this.withAddress(new Addressable(cACerts, audience, name, url));
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(AuthStatus item) {
        return new AuthNested(item);
    }

    public JsonataNested<A> withNewJsonata() {
        return new JsonataNested(null);
    }

    public JsonataNested<A> withNewJsonataLike(JsonataEventTransformationStatus item) {
        return new JsonataNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withSinkAudience(String sinkAudience) {
        this.sinkAudience = sinkAudience;
        return (A)((Object)this);
    }

    public A withSinkCACerts(String sinkCACerts) {
        this.sinkCACerts = sinkCACerts;
        return (A)((Object)this);
    }

    public A withSinkUri(String sinkUri) {
        this.sinkUri = sinkUri;
        return (A)((Object)this);
    }

    public class JsonataNested<N>
    extends JsonataEventTransformationStatusFluent<JsonataNested<N>>
    implements Nested<N> {
        JsonataEventTransformationStatusBuilder builder;

        JsonataNested(JsonataEventTransformationStatus item) {
            this.builder = new JsonataEventTransformationStatusBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.withJsonata(this.builder.build());
        }

        public N endJsonata() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CeAttributesNested<N>
    extends CloudEventAttributesFluent<CeAttributesNested<N>>
    implements Nested<N> {
        CloudEventAttributesBuilder builder;
        int index;

        CeAttributesNested(int index, CloudEventAttributes item) {
            this.index = index;
            this.builder = new CloudEventAttributesBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.setToCeAttributes(this.index, this.builder.build());
        }

        public N endCeAttribute() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthStatusFluent<AuthNested<N>>
    implements Nested<N> {
        AuthStatusBuilder builder;

        AuthNested(AuthStatus item) {
            this.builder = new AuthStatusBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends AddressableFluent<AddressesNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;
        int index;

        AddressesNested(int index, Addressable item) {
            this.index = index;
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)EventTransformStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

