/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.knative.eventing.v1alpha1.Auth;
import io.fabric8.knative.eventing.v1alpha1.AuthBuilder;
import io.fabric8.knative.eventing.v1alpha1.AuthFluent;
import io.fabric8.knative.eventing.v1alpha1.KafkaSinkSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaSinkSpecFluent<A extends KafkaSinkSpecFluent<A>>
extends BaseFluent<A> {
    private AuthBuilder auth;
    private List<String> bootstrapServers = new ArrayList<String>();
    private String contentMode;
    private Integer numPartitions;
    private Integer replicationFactor;
    private String topic;
    private Map<String, Object> additionalProperties;

    public KafkaSinkSpecFluent() {
    }

    public KafkaSinkSpecFluent(KafkaSinkSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaSinkSpec instance) {
        KafkaSinkSpec kafkaSinkSpec = instance = instance != null ? instance : new KafkaSinkSpec();
        if (instance != null) {
            this.withAuth(instance.getAuth());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withContentMode(instance.getContentMode());
            this.withNumPartitions(instance.getNumPartitions());
            this.withReplicationFactor(instance.getReplicationFactor());
            this.withTopic(instance.getTopic());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Auth buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public A withAuth(Auth auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(Auth item) {
        return new AuthNested(item);
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(Auth item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)((Object)this);
    }

    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
            this._visitables.remove((Object)"bootstrapServers");
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    public String getContentMode() {
        return this.contentMode;
    }

    public A withContentMode(String contentMode) {
        this.contentMode = contentMode;
        return (A)((Object)this);
    }

    public boolean hasContentMode() {
        return this.contentMode != null;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public A withNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
        return (A)((Object)this);
    }

    public boolean hasNumPartitions() {
        return this.numPartitions != null;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public A withReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return (A)((Object)this);
    }

    public boolean hasReplicationFactor() {
        return this.replicationFactor != null;
    }

    public String getTopic() {
        return this.topic;
    }

    public A withTopic(String topic) {
        this.topic = topic;
        return (A)((Object)this);
    }

    public boolean hasTopic() {
        return this.topic != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSinkSpecFluent that = (KafkaSinkSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals(this.contentMode, that.contentMode)) {
            return false;
        }
        if (!Objects.equals(this.numPartitions, that.numPartitions)) {
            return false;
        }
        if (!Objects.equals(this.replicationFactor, that.replicationFactor)) {
            return false;
        }
        if (!Objects.equals(this.topic, that.topic)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth, this.bootstrapServers, this.contentMode, this.numPartitions, this.replicationFactor, this.topic, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auth != null) {
            sb.append("auth:");
            sb.append(String.valueOf((Object)this.auth) + ",");
        }
        if (this.bootstrapServers != null && !this.bootstrapServers.isEmpty()) {
            sb.append("bootstrapServers:");
            sb.append(String.valueOf(this.bootstrapServers) + ",");
        }
        if (this.contentMode != null) {
            sb.append("contentMode:");
            sb.append(this.contentMode + ",");
        }
        if (this.numPartitions != null) {
            sb.append("numPartitions:");
            sb.append(this.numPartitions + ",");
        }
        if (this.replicationFactor != null) {
            sb.append("replicationFactor:");
            sb.append(this.replicationFactor + ",");
        }
        if (this.topic != null) {
            sb.append("topic:");
            sb.append(this.topic + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AuthNested<N>
    extends AuthFluent<AuthNested<N>>
    implements Nested<N> {
        AuthBuilder builder;

        AuthNested(Auth item) {
            this.builder = new AuthBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSinkSpecFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

