package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationSpecBuilder extends ConfigurationSpecFluentImpl<ConfigurationSpecBuilder> implements VisitableBuilder<ConfigurationSpec,ConfigurationSpecBuilder>{
  public ConfigurationSpecBuilder() {
    this(false);
  }
  public ConfigurationSpecBuilder(Boolean validationEnabled) {
    this(new ConfigurationSpec(), validationEnabled);
  }
  public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigurationSpec(), validationEnabled);
  }
  public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,ConfigurationSpec instance) {
    this(fluent, instance, false);
  }
  public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,ConfigurationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTemplate(instance.getTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationSpecBuilder(ConfigurationSpec instance) {
    this(instance,false);
  }
  public ConfigurationSpecBuilder(ConfigurationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withTemplate(instance.getTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  ConfigurationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigurationSpec build() {
    ConfigurationSpec buildable = new ConfigurationSpec(fluent.getTemplate());
    return buildable;
  }
  
}