package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigurationListFluentImpl<A extends ConfigurationListFluent<A>> extends BaseFluent<A> implements ConfigurationListFluent<A>{
  public ConfigurationListFluentImpl() {
  }
  public ConfigurationListFluentImpl(ConfigurationList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
  }
  private String apiVersion;
  private ArrayList<ConfigurationBuilder> items = new ArrayList<ConfigurationBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(Integer index,Configuration item) {
    if (this.items == null) {this.items = new ArrayList<ConfigurationBuilder>();}
    ConfigurationBuilder builder = new ConfigurationBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(Integer index,Configuration item) {
    if (this.items == null) {this.items = new ArrayList<ConfigurationBuilder>();}
    ConfigurationBuilder builder = new ConfigurationBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.knative.serving.v1.Configuration... items) {
    if (this.items == null) {this.items = new ArrayList<ConfigurationBuilder>();}
    for (Configuration item : items) {ConfigurationBuilder builder = new ConfigurationBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<Configuration> items) {
    if (this.items == null) {this.items = new ArrayList<ConfigurationBuilder>();}
    for (Configuration item : items) {ConfigurationBuilder builder = new ConfigurationBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.knative.serving.v1.Configuration... items) {
    for (Configuration item : items) {ConfigurationBuilder builder = new ConfigurationBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<Configuration> items) {
    for (Configuration item : items) {ConfigurationBuilder builder = new ConfigurationBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<ConfigurationBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<ConfigurationBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      ConfigurationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Configuration> getItems() {
    return items != null ? build(items) : null;
  }
  public List<Configuration> buildItems() {
    return items != null ? build(items) : null;
  }
  public Configuration buildItem(Integer index) {
    return this.items.get(index).build();
  }
  public Configuration buildFirstItem() {
    return this.items.get(0).build();
  }
  public Configuration buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public Configuration buildMatchingItem(Predicate<ConfigurationBuilder> predicate) {
    for (ConfigurationBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<ConfigurationBuilder> predicate) {
    for (ConfigurationBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<Configuration> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new ArrayList(); for (Configuration item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.knative.serving.v1.Configuration... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (Configuration item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public ConfigurationListFluent.ItemsNested<A> addNewItem() {
    return new ConfigurationListFluentImpl.ItemsNestedImpl();
  }
  public ConfigurationListFluent.ItemsNested<A> addNewItemLike(Configuration item) {
    return new ConfigurationListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public ConfigurationListFluent.ItemsNested<A> setNewItemLike(Integer index,Configuration item) {
    return new ConfigurationListFluentImpl.ItemsNestedImpl(index, item);
  }
  public ConfigurationListFluent.ItemsNested<A> editItem(Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public ConfigurationListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public ConfigurationListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public ConfigurationListFluent.ItemsNested<A> editMatchingItem(Predicate<ConfigurationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigurationListFluentImpl that = (ConfigurationListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends ConfigurationFluentImpl<ConfigurationListFluent.ItemsNested<N>> implements ConfigurationListFluent.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(Integer index,Configuration item) {
      this.index = index;
      this.builder = new ConfigurationBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationBuilder(this);
    }
    ConfigurationBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigurationListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}