package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import java.lang.Integer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaChannelSpecFluentImpl<A extends KafkaChannelSpecFluent<A>> extends BaseFluent<A> implements KafkaChannelSpecFluent<A>{
  public KafkaChannelSpecFluentImpl() {
  }
  public KafkaChannelSpecFluentImpl(KafkaChannelSpec instance) {
    this.withDelivery(instance.getDelivery()); 
    this.withNumPartitions(instance.getNumPartitions()); 
    this.withReplicationFactor(instance.getReplicationFactor()); 
    this.withRetentionDuration(instance.getRetentionDuration()); 
    this.withSubscribers(instance.getSubscribers()); 
  }
  private DeliverySpecBuilder delivery;
  private Integer numPartitions;
  private Integer replicationFactor;
  private String retentionDuration;
  private ArrayList<SubscriberSpecBuilder> subscribers = new ArrayList<SubscriberSpecBuilder>();
  
  /**
   * This method has been deprecated, please use method buildDelivery instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeliverySpec getDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public Boolean hasDelivery() {
    return this.delivery != null;
  }
  public KafkaChannelSpecFluent.DeliveryNested<A> withNewDelivery() {
    return new KafkaChannelSpecFluentImpl.DeliveryNestedImpl();
  }
  public KafkaChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new KafkaChannelSpecFluentImpl.DeliveryNestedImpl(item);
  }
  public KafkaChannelSpecFluent.DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(getDelivery());
  }
  public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
  }
  public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
  }
  public Integer getNumPartitions() {
    return this.numPartitions;
  }
  public A withNumPartitions(Integer numPartitions) {
    this.numPartitions=numPartitions; return (A) this;
  }
  public Boolean hasNumPartitions() {
    return this.numPartitions != null;
  }
  public Integer getReplicationFactor() {
    return this.replicationFactor;
  }
  public A withReplicationFactor(Integer replicationFactor) {
    this.replicationFactor=replicationFactor; return (A) this;
  }
  public Boolean hasReplicationFactor() {
    return this.replicationFactor != null;
  }
  public String getRetentionDuration() {
    return this.retentionDuration;
  }
  public A withRetentionDuration(String retentionDuration) {
    this.retentionDuration=retentionDuration; return (A) this;
  }
  public Boolean hasRetentionDuration() {
    return this.retentionDuration != null;
  }
  public A addToSubscribers(Integer index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
  }
  public A setToSubscribers(Integer index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
    if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
     return (A)this;
  }
  public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A addAllToSubscribers(Collection<SubscriberSpec> items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
    if (subscribers == null) return (A) this;
    final Iterator<SubscriberSpecBuilder> each = subscribers.iterator();
    final List visitables = _visitables.get("subscribers");
    while (each.hasNext()) {
      SubscriberSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubscribers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriberSpec> getSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public List<SubscriberSpec> buildSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public SubscriberSpec buildSubscriber(Integer index) {
    return this.subscribers.get(index).build();
  }
  public SubscriberSpec buildFirstSubscriber() {
    return this.subscribers.get(0).build();
  }
  public SubscriberSpec buildLastSubscriber() {
    return this.subscribers.get(subscribers.size() - 1).build();
  }
  public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubscribers(List<SubscriberSpec> subscribers) {
    if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
    if (subscribers != null) {this.subscribers = new ArrayList(); for (SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
  }
  public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... subscribers) {
    if (this.subscribers != null) {this.subscribers.clear();}
    if (subscribers != null) {for (SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
  }
  public Boolean hasSubscribers() {
    return subscribers != null && !subscribers.isEmpty();
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriber() {
    return new KafkaChannelSpecFluentImpl.SubscribersNestedImpl();
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
    return new KafkaChannelSpecFluentImpl.SubscribersNestedImpl(-1, item);
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> setNewSubscriberLike(Integer index,SubscriberSpec item) {
    return new KafkaChannelSpecFluentImpl.SubscribersNestedImpl(index, item);
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> editSubscriber(Integer index) {
    if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> editFirstSubscriber() {
    if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
    return setNewSubscriberLike(0, buildSubscriber(0));
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> editLastSubscriber() {
    int index = subscribers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public KafkaChannelSpecFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscribers.size();i++) { 
    if (predicate.test(subscribers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaChannelSpecFluentImpl that = (KafkaChannelSpecFluentImpl) o;
    if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
    if (numPartitions != null ? !numPartitions.equals(that.numPartitions) :that.numPartitions != null) return false;
    if (replicationFactor != null ? !replicationFactor.equals(that.replicationFactor) :that.replicationFactor != null) return false;
    if (retentionDuration != null ? !retentionDuration.equals(that.retentionDuration) :that.retentionDuration != null) return false;
    if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(delivery,  numPartitions,  replicationFactor,  retentionDuration,  subscribers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (numPartitions != null) { sb.append("numPartitions:"); sb.append(numPartitions + ","); }
    if (replicationFactor != null) { sb.append("replicationFactor:"); sb.append(replicationFactor + ","); }
    if (retentionDuration != null) { sb.append("retentionDuration:"); sb.append(retentionDuration + ","); }
    if (subscribers != null && !subscribers.isEmpty()) { sb.append("subscribers:"); sb.append(subscribers); }
    sb.append("}");
    return sb.toString();
  }
  class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<KafkaChannelSpecFluent.DeliveryNested<N>> implements KafkaChannelSpecFluent.DeliveryNested<N>,Nested<N>{
    DeliveryNestedImpl(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliveryNestedImpl() {
      this.builder = new DeliverySpecBuilder(this);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) KafkaChannelSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  class SubscribersNestedImpl<N> extends SubscriberSpecFluentImpl<KafkaChannelSpecFluent.SubscribersNested<N>> implements KafkaChannelSpecFluent.SubscribersNested<N>,Nested<N>{
    SubscribersNestedImpl(Integer index,SubscriberSpec item) {
      this.index = index;
      this.builder = new SubscriberSpecBuilder(this, item);
    }
    SubscribersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriberSpecBuilder(this);
    }
    SubscriberSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) KafkaChannelSpecFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}