package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServerlessServiceBuilder extends ServerlessServiceFluent<ServerlessServiceBuilder> implements VisitableBuilder<ServerlessService,ServerlessServiceBuilder>{
  public ServerlessServiceBuilder() {
    this(new ServerlessService());
  }
  
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent) {
    this(fluent, new ServerlessService());
  }
  
  public ServerlessServiceBuilder(ServerlessServiceFluent<?> fluent,ServerlessService instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServerlessServiceBuilder(ServerlessService instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServerlessServiceFluent<?> fluent;
  
  public ServerlessService build() {
    ServerlessService buildable = new ServerlessService(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}