package io.fabric8.knative.internal.autoscaling.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodAutoscalerSpecFluent<A extends PodAutoscalerSpecFluent<A>> extends BaseFluent<A>{
  public PodAutoscalerSpecFluent() {
  }
  
  public PodAutoscalerSpecFluent(PodAutoscalerSpec instance) {
    this.copyInstance(instance);
  }
  private Long containerConcurrency;
  private String protocolType;
  private String reachability;
  private ObjectReferenceBuilder scaleTargetRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PodAutoscalerSpec instance) {
    instance = (instance != null ? instance : new PodAutoscalerSpec());
    if (instance != null) {
          this.withContainerConcurrency(instance.getContainerConcurrency());
          this.withProtocolType(instance.getProtocolType());
          this.withReachability(instance.getReachability());
          this.withScaleTargetRef(instance.getScaleTargetRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getContainerConcurrency() {
    return this.containerConcurrency;
  }
  
  public A withContainerConcurrency(Long containerConcurrency) {
    this.containerConcurrency = containerConcurrency;
    return (A) this;
  }
  
  public boolean hasContainerConcurrency() {
    return this.containerConcurrency != null;
  }
  
  public String getProtocolType() {
    return this.protocolType;
  }
  
  public A withProtocolType(String protocolType) {
    this.protocolType = protocolType;
    return (A) this;
  }
  
  public boolean hasProtocolType() {
    return this.protocolType != null;
  }
  
  public String getReachability() {
    return this.reachability;
  }
  
  public A withReachability(String reachability) {
    this.reachability = reachability;
    return (A) this;
  }
  
  public boolean hasReachability() {
    return this.reachability != null;
  }
  
  public ObjectReference buildScaleTargetRef() {
    return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
  }
  
  public A withScaleTargetRef(ObjectReference scaleTargetRef) {
    this._visitables.remove("scaleTargetRef");
    if (scaleTargetRef != null) {
        this.scaleTargetRef = new ObjectReferenceBuilder(scaleTargetRef);
        this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
    } else {
        this.scaleTargetRef = null;
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
    }
    return (A) this;
  }
  
  public boolean hasScaleTargetRef() {
    return this.scaleTargetRef != null;
  }
  
  public ScaleTargetRefNested<A> withNewScaleTargetRef() {
    return new ScaleTargetRefNested(null);
  }
  
  public ScaleTargetRefNested<A> withNewScaleTargetRefLike(ObjectReference item) {
    return new ScaleTargetRefNested(item);
  }
  
  public ScaleTargetRefNested<A> editScaleTargetRef() {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(null));
  }
  
  public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(ObjectReference item) {
    return withNewScaleTargetRefLike(java.util.Optional.ofNullable(buildScaleTargetRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodAutoscalerSpecFluent that = (PodAutoscalerSpecFluent) o;
    if (!java.util.Objects.equals(containerConcurrency, that.containerConcurrency)) return false;
    if (!java.util.Objects.equals(protocolType, that.protocolType)) return false;
    if (!java.util.Objects.equals(reachability, that.reachability)) return false;
    if (!java.util.Objects.equals(scaleTargetRef, that.scaleTargetRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerConcurrency,  protocolType,  reachability,  scaleTargetRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerConcurrency != null) { sb.append("containerConcurrency:"); sb.append(containerConcurrency + ","); }
    if (protocolType != null) { sb.append("protocolType:"); sb.append(protocolType + ","); }
    if (reachability != null) { sb.append("reachability:"); sb.append(reachability + ","); }
    if (scaleTargetRef != null) { sb.append("scaleTargetRef:"); sb.append(scaleTargetRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ScaleTargetRefNested<N> extends ObjectReferenceFluent<ScaleTargetRefNested<N>> implements Nested<N>{
    ScaleTargetRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PodAutoscalerSpecFluent.this.withScaleTargetRef(builder.build());
    }
    
    public N endScaleTargetRef() {
      return and();
    }
    
  
  }

}