package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatusBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatusFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatus;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SequenceStatusFluent<A extends SequenceStatusFluent<A>> extends BaseFluent<A>{
  public SequenceStatusFluent() {
  }
  
  public SequenceStatusFluent(SequenceStatus instance) {
    this.copyInstance(instance);
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private AuthStatusBuilder auth;
  private ArrayList<SequenceChannelStatusBuilder> channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private ArrayList<SequenceSubscriptionStatusBuilder> subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SequenceStatus instance) {
    instance = (instance != null ? instance : new SequenceStatus());
    if (instance != null) {
          this.withAddress(instance.getAddress());
          this.withAnnotations(instance.getAnnotations());
          this.withAuth(instance.getAuth());
          this.withChannelStatuses(instance.getChannelStatuses());
          this.withConditions(instance.getConditions());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withSubscriptionStatuses(instance.getSubscriptionStatuses());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Addressable buildAddress() {
    return this.address != null ? this.address.build() : null;
  }
  
  public A withAddress(Addressable address) {
    this._visitables.remove("address");
    if (address != null) {
        this.address = new AddressableBuilder(address);
        this._visitables.get("address").add(this.address);
    } else {
        this.address = null;
        this._visitables.get("address").remove(this.address);
    }
    return (A) this;
  }
  
  public boolean hasAddress() {
    return this.address != null;
  }
  
  public A withNewAddress(String cACerts,String audience,String name,String url) {
    return (A)withAddress(new Addressable(cACerts, audience, name, url));
  }
  
  public AddressNested<A> withNewAddress() {
    return new AddressNested(null);
  }
  
  public AddressNested<A> withNewAddressLike(Addressable item) {
    return new AddressNested(item);
  }
  
  public AddressNested<A> editAddress() {
    return withNewAddressLike(java.util.Optional.ofNullable(buildAddress()).orElse(null));
  }
  
  public AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(java.util.Optional.ofNullable(buildAddress()).orElse(new AddressableBuilder().build()));
  }
  
  public AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(java.util.Optional.ofNullable(buildAddress()).orElse(item));
  }
  
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) {
      this.annotations = null;
    } else {
      this.annotations = new LinkedHashMap(annotations);
    }
    return (A) this;
  }
  
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  public AuthStatus buildAuth() {
    return this.auth != null ? this.auth.build() : null;
  }
  
  public A withAuth(AuthStatus auth) {
    this._visitables.remove("auth");
    if (auth != null) {
        this.auth = new AuthStatusBuilder(auth);
        this._visitables.get("auth").add(this.auth);
    } else {
        this.auth = null;
        this._visitables.get("auth").remove(this.auth);
    }
    return (A) this;
  }
  
  public boolean hasAuth() {
    return this.auth != null;
  }
  
  public A withNewAuth(String serviceAccountName) {
    return (A)withAuth(new AuthStatus(serviceAccountName));
  }
  
  public AuthNested<A> withNewAuth() {
    return new AuthNested(null);
  }
  
  public AuthNested<A> withNewAuthLike(AuthStatus item) {
    return new AuthNested(item);
  }
  
  public AuthNested<A> editAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(null));
  }
  
  public AuthNested<A> editOrNewAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(new AuthStatusBuilder().build()));
  }
  
  public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(item));
  }
  
  public A addToChannelStatuses(int index,SequenceChannelStatus item) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
    if (index < 0 || index >= channelStatuses.size()) { _visitables.get("channelStatuses").add(builder); channelStatuses.add(builder); } else { _visitables.get("channelStatuses").add(index, builder); channelStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToChannelStatuses(int index,SequenceChannelStatus item) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
    if (index < 0 || index >= channelStatuses.size()) { _visitables.get("channelStatuses").add(builder); channelStatuses.add(builder); } else { _visitables.get("channelStatuses").set(index, builder); channelStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... items) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToChannelStatuses(Collection<SequenceChannelStatus> items) {
    if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... items) {
    if (this.channelStatuses == null) return (A)this;
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder); this.channelStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromChannelStatuses(Collection<SequenceChannelStatus> items) {
    if (this.channelStatuses == null) return (A)this;
    for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder); this.channelStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromChannelStatuses(Predicate<SequenceChannelStatusBuilder> predicate) {
    if (channelStatuses == null) return (A) this;
    final Iterator<SequenceChannelStatusBuilder> each = channelStatuses.iterator();
    final List visitables = _visitables.get("channelStatuses");
    while (each.hasNext()) {
      SequenceChannelStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SequenceChannelStatus> buildChannelStatuses() {
    return this.channelStatuses != null ? build(channelStatuses) : null;
  }
  
  public SequenceChannelStatus buildChannelStatus(int index) {
    return this.channelStatuses.get(index).build();
  }
  
  public SequenceChannelStatus buildFirstChannelStatus() {
    return this.channelStatuses.get(0).build();
  }
  
  public SequenceChannelStatus buildLastChannelStatus() {
    return this.channelStatuses.get(channelStatuses.size() - 1).build();
  }
  
  public SequenceChannelStatus buildMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
      for (SequenceChannelStatusBuilder item : channelStatuses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
      for (SequenceChannelStatusBuilder item : channelStatuses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withChannelStatuses(List<SequenceChannelStatus> channelStatuses) {
    if (this.channelStatuses != null) {
      this._visitables.get("channelStatuses").clear();
    }
    if (channelStatuses != null) {
        this.channelStatuses = new ArrayList();
        for (SequenceChannelStatus item : channelStatuses) {
          this.addToChannelStatuses(item);
        }
    } else {
      this.channelStatuses = null;
    }
    return (A) this;
  }
  
  public A withChannelStatuses(io.fabric8.knative.flows.v1.SequenceChannelStatus... channelStatuses) {
    if (this.channelStatuses != null) {
        this.channelStatuses.clear();
        _visitables.remove("channelStatuses");
    }
    if (channelStatuses != null) {
      for (SequenceChannelStatus item : channelStatuses) {
        this.addToChannelStatuses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasChannelStatuses() {
    return this.channelStatuses != null && !this.channelStatuses.isEmpty();
  }
  
  public ChannelStatusesNested<A> addNewChannelStatus() {
    return new ChannelStatusesNested(-1, null);
  }
  
  public ChannelStatusesNested<A> addNewChannelStatusLike(SequenceChannelStatus item) {
    return new ChannelStatusesNested(-1, item);
  }
  
  public ChannelStatusesNested<A> setNewChannelStatusLike(int index,SequenceChannelStatus item) {
    return new ChannelStatusesNested(index, item);
  }
  
  public ChannelStatusesNested<A> editChannelStatus(int index) {
    if (channelStatuses.size() <= index) throw new RuntimeException("Can't edit channelStatuses. Index exceeds size.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  
  public ChannelStatusesNested<A> editFirstChannelStatus() {
    if (channelStatuses.size() == 0) throw new RuntimeException("Can't edit first channelStatuses. The list is empty.");
    return setNewChannelStatusLike(0, buildChannelStatus(0));
  }
  
  public ChannelStatusesNested<A> editLastChannelStatus() {
    int index = channelStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last channelStatuses. The list is empty.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  
  public ChannelStatusesNested<A> editMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<channelStatuses.size();i++) { 
    if (predicate.test(channelStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching channelStatuses. No match found.");
    return setNewChannelStatusLike(index, buildChannelStatus(index));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Condition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
      for (ConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
      for (ConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public A addToSubscriptionStatuses(int index,SequenceSubscriptionStatus item) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
    if (index < 0 || index >= subscriptionStatuses.size()) { _visitables.get("subscriptionStatuses").add(builder); subscriptionStatuses.add(builder); } else { _visitables.get("subscriptionStatuses").add(index, builder); subscriptionStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToSubscriptionStatuses(int index,SequenceSubscriptionStatus item) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
    if (index < 0 || index >= subscriptionStatuses.size()) { _visitables.get("subscriptionStatuses").add(builder); subscriptionStatuses.add(builder); } else { _visitables.get("subscriptionStatuses").set(index, builder); subscriptionStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... items) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
    if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... items) {
    if (this.subscriptionStatuses == null) return (A)this;
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder); this.subscriptionStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
    if (this.subscriptionStatuses == null) return (A)this;
    for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder); this.subscriptionStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubscriptionStatuses(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    if (subscriptionStatuses == null) return (A) this;
    final Iterator<SequenceSubscriptionStatusBuilder> each = subscriptionStatuses.iterator();
    final List visitables = _visitables.get("subscriptionStatuses");
    while (each.hasNext()) {
      SequenceSubscriptionStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SequenceSubscriptionStatus> buildSubscriptionStatuses() {
    return this.subscriptionStatuses != null ? build(subscriptionStatuses) : null;
  }
  
  public SequenceSubscriptionStatus buildSubscriptionStatus(int index) {
    return this.subscriptionStatuses.get(index).build();
  }
  
  public SequenceSubscriptionStatus buildFirstSubscriptionStatus() {
    return this.subscriptionStatuses.get(0).build();
  }
  
  public SequenceSubscriptionStatus buildLastSubscriptionStatus() {
    return this.subscriptionStatuses.get(subscriptionStatuses.size() - 1).build();
  }
  
  public SequenceSubscriptionStatus buildMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
      for (SequenceSubscriptionStatusBuilder item : subscriptionStatuses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
      for (SequenceSubscriptionStatusBuilder item : subscriptionStatuses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubscriptionStatuses(List<SequenceSubscriptionStatus> subscriptionStatuses) {
    if (this.subscriptionStatuses != null) {
      this._visitables.get("subscriptionStatuses").clear();
    }
    if (subscriptionStatuses != null) {
        this.subscriptionStatuses = new ArrayList();
        for (SequenceSubscriptionStatus item : subscriptionStatuses) {
          this.addToSubscriptionStatuses(item);
        }
    } else {
      this.subscriptionStatuses = null;
    }
    return (A) this;
  }
  
  public A withSubscriptionStatuses(io.fabric8.knative.flows.v1.SequenceSubscriptionStatus... subscriptionStatuses) {
    if (this.subscriptionStatuses != null) {
        this.subscriptionStatuses.clear();
        _visitables.remove("subscriptionStatuses");
    }
    if (subscriptionStatuses != null) {
      for (SequenceSubscriptionStatus item : subscriptionStatuses) {
        this.addToSubscriptionStatuses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubscriptionStatuses() {
    return this.subscriptionStatuses != null && !this.subscriptionStatuses.isEmpty();
  }
  
  public SubscriptionStatusesNested<A> addNewSubscriptionStatus() {
    return new SubscriptionStatusesNested(-1, null);
  }
  
  public SubscriptionStatusesNested<A> addNewSubscriptionStatusLike(SequenceSubscriptionStatus item) {
    return new SubscriptionStatusesNested(-1, item);
  }
  
  public SubscriptionStatusesNested<A> setNewSubscriptionStatusLike(int index,SequenceSubscriptionStatus item) {
    return new SubscriptionStatusesNested(index, item);
  }
  
  public SubscriptionStatusesNested<A> editSubscriptionStatus(int index) {
    if (subscriptionStatuses.size() <= index) throw new RuntimeException("Can't edit subscriptionStatuses. Index exceeds size.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  
  public SubscriptionStatusesNested<A> editFirstSubscriptionStatus() {
    if (subscriptionStatuses.size() == 0) throw new RuntimeException("Can't edit first subscriptionStatuses. The list is empty.");
    return setNewSubscriptionStatusLike(0, buildSubscriptionStatus(0));
  }
  
  public SubscriptionStatusesNested<A> editLastSubscriptionStatus() {
    int index = subscriptionStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscriptionStatuses. The list is empty.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  
  public SubscriptionStatusesNested<A> editMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscriptionStatuses.size();i++) { 
    if (predicate.test(subscriptionStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscriptionStatuses. No match found.");
    return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SequenceStatusFluent that = (SequenceStatusFluent) o;
    if (!java.util.Objects.equals(address, that.address)) return false;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
    if (!java.util.Objects.equals(auth, that.auth)) return false;
    if (!java.util.Objects.equals(channelStatuses, that.channelStatuses)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(subscriptionStatuses, that.subscriptionStatuses)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  auth,  channelStatuses,  conditions,  observedGeneration,  subscriptionStatuses,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (auth != null) { sb.append("auth:"); sb.append(auth + ","); }
    if (channelStatuses != null && !channelStatuses.isEmpty()) { sb.append("channelStatuses:"); sb.append(channelStatuses + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (subscriptionStatuses != null && !subscriptionStatuses.isEmpty()) { sb.append("subscriptionStatuses:"); sb.append(subscriptionStatuses + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AddressNested<N> extends AddressableFluent<AddressNested<N>> implements Nested<N>{
    AddressNested(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressableBuilder builder;
    
    public N and() {
      return (N) SequenceStatusFluent.this.withAddress(builder.build());
    }
    
    public N endAddress() {
      return and();
    }
    
  
  }
  public class AuthNested<N> extends AuthStatusFluent<AuthNested<N>> implements Nested<N>{
    AuthNested(AuthStatus item) {
      this.builder = new AuthStatusBuilder(this, item);
    }
    AuthStatusBuilder builder;
    
    public N and() {
      return (N) SequenceStatusFluent.this.withAuth(builder.build());
    }
    
    public N endAuth() {
      return and();
    }
    
  
  }
  public class ChannelStatusesNested<N> extends SequenceChannelStatusFluent<ChannelStatusesNested<N>> implements Nested<N>{
    ChannelStatusesNested(int index,SequenceChannelStatus item) {
      this.index = index;
      this.builder = new SequenceChannelStatusBuilder(this, item);
    }
    SequenceChannelStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) SequenceStatusFluent.this.setToChannelStatuses(index,builder.build());
    }
    
    public N endChannelStatus() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) SequenceStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class SubscriptionStatusesNested<N> extends SequenceSubscriptionStatusFluent<SubscriptionStatusesNested<N>> implements Nested<N>{
    SubscriptionStatusesNested(int index,SequenceSubscriptionStatus item) {
      this.index = index;
      this.builder = new SequenceSubscriptionStatusBuilder(this, item);
    }
    SequenceSubscriptionStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) SequenceStatusFluent.this.setToSubscriptionStatuses(index,builder.build());
    }
    
    public N endSubscriptionStatus() {
      return and();
    }
    
  
  }

}