/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.access.ClusterConfiguration;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.service.Fabric8ServiceHub;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.GeneratorMode;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import io.fabric8.maven.plugin.watcher.WatcherManager;
import io.fabric8.maven.watcher.api.WatcherContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="watch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(goal="deploy")
public class WatchMojo
extends io.fabric8.maven.docker.WatchMojo {
    @Parameter
    ProcessorConfig generator;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.mode")
    private RuntimeMode mode = RuntimeMode.auto;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter
    protected ClusterConfiguration access;
    @Parameter
    private ProcessorConfig watcher;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="fabric8.verbose", defaultValue="false")
    protected boolean verbose;
    @Component
    protected RepositorySystem repositorySystem;
    private ClusterAccess clusterAccess;
    private KubernetesClient kubernetes;
    private ServiceHub hub;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix());
        this.clusterAccess = new ClusterAccess(this.getClusterConfiguration());
        this.kubernetes = this.clusterAccess.createDefaultClient(this.log);
        if (this.clusterAccess.resolveRuntimeMode(this.mode, this.log).equals((Object)RuntimeMode.kubernetes)) {
            super.execute();
        } else {
            this.executeInternal(null);
        }
    }

    protected ClusterConfiguration getClusterConfiguration() {
        if (this.access == null) {
            this.access = new ClusterConfiguration.Builder().build();
        }
        ClusterConfiguration.Builder clusterConfigurationBuilder = new ClusterConfiguration.Builder(this.access);
        return clusterConfigurationBuilder.from(System.getProperties()).from(this.project.getProperties()).build();
    }

    protected synchronized void executeInternal(ServiceHub hub) throws MojoExecutionException {
        if (hub != null) {
            this.hub = hub;
        }
        URL masterUrl = this.kubernetes.getMasterUrl();
        KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
        boolean isOpenshift = OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetes);
        File manifest = isOpenshift ? this.openshiftManifest : this.kubernetesManifest;
        try {
            Set resources = KubernetesResourceUtil.loadResources((File)manifest);
            WatcherContext context = this.getWatcherContext();
            WatcherManager.watch(this.getResolvedImages(), resources, context);
        }
        catch (KubernetesClientException ex) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)ex, (Logger)this.log);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("An error has occurred while while trying to watch the resources", ex);
        }
    }

    public WatcherContext getWatcherContext() throws MojoExecutionException {
        try {
            BuildService.BuildContext buildContext = this.getBuildContext();
            WatchService.WatchContext watchContext = this.hub != null ? this.getWatchContext(this.hub) : null;
            return new WatcherContext.Builder().serviceHub(this.hub).buildContext(buildContext).watchContext(watchContext).config(this.extractWatcherConfig()).logger(this.log).newPodLogger(this.createLogger("[[C]][NEW][[C]] ")).oldPodLogger(this.createLogger("[[R]][OLD][[R]] ")).mode(this.mode).project(this.project).useProjectClasspath(this.useProjectClasspath).clusterConfiguration(this.getClusterConfiguration()).kubernetesClient(this.kubernetes).fabric8ServiceHub(this.getFabric8ServiceHub()).build();
        }
        catch (IOException exception) {
            throw new MojoExecutionException(exception.getMessage());
        }
    }

    protected Fabric8ServiceHub getFabric8ServiceHub() {
        return new Fabric8ServiceHub.Builder().log(this.log).clusterAccess(this.clusterAccess).dockerServiceHub(this.hub).platformMode(this.mode).repositorySystem(this.repositorySystem).mavenProject(this.project).build();
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        try {
            Fabric8ServiceHub serviceHub = this.getFabric8ServiceHub();
            GeneratorContext ctx = new GeneratorContext.Builder().config(this.extractGeneratorConfig()).project(this.project).logger(this.log).runtimeMode(this.mode).strategy(this.buildStrategy).useProjectClasspath(this.useProjectClasspath).artifactResolver(serviceHub.getArtifactResolverService()).generatorMode(GeneratorMode.WATCH).build();
            return GeneratorManager.generate(configs, ctx, false);
        }
        catch (MojoExecutionException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + (Object)((Object)e), e);
        }
    }

    private ProcessorConfig extractWatcherConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.WATCHER_CONFIG, (String)this.profile, (File)ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment), (ProcessorConfig)this.watcher);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract watcher config: " + e, e);
        }
    }

    private ProcessorConfig extractGeneratorConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment), (ProcessorConfig)this.generator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    protected Logger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, "F8:" + prefix);
    }

    protected String getLogPrefix() {
        return "F8: ";
    }
}

