/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.service.PodLogService;
import io.fabric8.maven.plugin.mojo.build.ApplyMojo;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="log", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VALIDATE)
public class LogMojo
extends ApplyMojo {
    @Parameter(property="fabric8.log.follow", defaultValue="true")
    private boolean followLog;
    @Parameter(property="fabric8.log.container")
    private String logContainerName;
    @Parameter(property="fabric8.log.pod")
    private String podName;

    @Override
    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        this.getLogService().tailAppPodsLogs(kubernetes, namespace, entities, false, null, this.followLog, null, true);
    }

    protected PodLogService getLogService() {
        return new PodLogService(this.getLogServiceContext());
    }

    protected PodLogService.PodLogServiceContext getLogServiceContext() {
        return new PodLogService.PodLogServiceContext.Builder().log(this.log).logContainerName(this.logContainerName).podName(this.podName).newPodLog(this.createLogger("[[C]][NEW][[C]] ")).oldPodLog(this.createLogger("[[R]][OLD][[R]] ")).s2iBuildNameSuffix(this.s2iBuildNameSuffix).build();
    }
}

