/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.webapp;

import io.fabric8.maven.generator.webapp.AppServerHandler;
import io.fabric8.maven.generator.webapp.handler.JettyAppSeverHandler;
import io.fabric8.maven.generator.webapp.handler.TomcatAppSeverHandler;
import io.fabric8.maven.generator.webapp.handler.WildFlyAppSeverHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.project.MavenProject;

class AppServerDetector {
    private final List<? extends AppServerHandler> serverHandlers;
    private final AppServerHandler defaultHandler;
    private final HashMap<String, AppServerHandler> serverHandlerMap;

    AppServerDetector(MavenProject project) {
        this.defaultHandler = new TomcatAppSeverHandler(project);
        this.serverHandlers = Arrays.asList(new JettyAppSeverHandler(project), new WildFlyAppSeverHandler(project), this.defaultHandler);
        this.serverHandlerMap = new HashMap();
        for (AppServerHandler appServerHandler : this.serverHandlers) {
            this.serverHandlerMap.put(appServerHandler.getName(), appServerHandler);
        }
    }

    AppServerHandler detect(String server) {
        if (server != null && this.serverHandlerMap.containsKey(server)) {
            return this.serverHandlerMap.get(server);
        }
        for (AppServerHandler appServerHandler : this.serverHandlers) {
            if (!appServerHandler.isApplicable()) continue;
            return appServerHandler;
        }
        return this.defaultHandler;
    }
}

