/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExposeEnricher
extends BaseEnricher {
    private Set<Integer> webPorts = new HashSet<Integer>(Arrays.asList(80, 443, 8080, 9090));
    public static final String EXPOSE_LABEL = "expose";

    public ExposeEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-openshift-service-expose");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        List items = builder.getItems();
        if (items != null) {
            for (HasMetadata item : items) {
                if (!(item instanceof Service)) continue;
                Service service = (Service)item;
                this.enrichService(service);
            }
        }
    }

    private void enrichService(Service service) {
        if (this.hasWebPort(service)) {
            Map labels;
            ObjectMeta metadata = service.getMetadata();
            if (metadata == null) {
                metadata = new ObjectMeta();
                service.setMetadata(metadata);
            }
            if (!(labels = KubernetesHelper.getOrCreateLabels((HasMetadata)service)).containsKey(EXPOSE_LABEL)) {
                labels.put(EXPOSE_LABEL, "true");
                this.log.verbose("Adding Service label '%s:true' on service %s so that it is exposed by the exposecontroller microservice. To disable use the maven argument: '-Dfabric8.profile=internal-microservice'", new Object[]{EXPOSE_LABEL, KubernetesHelper.getName((HasMetadata)service)});
            }
        }
    }

    private boolean hasWebPort(Service service) {
        List ports;
        ServiceSpec spec = service.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null) {
            for (ServicePort port : ports) {
                Integer portNumber = port.getPort();
                if (portNumber == null || !this.webPorts.contains(portNumber)) continue;
                return true;
            }
        }
        return false;
    }
}

