/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.maven.core.model.Configuration;
import io.fabric8.maven.core.util.SecretConstants;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.standard.SecretEnricher;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class DockerRegistrySecretEnricher
extends SecretEnricher {
    private static final String ANNOTATION_KEY = "maven.fabric8.io/dockerServerId";
    private static final String ENRICHER_NAME = "fmp-docker-registry-secret";

    public DockerRegistrySecretEnricher(MavenEnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    @Override
    protected String getAnnotationKey() {
        return ANNOTATION_KEY;
    }

    @Override
    protected Map<String, String> generateData(String dockerId) {
        Configuration config = this.getContext().getConfiguration();
        Optional secretConfig = config.getSecretConfiguration(dockerId);
        if (!secretConfig.isPresent()) {
            return null;
        }
        JsonObject params = new JsonObject();
        for (String key : new String[]{"username", "password", "email"}) {
            if (!((Map)secretConfig.get()).containsKey(key)) continue;
            params.add(key, (JsonElement)new JsonPrimitive(((Map)secretConfig.get()).get(key).toString()));
        }
        JsonObject ret = new JsonObject();
        ret.add(dockerId, (JsonElement)params);
        return Collections.singletonMap(SecretConstants.DOCKER_DATA_KEY, this.encode(ret.toString()));
    }
}

