/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.api.visitor.MetadataVisitor;
import io.fabric8.maven.enricher.api.visitor.SelectorVisitor;

public class DefaultMetadataEnricher
extends BaseEnricher {
    private MetadataVisitor<?>[] metaDataVisitors = null;
    private SelectorVisitor<?>[] selectorVisitorCreators = null;
    private final ProcessorConfig defaultEnricherConfig;
    private final ResourceConfig resourceConfig;

    public DefaultMetadataEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-metadata");
        this.defaultEnricherConfig = buildContext.getConfiguration().getProcessorConfig().orElse(ProcessorConfig.EMPTY);
        this.resourceConfig = buildContext.getConfiguration().getResource().orElse(null);
    }

    private void init() {
        this.metaDataVisitors = new MetadataVisitor[]{new MetadataVisitor.DeploymentBuilderVisitor(this.resourceConfig), new MetadataVisitor.DeploymentConfigBuilderVisitor(this.resourceConfig), new MetadataVisitor.ReplicaSet(this.resourceConfig), new MetadataVisitor.ReplicationControllerBuilderVisitor(this.resourceConfig), new MetadataVisitor.ServiceBuilderVisitor(this.resourceConfig), new MetadataVisitor.PodTemplateSpecBuilderVisitor(this.resourceConfig), new MetadataVisitor.DaemonSetBuilderVisitor(this.resourceConfig), new MetadataVisitor.StatefulSetBuilderVisitor(this.resourceConfig), new MetadataVisitor.JobBuilderVisitor(this.resourceConfig), new MetadataVisitor.ImageStreamBuilderVisitor(this.resourceConfig), new MetadataVisitor.BuildConfigBuilderVisitor(this.resourceConfig), new MetadataVisitor.BuildBuilderVisitor(this.resourceConfig)};
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.init();
        this.enrichLabels(this.defaultEnricherConfig, builder);
    }

    private void enrichLabels(ProcessorConfig config, KubernetesListBuilder builder) {
        this.visit(config, builder, this.metaDataVisitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(ProcessorConfig config, KubernetesListBuilder builder, MetadataVisitor<?>[] visitors) {
        MetadataVisitor.setProcessorConfig((ProcessorConfig)config);
        try {
            for (MetadataVisitor<?> visitor : visitors) {
                builder.accept(visitor);
            }
        }
        finally {
            MetadataVisitor.clearProcessorConfig();
        }
    }
}

