/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util.kubernetes;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class KubernetesHelper {
    public static String validateKubernetesId(String currentValue, String description) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            throw new IllegalArgumentException("No " + description + " is specified!");
        }
        int size = currentValue.length();
        for (int i = 0; i < size; ++i) {
            char ch = currentValue.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            throw new IllegalArgumentException("Invalid upper case letter '" + ch + "' at index " + i + " for " + description + " value: " + currentValue);
        }
        return currentValue;
    }

    public static List<HasMetadata> toItemList(Object entity) throws IOException {
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof HasMetadata[]) {
            HasMetadata[] array = (HasMetadata[])entity;
            return Arrays.asList(array);
        }
        if (entity instanceof KubernetesList) {
            KubernetesList config = (KubernetesList)entity;
            return config.getItems();
        }
        if (entity instanceof Template) {
            Template objects = (Template)entity;
            return objects.getObjects();
        }
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        if (entity instanceof HasMetadata) {
            answer.add((HasMetadata)entity);
        }
        return answer;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && StringUtils.isNotBlank((CharSequence)(resourceVersion = metadata.getResourceVersion()))) {
            return resourceVersion;
        }
        return null;
    }

    public static Map<String, String> getLabels(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getLabels(entity.getMetadata());
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getName(entity.getMetadata());
        }
        return null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            for (String name : new String[]{entity.getName(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid()}) {
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                return name;
            }
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static IntOrString createIntOrString(int intVal) {
        IntOrString answer = new IntOrString();
        answer.setIntVal(Integer.valueOf(intVal));
        answer.setKind(Integer.valueOf(0));
        return answer;
    }

    public static IntOrString createIntOrString(String nameOrNumber) {
        if (StringUtils.isBlank((CharSequence)nameOrNumber)) {
            return null;
        }
        IntOrString answer = new IntOrString();
        Integer intVal = null;
        try {
            intVal = Integer.parseInt(nameOrNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (intVal != null) {
            answer.setIntVal(intVal);
            answer.setKind(Integer.valueOf(0));
        } else {
            answer.setStrVal(nameOrNumber);
            answer.setKind(Integer.valueOf(1));
        }
        return answer;
    }

    public static boolean isPodRunning(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "run");
    }

    public static boolean isPodWaiting(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "wait");
    }

    public static boolean isPodReady(Pod pod) {
        if (!KubernetesHelper.isPodRunning(pod)) {
            return false;
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return true;
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (PodCondition condition : conditions) {
            if (!"ready".equalsIgnoreCase(condition.getType())) continue;
            return Boolean.parseBoolean(condition.getStatus());
        }
        return true;
    }

    private static boolean isInPodPhase(Pod pod, String phase) {
        return KubernetesHelper.getPodPhase(pod).toLowerCase().startsWith(phase);
    }

    static String getPodPhase(Pod pod) {
        PodStatus podStatus;
        if (pod != null && (podStatus = pod.getStatus()) != null) {
            String actualPhase = podStatus.getPhase();
            return actualPhase != null ? actualPhase : "";
        }
        return "";
    }

    public static List<Container> getContainers(Pod pod) {
        if (pod != null) {
            PodSpec podSpec = pod.getSpec();
            return KubernetesHelper.getContainers(podSpec);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodSpec podSpec) {
        if (podSpec != null) {
            return podSpec.getContainers();
        }
        return Collections.EMPTY_LIST;
    }

    private static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getDefaultNamespace() {
        String ns = new ConfigBuilder().build().getNamespace();
        return ns != null ? ns : "default";
    }

    public static String currentUserName() {
        String user;
        Context context;
        Config config = KubernetesHelper.parseConfigs();
        if (config != null && (context = KubernetesHelper.getCurrentContext(config)) != null && (user = context.getUser()) != null) {
            String[] parts = user.split("/");
            if (parts.length > 0) {
                return parts[0];
            }
            return user;
        }
        return null;
    }

    private static Config parseConfigs() {
        File file = KubernetesHelper.getKubernetesConfigFile();
        if (file.exists() && file.isFile()) {
            try {
                return ResourceUtil.load(file, Config.class, ResourceFileType.yaml);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Context getCurrentContext(Config config) {
        List contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!Objects.equals(contextName, context.getName())) continue;
                return context.getContext();
            }
        }
        return null;
    }

    private static File getKubernetesConfigFile() {
        String file = System.getProperty("kubernetes.config.file");
        if (file != null) {
            return new File(file);
        }
        file = System.getenv("KUBECONFIG");
        if (file != null) {
            return new File(file);
        }
        String homeDir = System.getProperty("user.home", ".");
        return new File(homeDir, ".kube/config");
    }
}

