/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitUtil {
    public static Repository getGitRepository(File currentDir) throws IOException {
        File gitFolder;
        if (currentDir == null) {
            currentDir = new File(System.getProperty("basedir", "."));
        }
        if ((gitFolder = GitUtil.findGitFolder(currentDir)) == null) {
            return null;
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
        return repository;
    }

    public static File findGitFolder(File basedir) {
        File gitDir = new File(basedir, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            return gitDir;
        }
        File parent = basedir.getParentFile();
        if (parent != null) {
            return GitUtil.findGitFolder(parent);
        }
        return null;
    }

    public static String getGitCommitId(Repository repository) throws GitAPIException {
        Iterable logs;
        Iterator iterator;
        if (repository != null && (iterator = (logs = new Git(repository).log().call()).iterator()).hasNext()) {
            RevCommit rev = (RevCommit)iterator.next();
            return rev.getName();
        }
        return null;
    }
}

