/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.maven.core.service.PatchService;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.core.util.kubernetes.UserConfigurationCompare;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyService {
    private final KubernetesClient kubernetesClient;
    private final Logger log;
    private boolean allowCreate = true;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean ignoreBoundPersistentVolumeClaims = true;
    private boolean rollingUpgrade;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;
    private String namespace = KubernetesHelper.getDefaultNamespace();
    private boolean rollingUpgradePreserveScale = true;
    private boolean recreateMode;
    private PatchService patchService;

    public ApplyService(KubernetesClient kubernetesClient, Logger log) {
        this.kubernetesClient = kubernetesClient;
        this.patchService = new PatchService(kubernetesClient, log);
        this.log = log;
    }

    public void apply(Object dto, String sourceName) throws Exception {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    this.log.warn("Found recursive nested object for " + dto + " of class: " + dto.getClass().getName(), new Object[0]);
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    private void applyEntity(Object dto, String sourceName) throws Exception {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)dto;
            OpenShiftClient openShiftClient = this.getOpenShiftClient();
            if (openShiftClient != null) {
                this.applyResource(resource, sourceName, openShiftClient.deploymentConfigs());
            } else {
                this.log.warn("Not connected to OpenShift cluster so cannot apply entity " + dto, new Object[0]);
            }
        } else if (dto instanceof RoleBinding) {
            this.applyRoleBinding((RoleBinding)dto, sourceName);
        } else if (dto instanceof Role) {
            Role resource = (Role)dto;
            OpenShiftClient openShiftClient = this.getOpenShiftClient();
            if (openShiftClient != null) {
                this.applyResource(resource, sourceName, openShiftClient.roles());
            } else {
                this.log.warn("Not connected to OpenShift cluster so cannot apply entity " + dto, new Object[0]);
            }
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof ServiceAccount) {
            this.applyServiceAccount((ServiceAccount)dto, sourceName);
        } else if (dto instanceof Secret) {
            this.applySecret((Secret)dto, sourceName);
        } else if (dto instanceof ConfigMap) {
            this.applyResource((ConfigMap)dto, sourceName, this.kubernetesClient.configMaps());
        } else if (dto instanceof DaemonSet) {
            this.applyResource((DaemonSet)dto, sourceName, this.kubernetesClient.extensions().daemonSets());
        } else if (dto instanceof Deployment) {
            this.applyResource((Deployment)dto, sourceName, this.kubernetesClient.extensions().deployments());
        } else if (dto instanceof ReplicaSet) {
            this.applyResource((ReplicaSet)dto, sourceName, this.kubernetesClient.extensions().replicaSets());
        } else if (dto instanceof StatefulSet) {
            this.applyResource((StatefulSet)dto, sourceName, this.kubernetesClient.apps().statefulSets());
        } else if (dto instanceof Ingress) {
            this.applyResource((Ingress)dto, sourceName, this.kubernetesClient.extensions().ingresses());
        } else if (dto instanceof PersistentVolumeClaim) {
            this.applyPersistentVolumeClaim((PersistentVolumeClaim)dto, sourceName);
        } else if (dto instanceof HasMetadata) {
            HasMetadata entity = (HasMetadata)dto;
            try {
                this.log.info("Applying " + KubernetesHelper.getKind(entity) + " " + KubernetesHelper.getName(entity) + " from " + sourceName, new Object[0]);
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource(entity).inNamespace(this.getNamespace())).createOrReplace();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + KubernetesHelper.getKind(entity) + " from " + sourceName + ". " + e, e);
            }
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null && this.supportOAuthClients) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring OAuthClient: " + id, new Object[0]);
                return;
            }
            OAuthClient old = (OAuthClient)((Resource)openShiftClient.oAuthClients().withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    this.log.info("Not updating the OAuthClient which are shared across namespaces as its already running", new Object[0]);
                    return;
                }
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    this.log.info("OAuthClient has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    ((Resource)openShiftClient.oAuthClients().withName(id)).delete();
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        Object answer = ((Resource)openShiftClient.oAuthClients().withName(id)).replace((Object)entity);
                        this.log.info("Updated OAuthClient result: " + answer, new Object[0]);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating an OAuthClient from " + sourceName + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            Object result = null;
            try {
                result = openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public Object applyTemplate(Template entity, String sourceName) throws Exception {
        this.installTemplate(entity, sourceName);
        return this.processTemplate(entity, sourceName);
    }

    public void installTemplate(Template entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient == null) {
            return;
        }
        if (!this.isProcessTemplatesLocally()) {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            Template old = (Template)((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    this.log.info("Template has not changed so not doing anything", new Object[0]);
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateTemplate(entity, namespace, sourceName);
                    } else {
                        this.log.info("Updating a Template from " + sourceName, new Object[0]);
                        try {
                            Object answer = ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).replace((Object)entity);
                            this.log.info("Updated Template: " + answer, new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update Template from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateTemplate(entity, namespace, sourceName);
            }
        }
    }

    public OpenShiftClient getOpenShiftClient() {
        return OpenshiftHelper.asOpenShiftClient(this.kubernetesClient);
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            this.log.info("Creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            try {
                Object answer = ((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).create((Object[])new Template[]{entity});
                this.logGeneratedEntity("Created Template: ", namespace, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to Template entity from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyServiceAccount(ServiceAccount serviceAccount, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)serviceAccount);
        Objects.requireNonNull(id, "No name for " + serviceAccount + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring ServiceAccount: " + id, new Object[0]);
            return;
        }
        ServiceAccount old = (ServiceAccount)((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(serviceAccount, old)) {
                this.log.info("ServiceAccount has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).delete();
                this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
            } else {
                this.log.info("Updating a ServiceAccount from " + sourceName, new Object[0]);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).replace((Object)serviceAccount);
                    this.logGeneratedEntity("Updated ServiceAccount: ", namespace, (HasMetadata)serviceAccount, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount), new Object[0]);
        } else {
            this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
        }
    }

    protected void doCreateServiceAccount(ServiceAccount serviceAccount, String namespace, String sourceName) {
        this.log.info("Creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).create((Object[])new ServiceAccount[]{serviceAccount}) : ((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(this.getNamespace())).create((Object[])new ServiceAccount[]{serviceAccount});
            this.logGeneratedEntity("Created ServiceAccount: ", namespace, (HasMetadata)serviceAccount, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
        }
    }

    public void applyPersistentVolumeClaim(PersistentVolumeClaim entity, String sourceName) throws Exception {
        boolean alwaysRecreate = true;
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring PersistentVolumeClaim: " + id, new Object[0]);
            return;
        }
        PersistentVolumeClaim old = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(entity, old)) {
                this.log.info("PersistentVolumeClaim has not changed so not doing anything", new Object[0]);
            } else if (alwaysRecreate || this.isRecreateMode()) {
                if (!this.isRecreateMode() && this.isIgnoreBoundPersistentVolumeClaims() && this.isBound(old)) {
                    this.log.warn("PersistentVolumeClaim " + id + " in namespace " + namespace + " is already bound and will not be replaced with the new one from " + sourceName, new Object[0]);
                } else {
                    this.log.info("Deleting PersistentVolumeClaim from namespace " + namespace + " with name " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).withName(id)).delete();
                    this.log.info("Deleted PersistentVolumeClaim from namespace " + namespace + " with name " + id, new Object[0]);
                    this.doCreatePersistentVolumeClaim(entity, namespace, sourceName);
                }
            } else {
                this.log.info("Updating a PersistentVolumeClaim from " + sourceName, new Object[0]);
                try {
                    PersistentVolumeClaim answer = this.patchService.compareAndPatchEntity(namespace, entity, old);
                    this.logGeneratedEntity("Updated PersistentVolumeClaim: ", namespace, (HasMetadata)entity, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update PersistentVolumeClaim from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a PersistentVolumeClaim from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        } else {
            this.doCreatePersistentVolumeClaim(entity, namespace, sourceName);
        }
    }

    protected boolean isBound(PersistentVolumeClaim claim) {
        return claim != null && claim.getStatus() != null && "Bound".equals(claim.getStatus().getPhase());
    }

    protected void doCreatePersistentVolumeClaim(PersistentVolumeClaim entity, String namespace, String sourceName) {
        this.log.info("Creating a PersistentVolumeClaim from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).create((Object[])new PersistentVolumeClaim[]{entity}) : ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(this.getNamespace())).create((Object[])new PersistentVolumeClaim[]{entity});
            this.logGeneratedEntity("Created PersistentVolumeClaim: ", namespace, (HasMetadata)entity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create PersistentVolumeClaim from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applySecret(Secret secret, String sourceName) throws Exception {
        String namespace = this.getNamespace((HasMetadata)secret);
        String id = KubernetesHelper.getName((HasMetadata)secret);
        Objects.requireNonNull(id, "No name for " + secret + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Secrets: " + id, new Object[0]);
            return;
        }
        Secret old = (Secret)((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(secret, old)) {
                this.log.info("Secret has not changed so not doing anything", new Object[0]);
                return;
            }
            if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).delete();
                this.doCreateSecret(secret, namespace, sourceName);
            } else {
                this.log.info("Updating a Secret from " + sourceName, new Object[0]);
                try {
                    Secret answer = this.patchService.compareAndPatchEntity(namespace, secret, old);
                    this.logGeneratedEntity("Updated Secret:", namespace, (HasMetadata)secret, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update secret from " + sourceName + ". " + e + ". " + secret, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret), new Object[0]);
        } else {
            this.doCreateSecret(secret, namespace, sourceName);
        }
    }

    protected void doCreateSecret(Secret secret, String namespace, String sourceName) {
        this.log.info("Creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create((Object[])new Secret[]{secret}) : ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(this.getNamespace())).create((Object[])new Secret[]{secret});
            this.logGeneratedEntity("Created Secret: ", namespace, (HasMetadata)secret, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Secret from " + sourceName + ". " + e + ". " + secret, e);
        }
    }

    protected void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File namespaceDir = new File(this.logJsonDir, namespace);
            namespaceDir.mkdirs();
            String kind = KubernetesHelper.getKind(entity);
            String name = KubernetesHelper.getName(entity);
            if (StringUtils.isNotBlank((CharSequence)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.log.warn("No name for the entity " + entity, new Object[0]);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(namespaceDir, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(namespaceDir, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = ResourceUtil.toJson(result);
                    }
                    catch (JsonProcessingException e) {
                        this.log.warn("Cannot convert " + result + " to JSON: " + (Object)((Object)e), new Object[]{e});
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    FileUtils.writeStringToFile((File)file, (String)text, (Charset)Charset.defaultCharset());
                    Object fileLocation = file;
                    if (this.basedir != null && (path = FileUtil.getRelativePath(this.basedir, file).getPath()) != null) {
                        fileLocation = FileUtil.stripPrefix(path, "/");
                    }
                    this.log.info(message + fileLocation, new Object[0]);
                }
                catch (IOException e) {
                    this.log.warn("Failed to write to file " + file + ". " + e, new Object[]{e});
                }
                return;
            }
        }
        this.log.info(message + result, new Object[0]);
    }

    public Object processTemplate(Template entity, String sourceName) {
        try {
            return OpenshiftHelper.processTemplatesLocally(entity, false);
        }
        catch (IOException e) {
            this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
            return null;
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            Route route;
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (StringUtils.isBlank((CharSequence)namespace)) {
                namespace = this.getNamespace();
            }
            if ((route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(id)).get()) == null) {
                try {
                    this.log.info("Creating Route " + namespace + ":" + id + " " + (entity.getSpec() != null ? "host: " + entity.getSpec().getHost() : "No Spec !"), new Object[0]);
                    ((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).create((Object[])new Route[]{entity});
                }
                catch (Exception e) {
                    this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (StringUtils.isBlank((CharSequence)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            BuildConfig old = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    this.log.info("BuildConfig has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting BuildConfig: " + id, new Object[0]);
                    ((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).delete();
                    this.doCreateBuildConfig(entity, namespace, sourceName);
                } else {
                    this.log.info("Updating BuildConfig from " + sourceName, new Object[0]);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        BuildConfig answer = this.patchService.compareAndPatchEntity(namespace, entity, old);
                        this.logGeneratedEntity("Updated BuildConfig: ", namespace, (HasMetadata)entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update BuildConfig from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateBuildConfig(entity, namespace, sourceName);
            }
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create((Object[])new BuildConfig[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyRoleBinding(RoleBinding entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (StringUtils.isBlank((CharSequence)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            RoleBinding old = (RoleBinding)((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    this.log.info("RoleBinding has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting RoleBinding: " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).delete();
                    this.doCreateRoleBinding(entity, namespace, sourceName);
                } else {
                    this.log.info("Updating RoleBinding from " + sourceName, new Object[0]);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        Object answer = ((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).replace((Object)entity);
                        this.logGeneratedEntity("Updated RoleBinding: ", namespace, (HasMetadata)entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update RoleBinding from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating RoleBinding from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateRoleBinding(entity, namespace, sourceName);
            }
        }
    }

    public void doCreateRoleBinding(RoleBinding entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).create((Object[])new RoleBinding[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create RoleBinding from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String kind = KubernetesHelper.getKind((HasMetadata)entity);
            String name = KubernetesHelper.getName((HasMetadata)entity);
            String namespace = this.getNamespace();
            try {
                Resource resource = (Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(namespace)).withName(name);
                ImageStream old = (ImageStream)resource.get();
                if (old == null) {
                    this.log.info("Creating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    resource.create((Object[])new ImageStream[]{entity});
                } else {
                    this.log.info("Updating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    this.copyAllImageStreamTags(entity, old);
                    this.patchService.compareAndPatchEntity(namespace, entity, old);
                }
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)openShiftClient.resource((HasMetadata)entity).inNamespace(namespace)).createOrReplace();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e, e);
            }
        }
    }

    protected void copyAllImageStreamTags(ImageStream from, ImageStream to) {
        List fromTags;
        ImageStreamSpec fromSpec;
        ArrayList<TagReference> toTags;
        ImageStreamSpec toSpec = to.getSpec();
        if (toSpec == null) {
            toSpec = new ImageStreamSpec();
            to.setSpec(toSpec);
        }
        if ((toTags = toSpec.getTags()) == null) {
            toTags = new ArrayList<TagReference>();
            toSpec.setTags(toTags);
        }
        if ((fromSpec = from.getSpec()) != null && (fromTags = fromSpec.getTags()) != null) {
            for (TagReference tag : fromTags) {
                this.removeTagByName(toTags, tag.getName());
            }
            for (TagReference tag : fromTags) {
                toTags.add(tag);
            }
        }
    }

    private int removeTagByName(List<TagReference> tags, String tagName) {
        ArrayList<TagReference> removeTags = new ArrayList<TagReference>();
        for (TagReference tag : tags) {
            if (!Objects.equals(tagName, tag.getName())) continue;
            removeTags.add(tag);
        }
        tags.removeAll(removeTags);
        return removeTags.size();
    }

    public void applyList(KubernetesList list, String sourceName) throws Exception {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)service);
        Objects.requireNonNull(id, "No name for " + service + " " + sourceName);
        if (this.isIgnoreServiceMode()) {
            this.log.debug("Ignoring Service: " + namespace + ":" + id, new Object[0]);
            return;
        }
        Service old = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(service, old)) {
                this.log.info("Service has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting Service: " + id, new Object[0]);
                ((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).delete();
                this.doCreateService(service, namespace, sourceName);
            } else {
                this.log.info("Updating a Service from " + sourceName, new Object[0]);
                try {
                    Service answer = this.patchService.compareAndPatchEntity(namespace, service, old);
                    this.logGeneratedEntity("Updated Service: ", namespace, (HasMetadata)service, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Service from " + sourceName + ". " + e + ". " + service, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service), new Object[0]);
        } else {
            this.doCreateService(service, namespace, sourceName);
        }
    }

    public <T extends HasMetadata, L, D> void applyResource(T resource, String sourceName, MixedOperation<T, L, D, ? extends Resource<T, D>> resources) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(resource);
        String kind = KubernetesHelper.getKind(resource);
        Objects.requireNonNull(id, "No name for " + resource + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Ignoring " + kind + ": " + namespace + ":" + id, new Object[0]);
            return;
        }
        HasMetadata old = (HasMetadata)((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(resource, old)) {
                this.log.info(kind + " has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting " + kind + ": " + id, new Object[0]);
                ((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).delete();
                this.doCreateResource(resource, namespace, sourceName, resources);
            } else {
                this.log.info("Updating " + kind + " from " + sourceName, new Object[0]);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).replace(resource);
                    this.logGeneratedEntity("Updated " + kind + ": ", namespace, resource, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource), new Object[0]);
        } else {
            this.doCreateResource(resource, namespace, sourceName, resources);
        }
    }

    protected <T extends HasMetadata, L, D> void doCreateResource(T resource, String namespace, String sourceName, MixedOperation<T, L, D, ? extends Resource<T, D>> resources) throws Exception {
        String kind = KubernetesHelper.getKind(resource);
        this.log.info("Creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)resources.inNamespace(namespace)).create((Object[])new HasMetadata[]{resource}) : ((NonNamespaceOperation)resources.inNamespace(this.getNamespace())).create((Object[])new HasMetadata[]{resource});
            this.logGeneratedEntity("Created " + kind + ": ", namespace, resource, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        this.log.info("Creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create((Object[])new Service[]{service}) : ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.getNamespace())).create((Object[])new Service[]{service});
            this.logGeneratedEntity("Created Service: ", namespace, (HasMetadata)service, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public boolean checkNamespace(String namespaceName) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            List projects = ((ProjectList)openshiftClient.projects().list()).getItems();
            for (Project project : projects) {
                if (!namespaceName.equals(project.getMetadata().getName())) continue;
                return true;
            }
            return false;
        }
        return ((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).get() != null;
    }

    public boolean deleteNamespace(String namespaceName) {
        if (!this.checkNamespace(namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            return (Boolean)((Resource)openshiftClient.projects().withName(namespaceName)).delete();
        }
        return (Boolean)((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).delete();
    }

    public void applyNamespace(String namespaceName) {
        this.applyNamespace(namespaceName, null);
    }

    public void applyNamespace(String namespaceName, Map<String, String> labels) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            ProjectRequest entity = new ProjectRequest();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String namespace = this.kubernetesClient.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)namespace)) {
                Map<String, String> entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", namespace);
                }
            }
            this.applyProjectRequest(entity);
        } else {
            Namespace entity = new Namespace();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String namespace = this.kubernetesClient.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)namespace)) {
                Map<String, String> entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", namespace);
                }
            }
            this.applyNamespace(entity);
        }
    }

    public boolean applyNamespace(Namespace entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        this.log.info("Using namespace: " + namespace, new Object[0]);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(name, "No name for " + entity);
        Namespace old = (Namespace)((Resource)this.kubernetesClient.namespaces().withName(name)).get();
        if (!this.isRunning((HasMetadata)old)) {
            try {
                Object answer = this.kubernetesClient.namespaces().create((Object[])new Namespace[]{entity});
                this.logGeneratedEntity("Created namespace: ", namespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create namespace: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public boolean applyProjectRequest(ProjectRequest entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        this.log.info("Using project: " + namespace, new Object[0]);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(name, "No name for " + entity);
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient == null) {
            this.log.warn("Cannot check for Project " + namespace + " as not running against OpenShift!", new Object[0]);
            return false;
        }
        boolean exists = this.checkNamespace(name);
        if (!exists) {
            try {
                Object answer = openshiftClient.projectrequests().create((Object[])new ProjectRequest[]{entity});
                this.logGeneratedEntity("Created ProjectRequest: ", namespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create ProjectRequest: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) throws Exception {
        block15: {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)replicationController);
            Objects.requireNonNull(id, "No name for " + replicationController + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring ReplicationController: " + namespace + ":" + id, new Object[0]);
                return;
            }
            ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(replicationController, old)) {
                    this.log.info("ReplicationController has not changed so not doing anything", new Object[0]);
                } else {
                    ReplicationControllerSpec newSpec = replicationController.getSpec();
                    ReplicationControllerSpec oldSpec = old.getSpec();
                    if (this.rollingUpgrade) {
                        Integer replicas;
                        this.log.info("Rolling upgrade of the ReplicationController: " + namespace + "/" + id, new Object[0]);
                        if (this.rollingUpgradePreserveScale && newSpec != null && oldSpec != null && (replicas = oldSpec.getReplicas()) != null) {
                            newSpec.setReplicas(replicas);
                        }
                        this.log.info("rollingUpgradePreserveScale " + this.rollingUpgradePreserveScale + " new replicas is " + (newSpec != null ? newSpec.getReplicas() : "<null>"), new Object[0]);
                        ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).rolling()).replace((Object)replicationController);
                    } else if (this.isRecreateMode()) {
                        this.log.info("Deleting ReplicationController: " + id, new Object[0]);
                        ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateReplicationController(replicationController, namespace, sourceName);
                    } else {
                        this.log.info("Updating ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
                        try {
                            ReplicationController answer = this.patchService.compareAndPatchEntity(namespace, replicationController, old);
                            this.logGeneratedEntity("Updated replicationController: ", namespace, (HasMetadata)replicationController, answer);
                            if (this.deletePodsOnReplicationControllerUpdate) {
                                ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withLabels(newSpec.getSelector())).delete();
                                this.log.info("Deleting any pods for the replication controller to ensure they use the new configuration", new Object[0]);
                                break block15;
                            }
                            this.log.info("Warning not deleted any pods so they could well be running with the old configuration!", new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
            } else {
                this.doCreateReplicationController(replicationController, namespace, sourceName);
            }
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        this.log.info("Creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).create((Object[])new ReplicationController[]{replicationController}) : ((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(this.getNamespace())).create((Object[])new ReplicationController[]{replicationController});
            this.logGeneratedEntity("Created ReplicationController: ", namespace, (HasMetadata)replicationController, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    public void applyPod(Pod pod, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)pod);
        Objects.requireNonNull(id, "No name for " + pod + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Pod: " + namespace + ":" + id, new Object[0]);
            return;
        }
        Pod old = (Pod)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(pod, old)) {
                this.log.info("Pod has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting Pod: " + id, new Object[0]);
                ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).delete();
                this.doCreatePod(pod, namespace, sourceName);
            } else {
                this.log.info("Updating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod), new Object[0]);
                try {
                    Pod answer = this.patchService.compareAndPatchEntity(namespace, pod, old);
                    this.log.info("Updated Pod result: " + answer, new Object[0]);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Pod from " + sourceName + ". " + e + ". " + pod, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod), new Object[0]);
        } else {
            this.doCreatePod(pod, namespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        this.log.info("Creating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod), new Object[0]);
        try {
            Object answer = StringUtils.isNotBlank((CharSequence)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod}) : ((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.getNamespace())).create((Object[])new Pod[]{pod});
            this.log.info("Created Pod result: " + answer, new Object[0]);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected String getNamespace(HasMetadata entity) {
        String answer = KubernetesHelper.getNamespace(entity);
        if (StringUtils.isBlank((CharSequence)answer)) {
            answer = this.getNamespace();
        }
        this.applyNamespace(answer);
        return answer;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        this.log.error(message, new Object[]{e});
        throw new RuntimeException(message, e);
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isIgnoreBoundPersistentVolumeClaims() {
        return this.ignoreBoundPersistentVolumeClaims;
    }

    public void setIgnoreBoundPersistentVolumeClaims(boolean ignoreBoundPersistentVolumeClaims) {
        this.ignoreBoundPersistentVolumeClaims = ignoreBoundPersistentVolumeClaims;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }

    public void setRollingUpgrade(boolean rollingUpgrade) {
        this.rollingUpgrade = rollingUpgrade;
    }

    public void setRollingUpgradePreserveScale(boolean rollingUpgradePreserveScale) {
        this.rollingUpgradePreserveScale = rollingUpgradePreserveScale;
    }
}

