/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeploymentConfigHandler {
    private final PodTemplateHandler podTemplateHandler;

    DeploymentConfigHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public DeploymentConfig getDeploymentConfig(ResourceConfig config, List<ImageConfiguration> images, Long openshiftDeployTimeoutSeconds, Boolean imageChangeTrigger, Boolean enableAutomaticTrigger, Boolean isOpenshiftBuildStrategy) {
        DeploymentConfig deploymentConfig = ((DeploymentConfigBuilder)((DeploymentConfigBuilder)new DeploymentConfigBuilder().withMetadata(this.createDeploymentConfigMetaData(config))).withSpec(this.createDeploymentConfigSpec(config, images, openshiftDeployTimeoutSeconds, imageChangeTrigger, enableAutomaticTrigger, isOpenshiftBuildStrategy))).build();
        return deploymentConfig;
    }

    private ObjectMeta createDeploymentConfigMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId(config.getControllerName(), "controller name"))).build();
    }

    private DeploymentConfigSpec createDeploymentConfigSpec(ResourceConfig config, List<ImageConfiguration> images, Long openshiftDeployTimeoutSeconds, Boolean imageChangeTrigger, Boolean enableAutomaticTrigger, Boolean isOpenshiftBuildStrategy) {
        DeploymentConfigSpecBuilder specBuilder = new DeploymentConfigSpecBuilder();
        PodTemplateSpec podTemplateSpec = this.podTemplateHandler.getPodTemplate(config, images);
        PodSpec podSpec = podTemplateSpec.getSpec();
        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigSpecBuilder)((DeploymentConfigSpecBuilder)specBuilder.withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(podTemplateSpec)).addNewTrigger().withType("ConfigChange")).endTrigger();
        HashMap<String, String> containerToImageMap = new HashMap<String, String>();
        Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + podTemplateSpec);
        List containers = podSpec.getContainers();
        Objects.requireNonNull(podSpec, "No containers for PodTemplate.spec: " + podTemplateSpec);
        for (Container container : containers) {
            this.validateContainer(container);
            containerToImageMap.put(container.getName(), container.getImage());
        }
        if (containerToImageMap.size() != 0 && imageChangeTrigger.booleanValue() && isOpenshiftBuildStrategy.booleanValue()) {
            for (Map.Entry entry : containerToImageMap.entrySet()) {
                String containerName = (String)entry.getKey();
                ImageName image = new ImageName((String)entry.getValue());
                String tag = image.getTag() != null ? image.getTag() : "latest";
                ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(enableAutomaticTrigger)).withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).withNamespace(image.getUser())).endFrom()).withContainerNames(new String[]{containerName})).endImageChangeParams()).endTrigger();
            }
        }
        if (openshiftDeployTimeoutSeconds != null && openshiftDeployTimeoutSeconds > 0L) {
            ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
        }
        return specBuilder.build();
    }

    private void validateContainer(Container container) {
        if (container.getImage() == null) {
            throw new IllegalArgumentException("Container " + container.getName() + " has no Docker image configured. Please check your Docker image configuration (including the generators which are supposed to run)");
        }
    }
}

