/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NamePatternUtil {
    public static final String IMAGE_FIELD = "image";
    public static final String NAME_FIELD = "name";

    public static String convertNamePattern(String pattern) {
        String REGEX_PREFIX = "%regex[";
        String ANT_PREFIX = "%ant[";
        String PATTERN_SUFFIX = "]";
        if (pattern.startsWith("%regex[") && pattern.endsWith("]")) {
            return pattern.substring("%regex[".length(), pattern.length() - "]".length());
        }
        if (pattern.startsWith("%ant[") && pattern.endsWith("]")) {
            pattern = pattern.substring("%ant[".length(), pattern.length() - "]".length());
        }
        String[] parts = pattern.split("((?=[/:?*])|(?<=[/:?*]))");
        Matcher matcher = Pattern.compile("[A-Za-z0-9-]+").matcher("");
        StringBuilder builder = new StringBuilder("^");
        for (int i = 0; i < parts.length; ++i) {
            if ("?".equals(parts[i])) {
                builder.append("[^/:]");
                continue;
            }
            if ("*".equals(parts[i])) {
                if (i + 1 < parts.length && "*".equals(parts[i + 1])) {
                    builder.append("([^:]|:(?=.*:))*");
                    if (++i + 1 >= parts.length || !"/".equals(parts[i + 1])) continue;
                    builder.append("(?<![^/])");
                    ++i;
                    continue;
                }
                builder.append("([^/:]|:(?=.*:))*");
                continue;
            }
            if ("/".equals(parts[i]) || ":".equals(parts[i]) || matcher.reset(parts[i]).matches()) {
                builder.append(parts[i]);
                continue;
            }
            if (parts[i].length() <= 0) continue;
            builder.append(Pattern.quote(parts[i]));
        }
        builder.append("$");
        return builder.toString();
    }

    public static String convertNamePatternList(String patternList) {
        return NamePatternUtil.convertNamePatternList(patternList, null, true);
    }

    public static String convertNamePatternList(String patternList, String fieldName, boolean includeUnnamed) {
        String[] patterns = patternList.split(",");
        StringBuilder combinedPattern = new StringBuilder("(");
        boolean compound = false;
        for (String pattern : patterns) {
            String converted;
            String[] namedFieldPattern = (pattern = pattern.trim()).split("=", 2);
            if (namedFieldPattern.length == 2) {
                if (!namedFieldPattern[0].trim().equals(fieldName)) continue;
                pattern = namedFieldPattern[1].trim();
            } else if (fieldName != null && !includeUnnamed) continue;
            if (pattern.length() <= 0 || (converted = NamePatternUtil.convertNamePattern(pattern)).length() == 0) continue;
            try {
                Pattern.compile(converted);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Unable to convert pattern " + pattern + " to regular expression. " + e.getMessage(), e);
            }
            if (combinedPattern.length() > 1) {
                compound = true;
                combinedPattern.append('|');
            }
            combinedPattern.append(converted);
        }
        if (compound) {
            combinedPattern.append(')');
        } else {
            combinedPattern.deleteCharAt(0);
        }
        return combinedPattern.length() == 0 ? null : combinedPattern.toString();
    }
}

