/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.fabric8.maven.docker.model.ImageArchiveManifest;
import io.fabric8.maven.docker.model.ImageArchiveManifestAdapter;
import io.fabric8.maven.docker.model.ImageArchiveManifestEntry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.lang3.tuple.Pair;

public class ImageArchiveUtil {
    public static final String MANIFEST_JSON = "manifest.json";

    private static InputStream createUncompressedStream(InputStream possiblyCompressed) {
        if (!possiblyCompressed.markSupported()) {
            possiblyCompressed = new BufferedInputStream(possiblyCompressed, 512000);
        }
        try {
            return new CompressorStreamFactory().createCompressorInputStream(possiblyCompressed);
        }
        catch (CompressorException e) {
            return possiblyCompressed;
        }
    }

    public static ImageArchiveManifest readManifest(File file) throws IOException, JsonParseException {
        return ImageArchiveUtil.readManifest(new FileInputStream(file));
    }

    public static ImageArchiveManifest readManifest(InputStream inputStream) throws IOException, JsonParseException {
        LinkedHashMap<String, JsonParseException> parseExceptions = new LinkedHashMap<String, JsonParseException>();
        LinkedHashMap<String, JsonElement> parsedEntries = new LinkedHashMap<String, JsonElement>();
        try (TarArchiveInputStream tarStream = new TarArchiveInputStream(ImageArchiveUtil.createUncompressedStream(inputStream));){
            TarArchiveEntry tarEntry;
            Gson gson = new Gson();
            while ((tarEntry = tarStream.getNextTarEntry()) != null) {
                if (!tarEntry.isFile() || !tarEntry.getName().endsWith(".json")) continue;
                try {
                    JsonElement element = (JsonElement)gson.fromJson((Reader)new InputStreamReader((InputStream)tarStream, StandardCharsets.UTF_8), JsonElement.class);
                    parsedEntries.put(tarEntry.getName(), element);
                }
                catch (JsonParseException exception) {
                    parseExceptions.put(tarEntry.getName(), exception);
                }
            }
        }
        JsonElement manifestJson = (JsonElement)parsedEntries.get(MANIFEST_JSON);
        if (manifestJson == null) {
            JsonParseException parseException = (JsonParseException)((Object)parseExceptions.get(MANIFEST_JSON));
            if (parseException != null) {
                throw parseException;
            }
            return null;
        }
        ImageArchiveManifestAdapter manifest = new ImageArchiveManifestAdapter(manifestJson);
        for (ImageArchiveManifestEntry entry : manifest.getEntries()) {
            JsonElement entryConfigJson = (JsonElement)parsedEntries.get(entry.getConfig());
            if (entryConfigJson == null || !entryConfigJson.isJsonObject()) continue;
            manifest.putConfig(entry.getConfig(), entryConfigJson.getAsJsonObject());
        }
        return manifest;
    }

    public static ImageArchiveManifestEntry findEntryByRepoTag(String repoTag, ImageArchiveManifest manifest) {
        if (repoTag == null || manifest == null) {
            return null;
        }
        for (ImageArchiveManifestEntry entry : manifest.getEntries()) {
            for (String entryRepoTag : entry.getRepoTags()) {
                if (!repoTag.equals(entryRepoTag)) continue;
                return entry;
            }
        }
        return null;
    }

    public static Pair<String, ImageArchiveManifestEntry> findEntryByRepoTagPattern(String repoTagPattern, ImageArchiveManifest manifest) throws PatternSyntaxException {
        return ImageArchiveUtil.findEntryByRepoTagPattern(repoTagPattern == null ? null : Pattern.compile(repoTagPattern), manifest);
    }

    public static Pair<String, ImageArchiveManifestEntry> findEntryByRepoTagPattern(Pattern repoTagPattern, ImageArchiveManifest manifest) throws PatternSyntaxException {
        if (repoTagPattern == null || manifest == null) {
            return null;
        }
        Matcher matcher = repoTagPattern.matcher("");
        for (ImageArchiveManifestEntry entry : manifest.getEntries()) {
            for (String entryRepoTag : entry.getRepoTags()) {
                if (!matcher.reset(entryRepoTag).find()) continue;
                return Pair.of((Object)entryRepoTag, (Object)entry);
            }
        }
        return null;
    }

    public static Map<String, ImageArchiveManifestEntry> findEntriesByRepoTagPattern(String repoTagPattern, ImageArchiveManifest manifest) throws PatternSyntaxException {
        return ImageArchiveUtil.findEntriesByRepoTagPattern(repoTagPattern == null ? null : Pattern.compile(repoTagPattern), manifest);
    }

    public static Map<String, ImageArchiveManifestEntry> findEntriesByRepoTagPattern(Pattern repoTagPattern, ImageArchiveManifest manifest) throws PatternSyntaxException {
        LinkedHashMap<String, ImageArchiveManifestEntry> entries = new LinkedHashMap<String, ImageArchiveManifestEntry>();
        if (repoTagPattern == null || manifest == null) {
            return entries;
        }
        Matcher matcher = repoTagPattern.matcher("");
        for (ImageArchiveManifestEntry entry : manifest.getEntries()) {
            for (String entryRepoTag : entry.getRepoTags()) {
                if (!matcher.reset(entryRepoTag).find()) continue;
                entries.putIfAbsent(entryRepoTag, entry);
            }
        }
        return entries;
    }

    public static Map<String, ImageArchiveManifestEntry> mapEntriesById(Iterable<ImageArchiveManifestEntry> entries) {
        LinkedHashMap<String, ImageArchiveManifestEntry> mapped = new LinkedHashMap<String, ImageArchiveManifestEntry>();
        for (ImageArchiveManifestEntry entry : entries) {
            mapped.put(entry.getId(), entry);
        }
        return mapped;
    }
}

