/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.model.ImageArchiveManifestEntry;
import java.util.ArrayList;
import java.util.List;

public class ImageArchiveManifestEntryAdapter
implements ImageArchiveManifestEntry {
    public static final String CONFIG = "Config";
    public static final String REPO_TAGS = "RepoTags";
    public static final String LAYERS = "Layers";
    public static final String CONFIG_JSON_SUFFIX = ".json";
    private String config;
    private List<String> repoTags;
    private List<String> layers;

    public ImageArchiveManifestEntryAdapter(JsonObject json) {
        JsonElement field = json.get(CONFIG);
        if (field != null && field.isJsonPrimitive()) {
            this.config = field.getAsString();
        }
        this.repoTags = new ArrayList<String>();
        field = json.get(REPO_TAGS);
        if (field != null && field.isJsonArray()) {
            for (JsonElement item : field.getAsJsonArray()) {
                if (!item.isJsonPrimitive()) continue;
                this.repoTags.add(item.getAsString());
            }
        }
        this.layers = new ArrayList<String>();
        field = json.get(LAYERS);
        if (field != null && field.isJsonArray()) {
            for (JsonElement item : field.getAsJsonArray()) {
                if (!item.isJsonPrimitive()) continue;
                this.layers.add(item.getAsString());
            }
        }
    }

    @Override
    public String getConfig() {
        return this.config;
    }

    @Override
    public String getId() {
        return this.config == null || !this.config.endsWith(CONFIG_JSON_SUFFIX) ? this.config : this.config.substring(0, this.config.length() - CONFIG_JSON_SUFFIX.length());
    }

    @Override
    public List<String> getRepoTags() {
        return this.repoTags;
    }

    @Override
    public List<String> getLayers() {
        return this.layers;
    }
}

