/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util.aws;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.util.Logger;

public class AwsSdkAuthConfigFactory {
    private final Logger log;

    public AwsSdkAuthConfigFactory(Logger log) {
        this.log = log;
    }

    public AuthConfig createAuthConfig() {
        try {
            Class<?> credentialsProviderChainClass = Class.forName("com.amazonaws.auth.DefaultAWSCredentialsProviderChain");
            Object credentialsProviderChain = credentialsProviderChainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object credentials = credentialsProviderChainClass.getMethod("getCredentials", new Class[0]).invoke(credentialsProviderChain, new Object[0]);
            if (credentials == null) {
                return null;
            }
            Class<?> sessionCredentialsClass = Class.forName("com.amazonaws.auth.AWSSessionCredentials");
            String sessionToken = sessionCredentialsClass.isInstance(credentials) ? (String)sessionCredentialsClass.getMethod("getSessionToken", new Class[0]).invoke(credentials, new Object[0]) : null;
            Class<?> credentialsClass = Class.forName("com.amazonaws.auth.AWSCredentials");
            return new AuthConfig((String)credentialsClass.getMethod("getAWSAccessKeyId", new Class[0]).invoke(credentials, new Object[0]), (String)credentialsClass.getMethod("getAWSSecretKey", new Class[0]).invoke(credentials, new Object[0]), "none", sessionToken);
        }
        catch (Throwable t) {
            this.log.warn("AWS SDK detected, but failed to fetch AWS credentials: %s", t);
            return null;
        }
    }
}

