/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.Timestamp;
import io.fabric8.maven.docker.wait.LogWaitCheckerCallback;
import java.util.regex.Pattern;

class LogMatchCallback
implements LogCallback {
    private final Logger logger;
    private final LogWaitCheckerCallback callback;
    private final Pattern pattern;
    private StringBuilder logBuffer;

    LogMatchCallback(Logger logger, LogWaitCheckerCallback callback, String patternString) {
        this.logger = logger;
        this.callback = callback;
        this.pattern = Pattern.compile(patternString);
        this.logBuffer = (this.pattern.flags() & 0x20) != 0 ? new StringBuilder() : null;
    }

    @Override
    public void log(int type, Timestamp timestamp, String txt) throws LogCallback.DoneException {
        String toMatch;
        this.logger.debug("LogWaitChecker: Trying to match '%s' [Pattern: %s] [thread: %d]", txt, this.pattern.pattern(), Thread.currentThread().getId());
        if (this.logBuffer != null) {
            this.logBuffer.append(txt).append("\n");
            toMatch = this.logBuffer.toString();
        } else {
            toMatch = txt;
        }
        if (this.pattern.matcher(toMatch).find()) {
            this.logger.debug("Found log-wait pattern in log output", new Object[0]);
            this.callback.matched();
            throw new LogCallback.DoneException();
        }
    }

    @Override
    public void error(String error) {
        this.logger.error("%s", error);
    }

    @Override
    public void close() {
        this.logger.debug("Closing LogWaitChecker callback", new Object[0]);
    }

    @Override
    public void open() {
        this.logger.debug("Open LogWaitChecker callback", new Object[0]);
    }
}

