/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.codehaus.plexus.archiver.tar.TarArchiver;

public enum ArchiveCompression {
    none(TarArchiver.TarCompressionMethod.none, "tar"),
    gzip(TarArchiver.TarCompressionMethod.gzip, "tar.gz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new GZIPOutputStream(out);
        }
    }
    ,
    bzip2(TarArchiver.TarCompressionMethod.bzip2, "tar.bz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new BZip2CompressorOutputStream(out);
        }
    };

    private final TarArchiver.TarCompressionMethod tarCompressionMethod;
    private final String fileSuffix;

    private ArchiveCompression(TarArchiver.TarCompressionMethod tarCompressionMethod, String fileSuffix) {
        this.tarCompressionMethod = tarCompressionMethod;
        this.fileSuffix = fileSuffix;
    }

    public TarArchiver.TarCompressionMethod getTarCompressionMethod() {
        return this.tarCompressionMethod;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) throws IOException {
        return outputStream;
    }

    public static ArchiveCompression fromFileName(String filename) {
        if (filename.endsWith(".tar.gz") || filename.endsWith(".tgz")) {
            return gzip;
        }
        if (filename.endsWith(".tar.bz") || filename.endsWith(".tar.bzip2") || filename.endsWith(".tar.bz2")) {
            return bzip2;
        }
        return none;
    }
}

