/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.config.WatchMode;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.MojoExecutionService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.PomLabel;
import io.fabric8.maven.docker.util.StartOrderResolver;
import io.fabric8.maven.docker.util.Task;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class WatchService {
    private final ArchiveService archiveService;
    private final BuildService buildService;
    private final DockerAccess dockerAccess;
    private final MojoExecutionService mojoExecutionService;
    private final QueryService queryService;
    private final RunService runService;
    private final Logger log;

    public WatchService(ArchiveService archiveService, BuildService buildService, DockerAccess dockerAccess, MojoExecutionService mojoExecutionService, QueryService queryService, RunService runService, Logger log) {
        this.archiveService = archiveService;
        this.buildService = buildService;
        this.dockerAccess = dockerAccess;
        this.mojoExecutionService = mojoExecutionService;
        this.queryService = queryService;
        this.runService = runService;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void watch(WatchContext context, BuildService.BuildContext buildContext, List<ImageConfiguration> images) throws DockerAccessException, MojoExecutionException {
        ScheduledExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadScheduledExecutor();
            for (StartOrderResolver.Resolvable resolvable : this.runService.getImagesConfigsInOrder(this.queryService, images)) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageId = this.queryService.getImageId(imageConfig.getName());
                String containerId = this.runService.lookupContainer(imageConfig.getName());
                ImageWatcher watcher = new ImageWatcher(imageConfig, context, imageId, containerId);
                long interval = watcher.getInterval();
                WatchMode watchMode = watcher.getWatchMode(imageConfig);
                this.log.info("Watching " + imageConfig.getName() + (watchMode != null ? " using " + watchMode.getDescription() : ""), new Object[0]);
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssemblyConfiguration() != null) {
                    if (watcher.isCopy()) {
                        String containerBaseDir = imageConfig.getBuildConfiguration().getAssemblyConfiguration().getTargetDir();
                        this.schedule(executor, this.createCopyWatchTask(watcher, context.getMojoParameters(), containerBaseDir), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(executor, this.createBuildWatchTask(watcher, context.getMojoParameters(), watchMode == WatchMode.both, buildContext), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (watcher.isRun() && watcher.getContainerId() != null) {
                    this.schedule(executor, this.createRestartWatchTask(watcher), interval);
                    tasks.add("restarting");
                }
                if (tasks.size() <= 0) continue;
                this.log.info("%s: Watch for %s", imageConfig.getDescription(), StringUtils.join((Object[])tasks.toArray(), (String)" and "));
            }
            this.log.info("Waiting ...", new Object[0]);
            if (!context.isKeepRunning()) {
                this.runService.addShutdownHookForStoppingContainers(context.isKeepContainer(), context.isRemoveVolumes(), context.isAutoCreateCustomNetworks());
            }
            this.wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private void schedule(ScheduledExecutorService executor, Runnable runnable, long interval) {
        executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(final ImageWatcher watcher, final MojoParameters mojoParameters, final String containerBaseDir) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Copying changed files to container ...", imageConfig.getDescription());
                        File changedFilesArchive = WatchService.this.archiveService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), mojoParameters);
                        WatchService.this.dockerAccess.copyArchive(watcher.getContainerId(), changedFilesArchive, containerBaseDir);
                        WatchService.this.callPostExec(watcher);
                    }
                    catch (IOException | MojoExecutionException e) {
                        WatchService.this.log.error("%s: Error when copying files to container %s: %s", imageConfig.getDescription(), watcher.getContainerId(), e.getMessage());
                    }
                }
            }
        };
    }

    private void callPostExec(ImageWatcher watcher) throws DockerAccessException {
        if (watcher.getPostExec() != null) {
            String containerId = watcher.getContainerId();
            this.runService.execInContainer(containerId, watcher.getPostExec(), watcher.getImageConfiguration());
        }
    }

    private Runnable createBuildWatchTask(final ImageWatcher watcher, MojoParameters mojoParameters, final boolean doRestart, final BuildService.BuildContext buildContext) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        if (files.isEmpty()) {
            this.log.error("No assembly files for %s. Are you sure you invoked together with the `package` goal?", imageConfig.getDescription());
            throw new MojoExecutionException("No files to watch found for " + imageConfig);
        }
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Rebuild ...", imageConfig.getDescription());
                        if (watcher.getWatchContext().getImageCustomizer() != null) {
                            WatchService.this.log.info("%s: Customizing the image ...", imageConfig.getDescription());
                            watcher.getWatchContext().getImageCustomizer().execute(imageConfig);
                        }
                        WatchService.this.buildService.buildImage(imageConfig, buildContext);
                        String name = imageConfig.getName();
                        watcher.setImageId(WatchService.this.queryService.getImageId(name));
                        if (doRestart) {
                            WatchService.this.restartContainer(watcher);
                        }
                        WatchService.this.callPostGoal(watcher);
                    }
                    catch (Exception e) {
                        WatchService.this.log.error("%s: Error when rebuilding - %s", imageConfig.getDescription(), e);
                    }
                }
            }
        };
    }

    private Runnable createRestartWatchTask(final ImageWatcher watcher) throws DockerAccessException {
        final String imageName = watcher.getImageName();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String currentImageId = WatchService.this.queryService.getImageId(imageName);
                    String oldValue = watcher.getAndSetImageId(currentImageId);
                    if (!currentImageId.equals(oldValue)) {
                        WatchService.this.restartContainer(watcher);
                        WatchService.this.callPostGoal(watcher);
                    }
                }
                catch (Exception e) {
                    WatchService.this.log.warn("%s: Error when restarting image - %s", watcher.getImageConfiguration().getDescription(), e);
                }
            }
        };
    }

    private void restartContainer(ImageWatcher watcher) throws Exception {
        Task<ImageWatcher> restarter = watcher.getWatchContext().getContainerRestarter();
        if (restarter == null) {
            restarter = this.defaultContainerRestartTask();
        }
        restarter.execute(watcher);
    }

    private Task<ImageWatcher> defaultContainerRestartTask() {
        return new Task<ImageWatcher>(){

            @Override
            public void execute(ImageWatcher watcher) throws Exception {
                ImageConfiguration imageConfig = watcher.getImageConfiguration();
                PortMapping mappedPorts = WatchService.this.runService.createPortMapping(imageConfig.getRunConfiguration(), watcher.getWatchContext().getMojoParameters().getProject().getProperties());
                String id = watcher.getContainerId();
                String optionalPreStop = WatchService.this.getPreStopCommand(imageConfig);
                if (optionalPreStop != null) {
                    WatchService.this.runService.execInContainer(id, optionalPreStop, watcher.getImageConfiguration());
                }
                WatchService.this.runService.stopPreviouslyStartedContainer(id, false, false);
                watcher.setContainerId(WatchService.this.runService.createAndStartContainer(imageConfig, mappedPorts, watcher.getWatchContext().getPomLabel(), watcher.getWatchContext().getMojoParameters().getProject().getProperties(), watcher.getWatchContext().getMojoParameters().getProject().getBasedir()));
            }
        };
    }

    private String getPreStopCommand(ImageConfiguration imageConfig) {
        if (imageConfig.getRunConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration().getExec() != null) {
            return imageConfig.getRunConfiguration().getWaitConfiguration().getExec().getPreStop();
        }
        return null;
    }

    private void callPostGoal(ImageWatcher watcher) throws MojoFailureException, MojoExecutionException {
        String postGoal = watcher.getPostGoal();
        if (postGoal != null) {
            this.mojoExecutionService.callPluginGoal(postGoal);
        }
    }

    public static class WatchContext
    implements Serializable {
        private MojoParameters mojoParameters;
        private WatchMode watchMode;
        private int watchInterval;
        private boolean keepRunning;
        private String watchPostGoal;
        private String watchPostExec;
        private PomLabel pomLabel;
        private boolean keepContainer;
        private boolean removeVolumes;
        private boolean autoCreateCustomNetworks;
        private Task<ImageConfiguration> imageCustomizer;
        private Task<ImageWatcher> containerRestarter;

        public MojoParameters getMojoParameters() {
            return this.mojoParameters;
        }

        public WatchMode getWatchMode() {
            return this.watchMode;
        }

        public int getWatchInterval() {
            return this.watchInterval;
        }

        public boolean isKeepRunning() {
            return this.keepRunning;
        }

        public String getWatchPostGoal() {
            return this.watchPostGoal;
        }

        public String getWatchPostExec() {
            return this.watchPostExec;
        }

        public PomLabel getPomLabel() {
            return this.pomLabel;
        }

        public boolean isKeepContainer() {
            return this.keepContainer;
        }

        public boolean isRemoveVolumes() {
            return this.removeVolumes;
        }

        public boolean isAutoCreateCustomNetworks() {
            return this.autoCreateCustomNetworks;
        }

        public Task<ImageConfiguration> getImageCustomizer() {
            return this.imageCustomizer;
        }

        public Task<ImageWatcher> getContainerRestarter() {
            return this.containerRestarter;
        }

        public static class Builder {
            private WatchContext context = new WatchContext();

            public Builder() {
                this.context = new WatchContext();
            }

            public Builder(WatchContext context) {
                this.context = context;
            }

            public Builder mojoParameters(MojoParameters mojoParameters) {
                this.context.mojoParameters = mojoParameters;
                return this;
            }

            public Builder watchMode(WatchMode watchMode) {
                this.context.watchMode = watchMode;
                return this;
            }

            public Builder watchInterval(int watchInterval) {
                this.context.watchInterval = watchInterval;
                return this;
            }

            public Builder keepRunning(boolean keepRunning) {
                this.context.keepRunning = keepRunning;
                return this;
            }

            public Builder watchPostGoal(String watchPostGoal) {
                this.context.watchPostGoal = watchPostGoal;
                return this;
            }

            public Builder watchPostExec(String watchPostExec) {
                this.context.watchPostExec = watchPostExec;
                return this;
            }

            public Builder pomLabel(PomLabel pomLabel) {
                this.context.pomLabel = pomLabel;
                return this;
            }

            public Builder keepContainer(boolean keepContainer) {
                this.context.keepContainer = keepContainer;
                return this;
            }

            public Builder removeVolumes(boolean removeVolumes) {
                this.context.removeVolumes = removeVolumes;
                return this;
            }

            public Builder imageCustomizer(Task<ImageConfiguration> imageCustomizer) {
                this.context.imageCustomizer = imageCustomizer;
                return this;
            }

            public Builder containerRestarter(Task<ImageWatcher> containerRestarter) {
                this.context.containerRestarter = containerRestarter;
                return this;
            }

            public Builder autoCreateCustomNetworks(boolean autoCreateCustomNetworks) {
                this.context.autoCreateCustomNetworks = autoCreateCustomNetworks;
                return this;
            }

            public WatchContext build() {
                return this.context;
            }
        }
    }

    public class ImageWatcher {
        private final ImageConfiguration imageConfig;
        private final WatchContext watchContext;
        private final WatchMode mode;
        private final AtomicReference<String> imageIdRef;
        private final AtomicReference<String> containerIdRef;
        private final long interval;
        private final String postGoal;
        private String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, WatchContext watchContext, String imageId, String containerIdRef) {
            this.imageConfig = imageConfig;
            this.watchContext = watchContext;
            this.imageIdRef = new AtomicReference<String>(imageId);
            this.containerIdRef = new AtomicReference<String>(containerIdRef);
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public String getContainerId() {
            return this.containerIdRef.get();
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public void setImageId(String imageId) {
            this.imageIdRef.set(imageId);
        }

        public void setContainerId(String containerId) {
            this.containerIdRef.set(containerId);
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getAndSetImageId(String currentImageId) {
            return this.imageIdRef.getAndSet(currentImageId);
        }

        public String getPostExec() {
            return this.postExec;
        }

        public WatchContext getWatchContext() {
            return this.watchContext;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int interval = watchConfig != null ? watchConfig.getInterval() : this.watchContext.getWatchInterval();
            return interval < 100 ? 100 : interval;
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : this.watchContext.getWatchPostExec();
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : this.watchContext.getWatchPostGoal();
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode mode = watchConfig != null ? watchConfig.getMode() : null;
            return mode != null ? mode : this.watchContext.getWatchMode();
        }
    }
}

