/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.compose;

import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandlerException;
import io.fabric8.maven.docker.config.handler.compose.DockerComposeConfiguration;
import io.fabric8.maven.docker.config.handler.compose.DockerComposeServiceWrapper;
import io.fabric8.maven.docker.util.DeepCopy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.yaml.snakeyaml.Yaml;

public class DockerComposeConfigHandler
implements ExternalConfigHandler {
    private MavenReaderFilter readerFilter;

    @Override
    public String getType() {
        return "compose";
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration unresolvedConfig, MavenProject project, MavenSession session) {
        ArrayList<ImageConfiguration> resolved = new ArrayList<ImageConfiguration>();
        DockerComposeConfiguration handlerConfig = new DockerComposeConfiguration(unresolvedConfig.getExternalConfig());
        File composeFile = this.resolveComposeFile(handlerConfig.getBasedir(), handlerConfig.getComposeFile(), project);
        for (Object composeO : this.getComposeConfigurations(composeFile, project, session)) {
            Map compose = (Map)composeO;
            this.validateVersion(compose, composeFile);
            Map services = (Map)compose.get("services");
            for (Map.Entry entry : services.entrySet()) {
                String serviceName = (String)entry.getKey();
                Map serviceDefinition = (Map)entry.getValue();
                DockerComposeServiceWrapper mapper = new DockerComposeServiceWrapper(serviceName, composeFile, serviceDefinition, unresolvedConfig);
                resolved.add(this.buildImageConfiguration(mapper, composeFile.getParentFile(), unresolvedConfig, handlerConfig));
            }
        }
        return resolved;
    }

    private void validateVersion(Map<String, Object> compose, File file) {
        Object version = compose.get("version");
        if (version == null || !version.toString().trim().equals("2")) {
            throw new ExternalConfigHandlerException("Only version 2 of the docker-compose format is supported for " + file);
        }
    }

    private String extractDockerFilePath(DockerComposeServiceWrapper mapper, File parentDir) {
        if (mapper.requiresBuild()) {
            File ret;
            File buildDir = new File(mapper.getBuildDir());
            String dockerFile = mapper.getDockerfile();
            if (dockerFile == null) {
                dockerFile = "Dockerfile";
            }
            return (ret = new File(buildDir, dockerFile)).isAbsolute() ? ret.getAbsolutePath() : new File(parentDir, ret.getPath()).getAbsolutePath();
        }
        return null;
    }

    private ImageConfiguration buildImageConfiguration(DockerComposeServiceWrapper mapper, File composeParent, ImageConfiguration unresolvedConfig, DockerComposeConfiguration handlerConfig) {
        ImageConfiguration.Builder builder = new ImageConfiguration.Builder().name(this.getImageName(mapper, unresolvedConfig)).alias(mapper.getAlias()).buildConfig(this.createBuildImageConfiguration(mapper, composeParent, unresolvedConfig, handlerConfig)).runConfig(this.createRunConfiguration(mapper, unresolvedConfig));
        if (this.serviceMatchesAlias(mapper, unresolvedConfig)) {
            builder.watchConfig(DeepCopy.copy(unresolvedConfig.getWatchConfiguration()));
        }
        return builder.build();
    }

    private String getImageName(DockerComposeServiceWrapper mapper, ImageConfiguration unresolvedConfig) {
        String name = mapper.getImage();
        if (name != null) {
            return name;
        }
        if (unresolvedConfig.getAlias() != null && unresolvedConfig.getAlias().equals(mapper.getAlias())) {
            return unresolvedConfig.getName();
        }
        return null;
    }

    private Iterable<Object> getComposeConfigurations(File composePath, MavenProject project, MavenSession session) {
        try {
            Yaml yaml = new Yaml();
            return yaml.loadAll(this.getFilteredReader(composePath, project, session));
        }
        catch (FileNotFoundException | MavenFilteringException e) {
            throw new ExternalConfigHandlerException("failed to load external configuration: " + composePath, e);
        }
    }

    private Reader getFilteredReader(File path, MavenProject project, MavenSession session) throws FileNotFoundException, MavenFilteringException {
        MavenReaderFilterRequest request = new MavenReaderFilterRequest((Reader)new FileReader(path), true, project, Collections.emptyList(), false, null, session, null);
        return this.readerFilter.filter(request);
    }

    private BuildImageConfiguration createBuildImageConfiguration(DockerComposeServiceWrapper mapper, File composeParent, ImageConfiguration imageConfig, DockerComposeConfiguration handlerConfig) {
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        if (handlerConfig.isIgnoreBuild() || !mapper.requiresBuild()) {
            if (this.serviceMatchesAlias(mapper, imageConfig)) {
                return buildConfig;
            }
            return null;
        }
        BuildImageConfiguration.Builder builder = new BuildImageConfiguration.Builder(buildConfig).dockerFile(this.extractDockerFilePath(mapper, composeParent)).args(mapper.getBuildArgs());
        return builder.build();
    }

    private boolean serviceMatchesAlias(DockerComposeServiceWrapper mapper, ImageConfiguration imageConfig) {
        return mapper.getAlias() != null && mapper.getAlias().equals(imageConfig.getAlias());
    }

    private RunImageConfiguration createRunConfiguration(DockerComposeServiceWrapper wrapper, ImageConfiguration imageConfig) {
        RunImageConfiguration.Builder builder = this.serviceMatchesAlias(wrapper, imageConfig) ? new RunImageConfiguration.Builder(imageConfig.getRunConfiguration()) : new RunImageConfiguration.Builder();
        return builder.capAdd(wrapper.getCapAdd()).capDrop(wrapper.getCapDrop()).cmd(wrapper.getCommand()).dependsOn(wrapper.getDependsOn()).dns(wrapper.getDns()).dnsSearch(wrapper.getDnsSearch()).tmpfs(wrapper.getTmpfs()).entrypoint(wrapper.getEntrypoint()).env(wrapper.getEnvironment()).extraHosts(wrapper.getExtraHosts()).labels(wrapper.getLabels()).links(wrapper.getLinks()).log(wrapper.getLogConfiguration()).network(wrapper.getNetworkConfig()).ports(wrapper.getPortMapping()).ulimits(wrapper.getUlimits()).volumes(wrapper.getVolumeConfig()).domainname(wrapper.getDomainname()).hostname(wrapper.getHostname()).memory(wrapper.getMemory()).memorySwap(wrapper.getMemorySwap()).privileged(wrapper.getPrivileged()).restartPolicy(wrapper.getRestartPolicy()).shmSize(wrapper.getShmSize()).user(wrapper.getUser()).workingDir(wrapper.getWorkingDir()).build();
    }

    private File resolveComposeFile(String baseDir, String compose, MavenProject project) {
        File yamlFile = new File(compose);
        return yamlFile.isAbsolute() ? yamlFile : new File(new File(project.getBasedir(), baseDir), compose);
    }
}

