/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remove", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class RemoveMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.removeAll", defaultValue="false")
    private boolean removeAll;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException {
        QueryService queryService = hub.getQueryService();
        for (ImageConfiguration image : this.getResolvedImages()) {
            String name = image.getName();
            if (!this.removeAll && !image.isDataImage() || !queryService.hasImage(name) || !hub.getDockerAccess().removeImage(name, true)) continue;
            this.log.info("%s: Remove", image.getDescription());
        }
    }
}

