/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.access.AuthConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.yaml.snakeyaml.Yaml;

public class AuthConfigFactory {
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_EMAIL = "email";
    private static final String AUTH_AUTHTOKEN = "authToken";
    private static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private final PlexusContainer container;
    public static final String[] DEFAULT_REGISTRIES = new String[]{"docker.io", "index.docker.io", "registry.hub.docker.com"};

    public AuthConfigFactory(PlexusContainer container) {
        this.container = container;
    }

    public AuthConfig createAuthConfig(boolean isPush, Map authConfigMap, Settings settings, String user, String registry) throws MojoExecutionException {
        AuthConfig ret;
        for (LookupMode lookupMode : new LookupMode[]{this.getLookupMode(isPush), LookupMode.DEFAULT}) {
            ret = this.getAuthConfigFromSystemProperties(lookupMode);
            if (ret != null) {
                return ret;
            }
            ret = this.getAuthConfigFromOpenShiftConfig(lookupMode, authConfigMap);
            if (ret != null) {
                return ret;
            }
            ret = this.getAuthConfigFromPluginConfiguration(lookupMode, authConfigMap);
            if (ret == null) continue;
            return ret;
        }
        ret = this.getAuthConfigFromSettings(settings, user, registry);
        if (ret != null) {
            return ret;
        }
        ret = this.getAuthConfigFromDockerConfig(registry);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private AuthConfig getAuthConfigFromSystemProperties(LookupMode lookupMode) throws MojoExecutionException {
        Properties props = System.getProperties();
        String userKey = lookupMode.asSysProperty(AUTH_USERNAME);
        String passwordKey = lookupMode.asSysProperty(AUTH_PASSWORD);
        if (props.containsKey(userKey)) {
            if (!props.containsKey(passwordKey)) {
                throw new MojoExecutionException("No " + passwordKey + " provided for username " + props.getProperty(userKey));
            }
            return new AuthConfig(props.getProperty(userKey), this.decrypt(props.getProperty(passwordKey)), props.getProperty(lookupMode.asSysProperty(AUTH_EMAIL)), props.getProperty(lookupMode.asSysProperty(AUTH_AUTHTOKEN)));
        }
        return null;
    }

    private AuthConfig getAuthConfigFromOpenShiftConfig(LookupMode lookupMode, Map authConfigMap) throws MojoExecutionException {
        String useOpenAuthModeProp;
        Properties props = System.getProperties();
        if (props.containsKey(useOpenAuthModeProp = lookupMode.asSysProperty(AUTH_USE_OPENSHIFT_AUTH))) {
            boolean useOpenShift = Boolean.valueOf(props.getProperty(useOpenAuthModeProp));
            if (useOpenShift) {
                AuthConfig ret = this.parseOpenShiftConfig();
                if (ret == null) {
                    throw new MojoExecutionException("System property " + useOpenAuthModeProp + " " + "set, but not active user and/or token found in ~/.config/kube. " + "Please use 'oc login' for connecting to OpenShift.");
                }
                return ret;
            }
            return null;
        }
        Map mapToCheck = this.getAuthConfigMapToCheck(lookupMode, authConfigMap);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USE_OPENSHIFT_AUTH) && Boolean.valueOf((String)mapToCheck.get(AUTH_USE_OPENSHIFT_AUTH)).booleanValue()) {
            AuthConfig ret = this.parseOpenShiftConfig();
            if (ret == null) {
                throw new MojoExecutionException("Authentication configured for OpenShift, but no active user and/or token found in ~/.config/kube. Please use 'oc login' for connecting to OpenShift.");
            }
            return ret;
        }
        return null;
    }

    private AuthConfig getAuthConfigFromPluginConfiguration(LookupMode lookupMode, Map authConfig) throws MojoExecutionException {
        Map mapToCheck = this.getAuthConfigMapToCheck(lookupMode, authConfig);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USERNAME)) {
            if (!mapToCheck.containsKey(AUTH_PASSWORD)) {
                throw new MojoExecutionException("No 'password' given while using <authConfig> in configuration for mode " + (Object)((Object)lookupMode));
            }
            HashMap<String, String> cloneConfig = new HashMap<String, String>(mapToCheck);
            cloneConfig.put(AUTH_PASSWORD, this.decrypt((String)cloneConfig.get(AUTH_PASSWORD)));
            return new AuthConfig(cloneConfig);
        }
        return null;
    }

    private AuthConfig getAuthConfigFromSettings(Settings settings, String user, String registry) throws MojoExecutionException {
        Server defaultServer = null;
        for (Server server : settings.getServers()) {
            Server found;
            String id = server.getId();
            if (defaultServer == null) {
                defaultServer = this.checkForServer(server, id, registry, null);
            }
            if ((found = this.checkForServer(server, id, registry, user)) == null) continue;
            return this.createAuthConfigFromServer(found);
        }
        return defaultServer != null ? this.createAuthConfigFromServer(defaultServer) : null;
    }

    private AuthConfig getAuthConfigFromDockerConfig(String registry) throws MojoExecutionException {
        String registryToLookup;
        JSONObject dockerConfig = this.readDockerConfig();
        if (dockerConfig == null || !dockerConfig.has("auths")) {
            return null;
        }
        JSONObject auths = dockerConfig.getJSONObject("auths");
        JSONObject credentials = this.getCredentialsNode(auths, registryToLookup = registry != null ? registry : DOCKER_LOGIN_DEFAULT_REGISTRY);
        if (credentials == null) {
            return null;
        }
        String auth = credentials.getString("auth");
        String email = credentials.has(AUTH_EMAIL) ? credentials.getString(AUTH_EMAIL) : null;
        return new AuthConfig(auth, email);
    }

    private JSONObject getCredentialsNode(JSONObject auths, String registryToLookup) {
        if (auths.has(registryToLookup)) {
            return auths.getJSONObject(registryToLookup);
        }
        String registryWithScheme = "https://" + registryToLookup;
        if (auths.has(registryWithScheme)) {
            return auths.getJSONObject(registryWithScheme);
        }
        return null;
    }

    private Map getAuthConfigMapToCheck(LookupMode lookupMode, Map authConfigMap) {
        String configMapKey = lookupMode.getConfigMapKey();
        if (configMapKey == null) {
            return authConfigMap;
        }
        if (authConfigMap != null) {
            return (Map)authConfigMap.get(configMapKey);
        }
        return null;
    }

    private AuthConfig parseOpenShiftConfig() {
        String currentContextName;
        Map<String, ?> kubeConfig = this.readKubeConfig();
        if (kubeConfig != null && (currentContextName = (String)kubeConfig.get("current-context")) != null) {
            for (Map contextMap : (List)kubeConfig.get("contexts")) {
                List users;
                String userName;
                Map context;
                if (!currentContextName.equals(contextMap.get("name")) || (context = (Map)contextMap.get("context")) == null || (userName = (String)context.get("user")) == null || (users = (List)kubeConfig.get("users")) == null) continue;
                for (Map userMap : users) {
                    String token;
                    Map user;
                    if (!userName.equals(userMap.get("name")) || (user = (Map)userMap.get("user")) == null || (token = (String)user.get("token")) == null) continue;
                    Matcher matcher = Pattern.compile("^([^/]+).*$").matcher(userName);
                    return new AuthConfig(matcher.matches() ? matcher.group(1) : userName, token, null, null);
                }
            }
        }
        return null;
    }

    private JSONObject readDockerConfig() {
        Reader reader = this.getFileReaderFromHomeDir(".docker/config.json");
        return reader != null ? new JSONObject(new JSONTokener(reader)) : null;
    }

    private Map<String, ?> readKubeConfig() {
        Reader reader = this.getFileReaderFromHomeDir(".kube/config");
        if (reader != null) {
            Yaml ret = new Yaml();
            return (Map)ret.load(reader);
        }
        return null;
    }

    private Reader getFileReaderFromHomeDir(String path) {
        File file = new File(this.getHomeDir(), path);
        if (file.exists()) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find " + file, e);
            }
        }
        return null;
    }

    private File getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            homeDir = System.getenv("HOME");
        }
        return new File(homeDir);
    }

    private Server checkForServer(Server server, String id, String registry, String user) {
        String[] registries;
        String[] stringArray;
        if (registry != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = registry;
        } else {
            stringArray = DEFAULT_REGISTRIES;
        }
        for (String reg : registries = stringArray) {
            if (!id.equals(user == null ? reg : reg + "/" + user)) continue;
            return server;
        }
        return null;
    }

    private String decrypt(String password) throws MojoExecutionException {
        try {
            Object secDispatcher = this.container.lookup(SecDispatcher.ROLE, "maven");
            Method method = secDispatcher.getClass().getMethod("decrypt", String.class);
            return (String)method.invoke(secDispatcher, password);
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Error looking security dispatcher", (Exception)((Object)e));
        }
        catch (ReflectiveOperationException e) {
            throw new MojoExecutionException("Cannot decrypt password: " + e.getCause(), (Exception)e);
        }
    }

    private AuthConfig createAuthConfigFromServer(Server server) throws MojoExecutionException {
        return new AuthConfig(server.getUsername(), this.decrypt(server.getPassword()), this.extractFromServerConfiguration(server.getConfiguration(), AUTH_EMAIL), this.extractFromServerConfiguration(server.getConfiguration(), "auth"));
    }

    private String extractFromServerConfiguration(Object configuration, String prop) {
        Xpp3Dom dom;
        Xpp3Dom element;
        if (configuration != null && (element = (dom = (Xpp3Dom)configuration).getChild(prop)) != null) {
            return element.getValue();
        }
        return null;
    }

    private LookupMode getLookupMode(boolean isPush) {
        return isPush ? LookupMode.PUSH : LookupMode.PULL;
    }

    private static enum LookupMode {
        PUSH("docker.push.", "push"),
        PULL("docker.pull.", "pull"),
        DEFAULT("docker.", null);

        private final String sysPropPrefix;
        private String configMapKey;

        private LookupMode(String sysPropPrefix, String configMapKey) {
            this.sysPropPrefix = sysPropPrefix;
            this.configMapKey = configMapKey;
        }

        public String asSysProperty(String prop) {
            return this.sysPropPrefix + prop;
        }

        public String getConfigMapKey() {
            return this.configMapKey;
        }
    }
}

