/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

public class NetworkingMode {
    private final Mode networkMode;
    private final String name;

    public NetworkingMode(String mode) {
        if (mode != null) {
            this.networkMode = Mode.extractMode(mode);
            this.name = this.networkMode == Mode.CONTAINER ? this.networkMode.extractContainerAlias(mode) : (this.networkMode == Mode.CUSTOM ? mode : null);
        } else {
            this.networkMode = null;
            this.name = null;
        }
    }

    public boolean isStandardMode() {
        return this.networkMode != null && this.networkMode.isStandard();
    }

    public boolean isCustomNetwork() {
        return this.networkMode == Mode.CUSTOM;
    }

    public String getContainerAlias() {
        return this.networkMode == Mode.CONTAINER ? this.name : null;
    }

    public String getCustomNetwork() {
        return this.networkMode == Mode.CUSTOM ? this.name : null;
    }

    public String getStandardMode(String containerId) {
        if (this.networkMode == Mode.CUSTOM) {
            throw new IllegalArgumentException("Custom network for network '" + this.name + "' can not be used as standard mode");
        }
        return this.networkMode.name().toLowerCase() + (this.networkMode == Mode.CONTAINER ? ":" + containerId : "");
    }

    private static enum Mode {
        NONE(true),
        BRIDGE(true),
        HOST(true),
        CONTAINER(true),
        CUSTOM(false);

        private final boolean isStandard;

        private Mode(boolean isStandard) {
            this.isStandard = isStandard;
        }

        public boolean isStandard() {
            return this.isStandard;
        }

        public static Mode extractMode(String mode) {
            if (mode != null && mode.length() > 0) {
                try {
                    return Mode.valueOf(mode.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (mode.toUpperCase().startsWith(CONTAINER.name() + ":")) {
                        return CONTAINER;
                    }
                    return CUSTOM;
                }
            }
            return null;
        }

        private String extractContainerAlias(String alias) {
            return alias.substring(this.name().length() + 1);
        }
    }
}

