/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.log;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.UrlBuilder;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.access.util.RequestUtil;
import io.fabric8.maven.docker.util.Timestamp;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public class LogRequestor
extends Thread
implements LogGetHandle {
    private static final Pattern LOG_LINE = Pattern.compile("^\\[?([^\\s\\]]*)]?\\s+(.*)\\s*$");
    private final HttpClient client;
    private final String containerId;
    private LogCallback callback;
    private DockerAccessException exception;
    private HttpUriRequest request;
    private final UrlBuilder urlBuilder;

    public LogRequestor(HttpClient client, UrlBuilder urlBuilder, String containerId, LogCallback callback) {
        this.client = client;
        this.containerId = containerId;
        this.urlBuilder = urlBuilder;
        this.callback = callback;
        this.exception = null;
        this.setDaemon(true);
    }

    public void fetchLogs() {
        try {
            HttpResponse resp = this.client.execute(this.getLogRequest(false));
            this.parseResponse(resp);
        }
        catch (IOException exp) {
            this.callback.error(exp.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            this.request = this.getLogRequest(true);
            HttpResponse response = this.client.execute(this.request);
            this.parseResponse(response);
        }
        catch (IOException exp) {
            this.callback.error("IO Error while requesting logs: " + exp);
        }
    }

    private void parseResponse(HttpResponse response) {
        try (InputStream is = response.getEntity().getContent();){
            byte[] headBuf = new byte[8];
            while (IOUtils.read((InputStream)is, (byte[])headBuf, (int)0, (int)8) > 0) {
                byte type = headBuf[0];
                int declaredLength = this.extractLength(headBuf);
                if (declaredLength == 0) continue;
                byte[] buf = new byte[declaredLength];
                int len = IOUtils.read((InputStream)is, (byte[])buf, (int)0, (int)declaredLength);
                if (len < 1) {
                    this.callback.error("Invalid log format: Couldn't read " + declaredLength + " bytes from stream");
                    this.finish();
                    return;
                }
                String txt = new String(buf, 0, len, "UTF-8");
                this.callLogCallback(type, txt);
            }
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                this.exception = new DockerAccessException("Error while reading logs (" + status + ")");
            }
        }
        catch (IOException e) {
            this.callback.error("Cannot process chunk response: " + e);
            this.finish();
        }
        catch (LogCallback.DoneException e) {
            this.finish();
        }
    }

    private void callLogCallback(int type, String txt) throws LogCallback.DoneException {
        Matcher matcher = LOG_LINE.matcher(txt);
        if (!matcher.matches()) {
            this.callback.error(String.format("Invalid log format for '%s' (expected: \"<timestamp> <txt>\") [%04x %04x]", txt, (int)txt.toCharArray()[0], (int)txt.toCharArray()[1]));
            throw new LogCallback.DoneException();
        }
        Timestamp ts = new Timestamp(matcher.group(1));
        String logTxt = matcher.group(2);
        this.callback.log(type, ts, logTxt);
    }

    private int extractLength(byte[] b) {
        return b[7] & 0xFF | (b[6] & 0xFF) << 8 | (b[5] & 0xFF) << 16 | (b[4] & 0xFF) << 24;
    }

    private HttpUriRequest getLogRequest(boolean follow) {
        return RequestUtil.newGet(this.urlBuilder.containerLogs(this.containerId, follow));
    }

    @Override
    public void finish() {
        if (this.request != null) {
            this.request.abort();
        }
    }

    @Override
    public boolean isError() {
        return this.exception != null;
    }

    @Override
    public DockerAccessException getException() {
        return this.exception;
    }
}

