/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc.unix;

import io.fabric8.maven.docker.access.hc.ClientBuilder;
import io.fabric8.maven.docker.access.hc.unix.UnixConnectionSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class UnixSocketClientBuilder
implements ClientBuilder {
    private final int maxConnections;
    private final Registry<ConnectionSocketFactory> registry;
    private final DnsResolver dnsResolver;

    public UnixSocketClientBuilder(String unixSocketPath, int maxConnections) {
        this.maxConnections = maxConnections;
        this.registry = this.buildRegistry(unixSocketPath);
        this.dnsResolver = this.nullDnsResolver();
    }

    @Override
    public CloseableHttpClient buildPooledClient() {
        HttpClientBuilder httpBuilder = HttpClients.custom();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(this.registry, this.dnsResolver);
        manager.setDefaultMaxPerRoute(this.maxConnections);
        httpBuilder.setConnectionManager((HttpClientConnectionManager)manager);
        return httpBuilder.build();
    }

    @Override
    public CloseableHttpClient buildBasicClient() throws IOException {
        BasicHttpClientConnectionManager manager = new BasicHttpClientConnectionManager(this.registry, null, null, this.dnsResolver);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    private Registry<ConnectionSocketFactory> buildRegistry(String path) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("unix", (Object)new UnixConnectionSocketFactory(path));
        return registryBuilder.build();
    }

    private DnsResolver nullDnsResolver() {
        return new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                return new InetAddress[]{null};
            }
        };
    }
}

