package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.ElectionGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: election.proto")
public final class VertxElectionGrpc {
    private VertxElectionGrpc() {}

    public static ElectionVertxStub newVertxStub(io.grpc.Channel channel) {
        return new ElectionVertxStub(channel);
    }

    /**
     * <pre>
     *  The election service exposes client-side election facilities as a gRPC interface.
     * </pre>
     */
    public static final class ElectionVertxStub extends io.grpc.stub.AbstractStub<ElectionVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private ElectionGrpc.ElectionStub delegateStub;

        private ElectionVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = ElectionGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private ElectionVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ElectionGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected ElectionVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new ElectionVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Campaign waits to acquire leadership in an election, returning a LeaderKey
         *  representing the leadership if successful. The LeaderKey can then be used
         *  to issue new values on the election, transactionally guard API requests on
         *  leadership still being held, and resign from the election.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.CampaignResponse> campaign(io.etcd.jetcd.api.CampaignRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::campaign);
        }

        /**
         * <pre>
         *  Proclaim updates the leader&#39;s posted value with a new value.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.ProclaimResponse> proclaim(io.etcd.jetcd.api.ProclaimRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::proclaim);
        }

        /**
         * <pre>
         *  Leader returns the current election proclamation, if any.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaderResponse> leader(io.etcd.jetcd.api.LeaderRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leader);
        }

        /**
         * <pre>
         *  Resign releases election leadership so other campaigners may acquire
         *  leadership on the election.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.ResignResponse> resign(io.etcd.jetcd.api.ResignRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::resign);
        }

        /**
         * <pre>
         *  Observe streams election proclamations in-order as made by the election&#39;s
         *  elected leaders.
         * </pre>
         */
        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.LeaderResponse> observe(io.etcd.jetcd.api.LeaderRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::observe);
        }

        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.LeaderResponse> observeWithHandler(io.etcd.jetcd.api.LeaderRequest request, io.vertx.core.Handler<io.etcd.jetcd.api.LeaderResponse> handler, io.vertx.core.Handler<java.lang.Void> endHandler, io.vertx.core.Handler<java.lang.Throwable> exceptionHandler) {
            return io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::observe, handler, endHandler, exceptionHandler);
        }

    }

    /**
     * <pre>
     *  The election service exposes client-side election facilities as a gRPC interface.
     * </pre>
     */
    public static abstract class ElectionVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public ElectionVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Campaign waits to acquire leadership in an election, returning a LeaderKey
         *  representing the leadership if successful. The LeaderKey can then be used
         *  to issue new values on the election, transactionally guard API requests on
         *  leadership still being held, and resign from the election.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.CampaignResponse> campaign(io.etcd.jetcd.api.CampaignRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Proclaim updates the leader&#39;s posted value with a new value.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.ProclaimResponse> proclaim(io.etcd.jetcd.api.ProclaimRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Leader returns the current election proclamation, if any.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaderResponse> leader(io.etcd.jetcd.api.LeaderRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Resign releases election leadership so other campaigners may acquire
         *  leadership on the election.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.ResignResponse> resign(io.etcd.jetcd.api.ResignRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Observe streams election proclamations in-order as made by the election&#39;s
         *  elected leaders.
         * </pre>
         */
        public void observe(io.etcd.jetcd.api.LeaderRequest request, io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.LeaderResponse> response) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.ElectionGrpc.getCampaignMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.CampaignRequest,
                                            io.etcd.jetcd.api.CampaignResponse>(
                                            this, METHODID_CAMPAIGN, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ElectionGrpc.getProclaimMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.ProclaimRequest,
                                            io.etcd.jetcd.api.ProclaimResponse>(
                                            this, METHODID_PROCLAIM, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ElectionGrpc.getLeaderMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaderRequest,
                                            io.etcd.jetcd.api.LeaderResponse>(
                                            this, METHODID_LEADER, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ElectionGrpc.getObserveMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaderRequest,
                                            io.etcd.jetcd.api.LeaderResponse>(
                                            this, METHODID_OBSERVE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.ElectionGrpc.getResignMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.ResignRequest,
                                            io.etcd.jetcd.api.ResignResponse>(
                                            this, METHODID_RESIGN, compression)))
                    .build();
        }
    }

    private static final int METHODID_CAMPAIGN = 0;
    private static final int METHODID_PROCLAIM = 1;
    private static final int METHODID_LEADER = 2;
    private static final int METHODID_OBSERVE = 3;
    private static final int METHODID_RESIGN = 4;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final ElectionVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ElectionVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_CAMPAIGN:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.CampaignRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.CampaignResponse>) responseObserver,
                            compression,
                            serviceImpl::campaign);
                    break;
                case METHODID_PROCLAIM:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.ProclaimRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ProclaimResponse>) responseObserver,
                            compression,
                            serviceImpl::proclaim);
                    break;
                case METHODID_LEADER:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.LeaderRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse>) responseObserver,
                            compression,
                            serviceImpl::leader);
                    break;
                case METHODID_OBSERVE:
                    io.vertx.grpc.stub.ServerCalls.oneToMany(
                            (io.etcd.jetcd.api.LeaderRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaderResponse>) responseObserver,
                            compression,
                            serviceImpl::observe);
                    break;
                case METHODID_RESIGN:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.ResignRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.ResignResponse>) responseObserver,
                            compression,
                            serviceImpl::resign);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
