package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.KVGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxKVGrpc {
    private VertxKVGrpc() {}

    public static KVVertxStub newVertxStub(io.grpc.Channel channel) {
        return new KVVertxStub(channel);
    }

    
    public static final class KVVertxStub extends io.grpc.stub.AbstractStub<KVVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private KVGrpc.KVStub delegateStub;

        private KVVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = KVGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private KVVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = KVGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected KVVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new KVVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.RangeResponse> range(io.etcd.jetcd.api.RangeRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::range);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.PutResponse> put(io.etcd.jetcd.api.PutRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::put);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.DeleteRangeResponse> deleteRange(io.etcd.jetcd.api.DeleteRangeRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::deleteRange);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.TxnResponse> txn(io.etcd.jetcd.api.TxnRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::txn);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.CompactionResponse> compact(io.etcd.jetcd.api.CompactionRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::compact);
        }

    }

    
    public static abstract class KVVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public KVVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.RangeResponse> range(io.etcd.jetcd.api.RangeRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.PutResponse> put(io.etcd.jetcd.api.PutRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.DeleteRangeResponse> deleteRange(io.etcd.jetcd.api.DeleteRangeRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every completed request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.TxnResponse> txn(io.etcd.jetcd.api.TxnRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.CompactionResponse> compact(io.etcd.jetcd.api.CompactionRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.KVGrpc.getRangeMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.RangeRequest,
                                            io.etcd.jetcd.api.RangeResponse>(
                                            this, METHODID_RANGE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.KVGrpc.getPutMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.PutRequest,
                                            io.etcd.jetcd.api.PutResponse>(
                                            this, METHODID_PUT, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.KVGrpc.getDeleteRangeMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.DeleteRangeRequest,
                                            io.etcd.jetcd.api.DeleteRangeResponse>(
                                            this, METHODID_DELETE_RANGE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.KVGrpc.getTxnMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.TxnRequest,
                                            io.etcd.jetcd.api.TxnResponse>(
                                            this, METHODID_TXN, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.KVGrpc.getCompactMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.CompactionRequest,
                                            io.etcd.jetcd.api.CompactionResponse>(
                                            this, METHODID_COMPACT, compression)))
                    .build();
        }
    }

    private static final int METHODID_RANGE = 0;
    private static final int METHODID_PUT = 1;
    private static final int METHODID_DELETE_RANGE = 2;
    private static final int METHODID_TXN = 3;
    private static final int METHODID_COMPACT = 4;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final KVVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(KVVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_RANGE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.RangeRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.RangeResponse>) responseObserver,
                            compression,
                            serviceImpl::range);
                    break;
                case METHODID_PUT:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.PutRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.PutResponse>) responseObserver,
                            compression,
                            serviceImpl::put);
                    break;
                case METHODID_DELETE_RANGE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.DeleteRangeRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.DeleteRangeResponse>) responseObserver,
                            compression,
                            serviceImpl::deleteRange);
                    break;
                case METHODID_TXN:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.TxnRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.TxnResponse>) responseObserver,
                            compression,
                            serviceImpl::txn);
                    break;
                case METHODID_COMPACT:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.CompactionRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.CompactionResponse>) responseObserver,
                            compression,
                            serviceImpl::compact);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
