/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.api.Compare;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.support.Util;

public class Cmp {
    private final ByteString key;
    private final Op op;
    private final CmpTarget<?> target;

    public Cmp(ByteSequence key, Op compareOp, CmpTarget<?> target) {
        this.key = ByteString.copyFrom((byte[])key.getBytes());
        this.op = compareOp;
        this.target = target;
    }

    Compare toCompare(ByteSequence namespace) {
        Compare.Builder compareBuilder = Compare.newBuilder().setKey(Util.prefixNamespace(this.key, namespace));
        switch (this.op) {
            case EQUAL: {
                compareBuilder.setResult(Compare.CompareResult.EQUAL);
                break;
            }
            case GREATER: {
                compareBuilder.setResult(Compare.CompareResult.GREATER);
                break;
            }
            case LESS: {
                compareBuilder.setResult(Compare.CompareResult.LESS);
                break;
            }
            case NOT_EQUAL: {
                compareBuilder.setResult(Compare.CompareResult.NOT_EQUAL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compare type (" + String.valueOf((Object)this.op) + ")");
            }
        }
        Compare.CompareTarget target = this.target.getTarget();
        Object value = this.target.getTargetValue();
        compareBuilder.setTarget(target);
        switch (target) {
            case VERSION: {
                compareBuilder.setVersion(((Long)value).longValue());
                break;
            }
            case VALUE: {
                compareBuilder.setValue((ByteString)value);
                break;
            }
            case MOD: {
                compareBuilder.setModRevision(((Long)value).longValue());
                break;
            }
            case CREATE: {
                compareBuilder.setCreateRevision(((Long)value).longValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected target type (" + String.valueOf(target) + ")");
            }
        }
        return compareBuilder.build();
    }

    public static enum Op {
        EQUAL,
        GREATER,
        LESS,
        NOT_EQUAL;

    }
}

