/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe.internal;

import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.CircuitStats;
import java.time.Duration;
import java.util.Arrays;

class TimedCircuitStats
implements CircuitStats {
    static final int DEFAULT_BUCKET_COUNT = 10;
    private final Clock clock;
    private final long bucketSizeMillis;
    private final long windowSizeMillis;
    final Bucket[] buckets;
    private final Stat summary;
    volatile int currentIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedCircuitStats(int bucketCount, Duration thresholdingPeriod, Clock clock, CircuitStats oldStats) {
        this.clock = clock;
        this.buckets = new Bucket[bucketCount];
        this.bucketSizeMillis = thresholdingPeriod.toMillis() / (long)this.buckets.length;
        this.windowSizeMillis = this.bucketSizeMillis * (long)this.buckets.length;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.summary = new Stat();
        if (oldStats == null) {
            this.buckets[0].startTimeMillis = clock.currentTimeMillis();
        } else {
            CircuitStats circuitStats = oldStats;
            synchronized (circuitStats) {
                this.copyStats(oldStats);
            }
        }
    }

    void copyStats(CircuitStats oldStats) {
        if (oldStats instanceof TimedCircuitStats) {
            int i;
            TimedCircuitStats old = (TimedCircuitStats)oldStats;
            int bucketsToCopy = Math.min(old.buckets.length, this.buckets.length);
            int oldIndex = old.indexAfter(old.currentIndex);
            for (i = 0; i < bucketsToCopy; ++i) {
                oldIndex = old.indexBefore(oldIndex);
            }
            for (i = 0; i < bucketsToCopy; ++i) {
                if (i != 0) {
                    oldIndex = old.indexAfter(oldIndex);
                    this.currentIndex = this.nextIndex();
                }
                this.buckets[this.currentIndex].copyFrom(old.buckets[oldIndex]);
                this.summary.add(this.buckets[this.currentIndex]);
            }
        } else {
            this.buckets[0].startTimeMillis = this.clock.currentTimeMillis();
            this.copyExecutions(oldStats);
        }
    }

    @Override
    public synchronized void recordSuccess() {
        ++this.getCurrentBucket().successes;
        ++this.summary.successes;
    }

    @Override
    public synchronized void recordFailure() {
        ++this.getCurrentBucket().failures;
        ++this.summary.failures;
    }

    @Override
    public int getExecutionCount() {
        return this.summary.successes + this.summary.failures;
    }

    @Override
    public int getFailureCount() {
        return this.summary.failures;
    }

    @Override
    public synchronized int getFailureRate() {
        int executions = this.getExecutionCount();
        return (int)Math.round(executions == 0 ? 0.0 : (double)this.summary.failures / (double)executions * 100.0);
    }

    @Override
    public int getSuccessCount() {
        return this.summary.successes;
    }

    @Override
    public synchronized int getSuccessRate() {
        int executions = this.getExecutionCount();
        return (int)Math.round(executions == 0 ? 0.0 : (double)this.summary.successes / (double)executions * 100.0);
    }

    synchronized Bucket getCurrentBucket() {
        Bucket currentBucket = this.buckets[this.currentIndex];
        long currentTime = this.clock.currentTimeMillis();
        long timeDiff = currentTime - currentBucket.startTimeMillis;
        if (timeDiff >= this.bucketSizeMillis) {
            int bucketsToMove = (int)(timeDiff / this.bucketSizeMillis);
            if (bucketsToMove <= this.buckets.length) {
                do {
                    this.currentIndex = this.nextIndex();
                    Bucket previousBucket = currentBucket;
                    currentBucket = this.buckets[this.currentIndex];
                    long bucketStartTime = currentBucket.startTimeMillis == -1L ? previousBucket.startTimeMillis + this.bucketSizeMillis : currentBucket.startTimeMillis + this.windowSizeMillis;
                    this.summary.remove(currentBucket);
                    currentBucket.reset(bucketStartTime);
                } while (--bucketsToMove > 0);
            } else {
                long startTimeMillis = currentTime;
                for (Bucket bucket : this.buckets) {
                    bucket.reset(startTimeMillis);
                    startTimeMillis += this.bucketSizeMillis;
                }
                this.summary.reset();
                this.currentIndex = 0;
            }
        }
        return currentBucket;
    }

    private int nextIndex() {
        return (this.currentIndex + 1) % this.buckets.length;
    }

    private int indexAfter(int index) {
        return index == this.buckets.length - 1 ? 0 : index + 1;
    }

    private int indexBefore(int index) {
        return index == 0 ? this.buckets.length - 1 : index - 1;
    }

    public String toString() {
        return "TimedCircuitStats[summary=" + this.summary + ", buckets=" + Arrays.toString(this.buckets) + ']';
    }

    static class Bucket
    extends Stat {
        long startTimeMillis = -1L;

        Bucket() {
        }

        void reset(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.reset();
        }

        void copyFrom(Bucket other) {
            this.startTimeMillis = other.startTimeMillis;
            this.successes = other.successes;
            this.failures = other.failures;
        }

        @Override
        public String toString() {
            return "[startTime=" + this.startTimeMillis + ", s=" + this.successes + ", f=" + this.failures + ']';
        }
    }

    static class Stat {
        int successes;
        int failures;

        Stat() {
        }

        void reset() {
            this.successes = 0;
            this.failures = 0;
        }

        void add(Bucket bucket) {
            this.successes += bucket.successes;
            this.failures += bucket.failures;
        }

        void remove(Bucket bucket) {
            this.successes -= bucket.successes;
            this.failures -= bucket.failures;
        }

        public String toString() {
            return "[s=" + this.successes + ", f=" + this.failures + ']';
        }
    }

    static class Clock {
        Clock() {
        }

        long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

