/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoy.extensions.filters.http.oauth2.v3;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BoolValueOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.envoyproxy.envoy.config.core.v3.HttpUri;
import io.envoyproxy.envoy.config.core.v3.HttpUriOrBuilder;
import io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.envoyproxy.envoy.config.route.v3.HeaderMatcherOrBuilder;
import io.envoyproxy.envoy.extensions.filters.http.oauth2.v3.OAuth2ConfigOrBuilder;
import io.envoyproxy.envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials;
import io.envoyproxy.envoy.extensions.filters.http.oauth2.v3.OAuth2CredentialsOrBuilder;
import io.envoyproxy.envoy.extensions.filters.http.oauth2.v3.OauthProto;
import io.envoyproxy.envoy.type.matcher.v3.PathMatcher;
import io.envoyproxy.envoy.type.matcher.v3.PathMatcherOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class OAuth2Config
extends GeneratedMessageV3
implements OAuth2ConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int TOKEN_ENDPOINT_FIELD_NUMBER = 1;
    private HttpUri tokenEndpoint_;
    public static final int AUTHORIZATION_ENDPOINT_FIELD_NUMBER = 2;
    private volatile Object authorizationEndpoint_ = "";
    public static final int CREDENTIALS_FIELD_NUMBER = 3;
    private OAuth2Credentials credentials_;
    public static final int REDIRECT_URI_FIELD_NUMBER = 4;
    private volatile Object redirectUri_ = "";
    public static final int REDIRECT_PATH_MATCHER_FIELD_NUMBER = 5;
    private PathMatcher redirectPathMatcher_;
    public static final int SIGNOUT_PATH_FIELD_NUMBER = 6;
    private PathMatcher signoutPath_;
    public static final int FORWARD_BEARER_TOKEN_FIELD_NUMBER = 7;
    private boolean forwardBearerToken_ = false;
    public static final int PASS_THROUGH_MATCHER_FIELD_NUMBER = 8;
    private List<HeaderMatcher> passThroughMatcher_;
    public static final int AUTH_SCOPES_FIELD_NUMBER = 9;
    private LazyStringArrayList authScopes_ = LazyStringArrayList.emptyList();
    public static final int RESOURCES_FIELD_NUMBER = 10;
    private LazyStringArrayList resources_ = LazyStringArrayList.emptyList();
    public static final int AUTH_TYPE_FIELD_NUMBER = 11;
    private int authType_ = 0;
    public static final int USE_REFRESH_TOKEN_FIELD_NUMBER = 12;
    private BoolValue useRefreshToken_;
    public static final int DEFAULT_EXPIRES_IN_FIELD_NUMBER = 13;
    private Duration defaultExpiresIn_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final OAuth2Config DEFAULT_INSTANCE = new OAuth2Config();
    private static final Parser<OAuth2Config> PARSER = new AbstractParser<OAuth2Config>(){

        public OAuth2Config parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = OAuth2Config.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private OAuth2Config(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private OAuth2Config() {
        this.authorizationEndpoint_ = "";
        this.redirectUri_ = "";
        this.passThroughMatcher_ = Collections.emptyList();
        this.authScopes_ = LazyStringArrayList.emptyList();
        this.resources_ = LazyStringArrayList.emptyList();
        this.authType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new OAuth2Config();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return OauthProto.internal_static_envoy_extensions_filters_http_oauth2_v3_OAuth2Config_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return OauthProto.internal_static_envoy_extensions_filters_http_oauth2_v3_OAuth2Config_fieldAccessorTable.ensureFieldAccessorsInitialized(OAuth2Config.class, Builder.class);
    }

    @Override
    public boolean hasTokenEndpoint() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public HttpUri getTokenEndpoint() {
        return this.tokenEndpoint_ == null ? HttpUri.getDefaultInstance() : this.tokenEndpoint_;
    }

    @Override
    public HttpUriOrBuilder getTokenEndpointOrBuilder() {
        return this.tokenEndpoint_ == null ? HttpUri.getDefaultInstance() : this.tokenEndpoint_;
    }

    @Override
    public String getAuthorizationEndpoint() {
        Object ref = this.authorizationEndpoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.authorizationEndpoint_ = s;
        return s;
    }

    @Override
    public ByteString getAuthorizationEndpointBytes() {
        Object ref = this.authorizationEndpoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.authorizationEndpoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCredentials() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public OAuth2Credentials getCredentials() {
        return this.credentials_ == null ? OAuth2Credentials.getDefaultInstance() : this.credentials_;
    }

    @Override
    public OAuth2CredentialsOrBuilder getCredentialsOrBuilder() {
        return this.credentials_ == null ? OAuth2Credentials.getDefaultInstance() : this.credentials_;
    }

    @Override
    public String getRedirectUri() {
        Object ref = this.redirectUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.redirectUri_ = s;
        return s;
    }

    @Override
    public ByteString getRedirectUriBytes() {
        Object ref = this.redirectUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.redirectUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasRedirectPathMatcher() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public PathMatcher getRedirectPathMatcher() {
        return this.redirectPathMatcher_ == null ? PathMatcher.getDefaultInstance() : this.redirectPathMatcher_;
    }

    @Override
    public PathMatcherOrBuilder getRedirectPathMatcherOrBuilder() {
        return this.redirectPathMatcher_ == null ? PathMatcher.getDefaultInstance() : this.redirectPathMatcher_;
    }

    @Override
    public boolean hasSignoutPath() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public PathMatcher getSignoutPath() {
        return this.signoutPath_ == null ? PathMatcher.getDefaultInstance() : this.signoutPath_;
    }

    @Override
    public PathMatcherOrBuilder getSignoutPathOrBuilder() {
        return this.signoutPath_ == null ? PathMatcher.getDefaultInstance() : this.signoutPath_;
    }

    @Override
    public boolean getForwardBearerToken() {
        return this.forwardBearerToken_;
    }

    @Override
    public List<HeaderMatcher> getPassThroughMatcherList() {
        return this.passThroughMatcher_;
    }

    @Override
    public List<? extends HeaderMatcherOrBuilder> getPassThroughMatcherOrBuilderList() {
        return this.passThroughMatcher_;
    }

    @Override
    public int getPassThroughMatcherCount() {
        return this.passThroughMatcher_.size();
    }

    @Override
    public HeaderMatcher getPassThroughMatcher(int index) {
        return this.passThroughMatcher_.get(index);
    }

    @Override
    public HeaderMatcherOrBuilder getPassThroughMatcherOrBuilder(int index) {
        return this.passThroughMatcher_.get(index);
    }

    public ProtocolStringList getAuthScopesList() {
        return this.authScopes_;
    }

    @Override
    public int getAuthScopesCount() {
        return this.authScopes_.size();
    }

    @Override
    public String getAuthScopes(int index) {
        return this.authScopes_.get(index);
    }

    @Override
    public ByteString getAuthScopesBytes(int index) {
        return this.authScopes_.getByteString(index);
    }

    public ProtocolStringList getResourcesList() {
        return this.resources_;
    }

    @Override
    public int getResourcesCount() {
        return this.resources_.size();
    }

    @Override
    public String getResources(int index) {
        return this.resources_.get(index);
    }

    @Override
    public ByteString getResourcesBytes(int index) {
        return this.resources_.getByteString(index);
    }

    @Override
    public int getAuthTypeValue() {
        return this.authType_;
    }

    @Override
    public AuthType getAuthType() {
        AuthType result = AuthType.forNumber(this.authType_);
        return result == null ? AuthType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasUseRefreshToken() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public BoolValue getUseRefreshToken() {
        return this.useRefreshToken_ == null ? BoolValue.getDefaultInstance() : this.useRefreshToken_;
    }

    @Override
    public BoolValueOrBuilder getUseRefreshTokenOrBuilder() {
        return this.useRefreshToken_ == null ? BoolValue.getDefaultInstance() : this.useRefreshToken_;
    }

    @Override
    public boolean hasDefaultExpiresIn() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public Duration getDefaultExpiresIn() {
        return this.defaultExpiresIn_ == null ? Duration.getDefaultInstance() : this.defaultExpiresIn_;
    }

    @Override
    public DurationOrBuilder getDefaultExpiresInOrBuilder() {
        return this.defaultExpiresIn_ == null ? Duration.getDefaultInstance() : this.defaultExpiresIn_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getTokenEndpoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authorizationEndpoint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.authorizationEndpoint_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(3, (MessageLite)this.getCredentials());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.redirectUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.redirectUri_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getRedirectPathMatcher());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(6, (MessageLite)this.getSignoutPath());
        }
        if (this.forwardBearerToken_) {
            output.writeBool(7, this.forwardBearerToken_);
        }
        for (i = 0; i < this.passThroughMatcher_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.passThroughMatcher_.get(i));
        }
        for (i = 0; i < this.authScopes_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.authScopes_.getRaw(i));
        }
        for (i = 0; i < this.resources_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.resources_.getRaw(i));
        }
        if (this.authType_ != AuthType.URL_ENCODED_BODY.getNumber()) {
            output.writeEnum(11, this.authType_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(12, (MessageLite)this.getUseRefreshToken());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(13, (MessageLite)this.getDefaultExpiresIn());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getTokenEndpoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authorizationEndpoint_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.authorizationEndpoint_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCredentials());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.redirectUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.redirectUri_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getRedirectPathMatcher());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getSignoutPath());
        }
        if (this.forwardBearerToken_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.forwardBearerToken_);
        }
        for (int i2 = 0; i2 < this.passThroughMatcher_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.passThroughMatcher_.get(i2)));
        }
        int dataSize = 0;
        for (i = 0; i < this.authScopes_.size(); ++i) {
            dataSize += OAuth2Config.computeStringSizeNoTag((Object)this.authScopes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getAuthScopesList().size();
        dataSize = 0;
        for (i = 0; i < this.resources_.size(); ++i) {
            dataSize += OAuth2Config.computeStringSizeNoTag((Object)this.resources_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getResourcesList().size();
        if (this.authType_ != AuthType.URL_ENCODED_BODY.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.authType_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getUseRefreshToken());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getDefaultExpiresIn());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OAuth2Config)) {
            return super.equals(obj);
        }
        OAuth2Config other = (OAuth2Config)obj;
        if (this.hasTokenEndpoint() != other.hasTokenEndpoint()) {
            return false;
        }
        if (this.hasTokenEndpoint() && !this.getTokenEndpoint().equals(other.getTokenEndpoint())) {
            return false;
        }
        if (!this.getAuthorizationEndpoint().equals(other.getAuthorizationEndpoint())) {
            return false;
        }
        if (this.hasCredentials() != other.hasCredentials()) {
            return false;
        }
        if (this.hasCredentials() && !this.getCredentials().equals(other.getCredentials())) {
            return false;
        }
        if (!this.getRedirectUri().equals(other.getRedirectUri())) {
            return false;
        }
        if (this.hasRedirectPathMatcher() != other.hasRedirectPathMatcher()) {
            return false;
        }
        if (this.hasRedirectPathMatcher() && !this.getRedirectPathMatcher().equals(other.getRedirectPathMatcher())) {
            return false;
        }
        if (this.hasSignoutPath() != other.hasSignoutPath()) {
            return false;
        }
        if (this.hasSignoutPath() && !this.getSignoutPath().equals(other.getSignoutPath())) {
            return false;
        }
        if (this.getForwardBearerToken() != other.getForwardBearerToken()) {
            return false;
        }
        if (!this.getPassThroughMatcherList().equals(other.getPassThroughMatcherList())) {
            return false;
        }
        if (!this.getAuthScopesList().equals(other.getAuthScopesList())) {
            return false;
        }
        if (!this.getResourcesList().equals(other.getResourcesList())) {
            return false;
        }
        if (this.authType_ != other.authType_) {
            return false;
        }
        if (this.hasUseRefreshToken() != other.hasUseRefreshToken()) {
            return false;
        }
        if (this.hasUseRefreshToken() && !this.getUseRefreshToken().equals((Object)other.getUseRefreshToken())) {
            return false;
        }
        if (this.hasDefaultExpiresIn() != other.hasDefaultExpiresIn()) {
            return false;
        }
        if (this.hasDefaultExpiresIn() && !this.getDefaultExpiresIn().equals((Object)other.getDefaultExpiresIn())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + OAuth2Config.getDescriptor().hashCode();
        if (this.hasTokenEndpoint()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTokenEndpoint().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAuthorizationEndpoint().hashCode();
        if (this.hasCredentials()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCredentials().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getRedirectUri().hashCode();
        if (this.hasRedirectPathMatcher()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getRedirectPathMatcher().hashCode();
        }
        if (this.hasSignoutPath()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getSignoutPath().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getForwardBearerToken());
        if (this.getPassThroughMatcherCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getPassThroughMatcherList().hashCode();
        }
        if (this.getAuthScopesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAuthScopesList().hashCode();
        }
        if (this.getResourcesCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getResourcesList().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.authType_;
        if (this.hasUseRefreshToken()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getUseRefreshToken().hashCode();
        }
        if (this.hasDefaultExpiresIn()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getDefaultExpiresIn().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static OAuth2Config parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data);
    }

    public static OAuth2Config parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OAuth2Config parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data);
    }

    public static OAuth2Config parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OAuth2Config parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data);
    }

    public static OAuth2Config parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OAuth2Config)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OAuth2Config parseFrom(InputStream input) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static OAuth2Config parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OAuth2Config parseDelimitedFrom(InputStream input) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static OAuth2Config parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OAuth2Config parseFrom(CodedInputStream input) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static OAuth2Config parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OAuth2Config)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return OAuth2Config.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OAuth2Config prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static OAuth2Config getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OAuth2Config> parser() {
        return PARSER;
    }

    public Parser<OAuth2Config> getParserForType() {
        return PARSER;
    }

    public OAuth2Config getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements OAuth2ConfigOrBuilder {
        private int bitField0_;
        private HttpUri tokenEndpoint_;
        private SingleFieldBuilderV3<HttpUri, HttpUri.Builder, HttpUriOrBuilder> tokenEndpointBuilder_;
        private Object authorizationEndpoint_ = "";
        private OAuth2Credentials credentials_;
        private SingleFieldBuilderV3<OAuth2Credentials, OAuth2Credentials.Builder, OAuth2CredentialsOrBuilder> credentialsBuilder_;
        private Object redirectUri_ = "";
        private PathMatcher redirectPathMatcher_;
        private SingleFieldBuilderV3<PathMatcher, PathMatcher.Builder, PathMatcherOrBuilder> redirectPathMatcherBuilder_;
        private PathMatcher signoutPath_;
        private SingleFieldBuilderV3<PathMatcher, PathMatcher.Builder, PathMatcherOrBuilder> signoutPathBuilder_;
        private boolean forwardBearerToken_;
        private List<HeaderMatcher> passThroughMatcher_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<HeaderMatcher, HeaderMatcher.Builder, HeaderMatcherOrBuilder> passThroughMatcherBuilder_;
        private LazyStringArrayList authScopes_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList resources_ = LazyStringArrayList.emptyList();
        private int authType_ = 0;
        private BoolValue useRefreshToken_;
        private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> useRefreshTokenBuilder_;
        private Duration defaultExpiresIn_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> defaultExpiresInBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return OauthProto.internal_static_envoy_extensions_filters_http_oauth2_v3_OAuth2Config_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OauthProto.internal_static_envoy_extensions_filters_http_oauth2_v3_OAuth2Config_fieldAccessorTable.ensureFieldAccessorsInitialized(OAuth2Config.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getTokenEndpointFieldBuilder();
                this.getCredentialsFieldBuilder();
                this.getRedirectPathMatcherFieldBuilder();
                this.getSignoutPathFieldBuilder();
                this.getPassThroughMatcherFieldBuilder();
                this.getUseRefreshTokenFieldBuilder();
                this.getDefaultExpiresInFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.tokenEndpoint_ = null;
            if (this.tokenEndpointBuilder_ != null) {
                this.tokenEndpointBuilder_.dispose();
                this.tokenEndpointBuilder_ = null;
            }
            this.authorizationEndpoint_ = "";
            this.credentials_ = null;
            if (this.credentialsBuilder_ != null) {
                this.credentialsBuilder_.dispose();
                this.credentialsBuilder_ = null;
            }
            this.redirectUri_ = "";
            this.redirectPathMatcher_ = null;
            if (this.redirectPathMatcherBuilder_ != null) {
                this.redirectPathMatcherBuilder_.dispose();
                this.redirectPathMatcherBuilder_ = null;
            }
            this.signoutPath_ = null;
            if (this.signoutPathBuilder_ != null) {
                this.signoutPathBuilder_.dispose();
                this.signoutPathBuilder_ = null;
            }
            this.forwardBearerToken_ = false;
            if (this.passThroughMatcherBuilder_ == null) {
                this.passThroughMatcher_ = Collections.emptyList();
            } else {
                this.passThroughMatcher_ = null;
                this.passThroughMatcherBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            this.authScopes_ = LazyStringArrayList.emptyList();
            this.resources_ = LazyStringArrayList.emptyList();
            this.authType_ = 0;
            this.useRefreshToken_ = null;
            if (this.useRefreshTokenBuilder_ != null) {
                this.useRefreshTokenBuilder_.dispose();
                this.useRefreshTokenBuilder_ = null;
            }
            this.defaultExpiresIn_ = null;
            if (this.defaultExpiresInBuilder_ != null) {
                this.defaultExpiresInBuilder_.dispose();
                this.defaultExpiresInBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return OauthProto.internal_static_envoy_extensions_filters_http_oauth2_v3_OAuth2Config_descriptor;
        }

        public OAuth2Config getDefaultInstanceForType() {
            return OAuth2Config.getDefaultInstance();
        }

        public OAuth2Config build() {
            OAuth2Config result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public OAuth2Config buildPartial() {
            OAuth2Config result = new OAuth2Config(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(OAuth2Config result) {
            if (this.passThroughMatcherBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.passThroughMatcher_ = Collections.unmodifiableList(this.passThroughMatcher_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.passThroughMatcher_ = this.passThroughMatcher_;
            } else {
                result.passThroughMatcher_ = this.passThroughMatcherBuilder_.build();
            }
        }

        private void buildPartial0(OAuth2Config result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.tokenEndpoint_ = this.tokenEndpointBuilder_ == null ? this.tokenEndpoint_ : (HttpUri)this.tokenEndpointBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.authorizationEndpoint_ = this.authorizationEndpoint_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.credentials_ = this.credentialsBuilder_ == null ? this.credentials_ : (OAuth2Credentials)this.credentialsBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.redirectUri_ = this.redirectUri_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.redirectPathMatcher_ = this.redirectPathMatcherBuilder_ == null ? this.redirectPathMatcher_ : (PathMatcher)this.redirectPathMatcherBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.signoutPath_ = this.signoutPathBuilder_ == null ? this.signoutPath_ : (PathMatcher)this.signoutPathBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.forwardBearerToken_ = this.forwardBearerToken_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.authScopes_.makeImmutable();
                result.authScopes_ = this.authScopes_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                this.resources_.makeImmutable();
                result.resources_ = this.resources_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.authType_ = this.authType_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.useRefreshToken_ = this.useRefreshTokenBuilder_ == null ? this.useRefreshToken_ : (BoolValue)this.useRefreshTokenBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.defaultExpiresIn_ = this.defaultExpiresInBuilder_ == null ? this.defaultExpiresIn_ : (Duration)this.defaultExpiresInBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof OAuth2Config) {
                return this.mergeFrom((OAuth2Config)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(OAuth2Config other) {
            if (other == OAuth2Config.getDefaultInstance()) {
                return this;
            }
            if (other.hasTokenEndpoint()) {
                this.mergeTokenEndpoint(other.getTokenEndpoint());
            }
            if (!other.getAuthorizationEndpoint().isEmpty()) {
                this.authorizationEndpoint_ = other.authorizationEndpoint_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasCredentials()) {
                this.mergeCredentials(other.getCredentials());
            }
            if (!other.getRedirectUri().isEmpty()) {
                this.redirectUri_ = other.redirectUri_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasRedirectPathMatcher()) {
                this.mergeRedirectPathMatcher(other.getRedirectPathMatcher());
            }
            if (other.hasSignoutPath()) {
                this.mergeSignoutPath(other.getSignoutPath());
            }
            if (other.getForwardBearerToken()) {
                this.setForwardBearerToken(other.getForwardBearerToken());
            }
            if (this.passThroughMatcherBuilder_ == null) {
                if (!other.passThroughMatcher_.isEmpty()) {
                    if (this.passThroughMatcher_.isEmpty()) {
                        this.passThroughMatcher_ = other.passThroughMatcher_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensurePassThroughMatcherIsMutable();
                        this.passThroughMatcher_.addAll(other.passThroughMatcher_);
                    }
                    this.onChanged();
                }
            } else if (!other.passThroughMatcher_.isEmpty()) {
                if (this.passThroughMatcherBuilder_.isEmpty()) {
                    this.passThroughMatcherBuilder_.dispose();
                    this.passThroughMatcherBuilder_ = null;
                    this.passThroughMatcher_ = other.passThroughMatcher_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.passThroughMatcherBuilder_ = alwaysUseFieldBuilders ? this.getPassThroughMatcherFieldBuilder() : null;
                } else {
                    this.passThroughMatcherBuilder_.addAllMessages((Iterable)other.passThroughMatcher_);
                }
            }
            if (!other.authScopes_.isEmpty()) {
                if (this.authScopes_.isEmpty()) {
                    this.authScopes_ = other.authScopes_;
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureAuthScopesIsMutable();
                    this.authScopes_.addAll((Collection)other.authScopes_);
                }
                this.onChanged();
            }
            if (!other.resources_.isEmpty()) {
                if (this.resources_.isEmpty()) {
                    this.resources_ = other.resources_;
                    this.bitField0_ |= 0x200;
                } else {
                    this.ensureResourcesIsMutable();
                    this.resources_.addAll((Collection)other.resources_);
                }
                this.onChanged();
            }
            if (other.authType_ != 0) {
                this.setAuthTypeValue(other.getAuthTypeValue());
            }
            if (other.hasUseRefreshToken()) {
                this.mergeUseRefreshToken(other.getUseRefreshToken());
            }
            if (other.hasDefaultExpiresIn()) {
                this.mergeDefaultExpiresIn(other.getDefaultExpiresIn());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getTokenEndpointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            this.authorizationEndpoint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCredentialsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 34: {
                            this.redirectUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getRedirectPathMatcherFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block21;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getSignoutPathFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 56: {
                            this.forwardBearerToken_ = input.readBool();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 66: {
                            HeaderMatcher m = (HeaderMatcher)input.readMessage(HeaderMatcher.parser(), extensionRegistry);
                            if (this.passThroughMatcherBuilder_ == null) {
                                this.ensurePassThroughMatcherIsMutable();
                                this.passThroughMatcher_.add(m);
                                continue block21;
                            }
                            this.passThroughMatcherBuilder_.addMessage((AbstractMessage)m);
                            continue block21;
                        }
                        case 74: {
                            String s = input.readStringRequireUtf8();
                            this.ensureAuthScopesIsMutable();
                            this.authScopes_.add((Object)s);
                            continue block21;
                        }
                        case 82: {
                            String s = input.readStringRequireUtf8();
                            this.ensureResourcesIsMutable();
                            this.resources_.add((Object)s);
                            continue block21;
                        }
                        case 88: {
                            this.authType_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block21;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getUseRefreshTokenFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block21;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getDefaultExpiresInFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasTokenEndpoint() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public HttpUri getTokenEndpoint() {
            if (this.tokenEndpointBuilder_ == null) {
                return this.tokenEndpoint_ == null ? HttpUri.getDefaultInstance() : this.tokenEndpoint_;
            }
            return (HttpUri)this.tokenEndpointBuilder_.getMessage();
        }

        public Builder setTokenEndpoint(HttpUri value) {
            if (this.tokenEndpointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.tokenEndpoint_ = value;
            } else {
                this.tokenEndpointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setTokenEndpoint(HttpUri.Builder builderForValue) {
            if (this.tokenEndpointBuilder_ == null) {
                this.tokenEndpoint_ = builderForValue.build();
            } else {
                this.tokenEndpointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeTokenEndpoint(HttpUri value) {
            if (this.tokenEndpointBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.tokenEndpoint_ != null && this.tokenEndpoint_ != HttpUri.getDefaultInstance()) {
                    this.getTokenEndpointBuilder().mergeFrom(value);
                } else {
                    this.tokenEndpoint_ = value;
                }
            } else {
                this.tokenEndpointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.tokenEndpoint_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTokenEndpoint() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.tokenEndpoint_ = null;
            if (this.tokenEndpointBuilder_ != null) {
                this.tokenEndpointBuilder_.dispose();
                this.tokenEndpointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public HttpUri.Builder getTokenEndpointBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (HttpUri.Builder)this.getTokenEndpointFieldBuilder().getBuilder();
        }

        @Override
        public HttpUriOrBuilder getTokenEndpointOrBuilder() {
            if (this.tokenEndpointBuilder_ != null) {
                return (HttpUriOrBuilder)this.tokenEndpointBuilder_.getMessageOrBuilder();
            }
            return this.tokenEndpoint_ == null ? HttpUri.getDefaultInstance() : this.tokenEndpoint_;
        }

        private SingleFieldBuilderV3<HttpUri, HttpUri.Builder, HttpUriOrBuilder> getTokenEndpointFieldBuilder() {
            if (this.tokenEndpointBuilder_ == null) {
                this.tokenEndpointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTokenEndpoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.tokenEndpoint_ = null;
            }
            return this.tokenEndpointBuilder_;
        }

        @Override
        public String getAuthorizationEndpoint() {
            Object ref = this.authorizationEndpoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.authorizationEndpoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAuthorizationEndpointBytes() {
            Object ref = this.authorizationEndpoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.authorizationEndpoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAuthorizationEndpoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.authorizationEndpoint_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearAuthorizationEndpoint() {
            this.authorizationEndpoint_ = OAuth2Config.getDefaultInstance().getAuthorizationEndpoint();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setAuthorizationEndpointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OAuth2Config.checkByteStringIsUtf8((ByteString)value);
            this.authorizationEndpoint_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCredentials() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public OAuth2Credentials getCredentials() {
            if (this.credentialsBuilder_ == null) {
                return this.credentials_ == null ? OAuth2Credentials.getDefaultInstance() : this.credentials_;
            }
            return (OAuth2Credentials)this.credentialsBuilder_.getMessage();
        }

        public Builder setCredentials(OAuth2Credentials value) {
            if (this.credentialsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.credentials_ = value;
            } else {
                this.credentialsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setCredentials(OAuth2Credentials.Builder builderForValue) {
            if (this.credentialsBuilder_ == null) {
                this.credentials_ = builderForValue.build();
            } else {
                this.credentialsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeCredentials(OAuth2Credentials value) {
            if (this.credentialsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.credentials_ != null && this.credentials_ != OAuth2Credentials.getDefaultInstance()) {
                    this.getCredentialsBuilder().mergeFrom(value);
                } else {
                    this.credentials_ = value;
                }
            } else {
                this.credentialsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.credentials_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCredentials() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.credentials_ = null;
            if (this.credentialsBuilder_ != null) {
                this.credentialsBuilder_.dispose();
                this.credentialsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public OAuth2Credentials.Builder getCredentialsBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (OAuth2Credentials.Builder)this.getCredentialsFieldBuilder().getBuilder();
        }

        @Override
        public OAuth2CredentialsOrBuilder getCredentialsOrBuilder() {
            if (this.credentialsBuilder_ != null) {
                return (OAuth2CredentialsOrBuilder)this.credentialsBuilder_.getMessageOrBuilder();
            }
            return this.credentials_ == null ? OAuth2Credentials.getDefaultInstance() : this.credentials_;
        }

        private SingleFieldBuilderV3<OAuth2Credentials, OAuth2Credentials.Builder, OAuth2CredentialsOrBuilder> getCredentialsFieldBuilder() {
            if (this.credentialsBuilder_ == null) {
                this.credentialsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCredentials(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.credentials_ = null;
            }
            return this.credentialsBuilder_;
        }

        @Override
        public String getRedirectUri() {
            Object ref = this.redirectUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.redirectUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRedirectUriBytes() {
            Object ref = this.redirectUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.redirectUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRedirectUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.redirectUri_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearRedirectUri() {
            this.redirectUri_ = OAuth2Config.getDefaultInstance().getRedirectUri();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setRedirectUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OAuth2Config.checkByteStringIsUtf8((ByteString)value);
            this.redirectUri_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRedirectPathMatcher() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public PathMatcher getRedirectPathMatcher() {
            if (this.redirectPathMatcherBuilder_ == null) {
                return this.redirectPathMatcher_ == null ? PathMatcher.getDefaultInstance() : this.redirectPathMatcher_;
            }
            return (PathMatcher)this.redirectPathMatcherBuilder_.getMessage();
        }

        public Builder setRedirectPathMatcher(PathMatcher value) {
            if (this.redirectPathMatcherBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.redirectPathMatcher_ = value;
            } else {
                this.redirectPathMatcherBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setRedirectPathMatcher(PathMatcher.Builder builderForValue) {
            if (this.redirectPathMatcherBuilder_ == null) {
                this.redirectPathMatcher_ = builderForValue.build();
            } else {
                this.redirectPathMatcherBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeRedirectPathMatcher(PathMatcher value) {
            if (this.redirectPathMatcherBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.redirectPathMatcher_ != null && this.redirectPathMatcher_ != PathMatcher.getDefaultInstance()) {
                    this.getRedirectPathMatcherBuilder().mergeFrom(value);
                } else {
                    this.redirectPathMatcher_ = value;
                }
            } else {
                this.redirectPathMatcherBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.redirectPathMatcher_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRedirectPathMatcher() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.redirectPathMatcher_ = null;
            if (this.redirectPathMatcherBuilder_ != null) {
                this.redirectPathMatcherBuilder_.dispose();
                this.redirectPathMatcherBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public PathMatcher.Builder getRedirectPathMatcherBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (PathMatcher.Builder)this.getRedirectPathMatcherFieldBuilder().getBuilder();
        }

        @Override
        public PathMatcherOrBuilder getRedirectPathMatcherOrBuilder() {
            if (this.redirectPathMatcherBuilder_ != null) {
                return (PathMatcherOrBuilder)this.redirectPathMatcherBuilder_.getMessageOrBuilder();
            }
            return this.redirectPathMatcher_ == null ? PathMatcher.getDefaultInstance() : this.redirectPathMatcher_;
        }

        private SingleFieldBuilderV3<PathMatcher, PathMatcher.Builder, PathMatcherOrBuilder> getRedirectPathMatcherFieldBuilder() {
            if (this.redirectPathMatcherBuilder_ == null) {
                this.redirectPathMatcherBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRedirectPathMatcher(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.redirectPathMatcher_ = null;
            }
            return this.redirectPathMatcherBuilder_;
        }

        @Override
        public boolean hasSignoutPath() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public PathMatcher getSignoutPath() {
            if (this.signoutPathBuilder_ == null) {
                return this.signoutPath_ == null ? PathMatcher.getDefaultInstance() : this.signoutPath_;
            }
            return (PathMatcher)this.signoutPathBuilder_.getMessage();
        }

        public Builder setSignoutPath(PathMatcher value) {
            if (this.signoutPathBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.signoutPath_ = value;
            } else {
                this.signoutPathBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setSignoutPath(PathMatcher.Builder builderForValue) {
            if (this.signoutPathBuilder_ == null) {
                this.signoutPath_ = builderForValue.build();
            } else {
                this.signoutPathBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeSignoutPath(PathMatcher value) {
            if (this.signoutPathBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.signoutPath_ != null && this.signoutPath_ != PathMatcher.getDefaultInstance()) {
                    this.getSignoutPathBuilder().mergeFrom(value);
                } else {
                    this.signoutPath_ = value;
                }
            } else {
                this.signoutPathBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.signoutPath_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSignoutPath() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.signoutPath_ = null;
            if (this.signoutPathBuilder_ != null) {
                this.signoutPathBuilder_.dispose();
                this.signoutPathBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public PathMatcher.Builder getSignoutPathBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (PathMatcher.Builder)this.getSignoutPathFieldBuilder().getBuilder();
        }

        @Override
        public PathMatcherOrBuilder getSignoutPathOrBuilder() {
            if (this.signoutPathBuilder_ != null) {
                return (PathMatcherOrBuilder)this.signoutPathBuilder_.getMessageOrBuilder();
            }
            return this.signoutPath_ == null ? PathMatcher.getDefaultInstance() : this.signoutPath_;
        }

        private SingleFieldBuilderV3<PathMatcher, PathMatcher.Builder, PathMatcherOrBuilder> getSignoutPathFieldBuilder() {
            if (this.signoutPathBuilder_ == null) {
                this.signoutPathBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSignoutPath(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.signoutPath_ = null;
            }
            return this.signoutPathBuilder_;
        }

        @Override
        public boolean getForwardBearerToken() {
            return this.forwardBearerToken_;
        }

        public Builder setForwardBearerToken(boolean value) {
            this.forwardBearerToken_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearForwardBearerToken() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.forwardBearerToken_ = false;
            this.onChanged();
            return this;
        }

        private void ensurePassThroughMatcherIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.passThroughMatcher_ = new ArrayList<HeaderMatcher>(this.passThroughMatcher_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<HeaderMatcher> getPassThroughMatcherList() {
            if (this.passThroughMatcherBuilder_ == null) {
                return Collections.unmodifiableList(this.passThroughMatcher_);
            }
            return this.passThroughMatcherBuilder_.getMessageList();
        }

        @Override
        public int getPassThroughMatcherCount() {
            if (this.passThroughMatcherBuilder_ == null) {
                return this.passThroughMatcher_.size();
            }
            return this.passThroughMatcherBuilder_.getCount();
        }

        @Override
        public HeaderMatcher getPassThroughMatcher(int index) {
            if (this.passThroughMatcherBuilder_ == null) {
                return this.passThroughMatcher_.get(index);
            }
            return (HeaderMatcher)this.passThroughMatcherBuilder_.getMessage(index);
        }

        public Builder setPassThroughMatcher(int index, HeaderMatcher value) {
            if (this.passThroughMatcherBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.set(index, value);
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPassThroughMatcher(int index, HeaderMatcher.Builder builderForValue) {
            if (this.passThroughMatcherBuilder_ == null) {
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPassThroughMatcher(HeaderMatcher value) {
            if (this.passThroughMatcherBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.add(value);
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPassThroughMatcher(int index, HeaderMatcher value) {
            if (this.passThroughMatcherBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.add(index, value);
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPassThroughMatcher(HeaderMatcher.Builder builderForValue) {
            if (this.passThroughMatcherBuilder_ == null) {
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPassThroughMatcher(int index, HeaderMatcher.Builder builderForValue) {
            if (this.passThroughMatcherBuilder_ == null) {
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPassThroughMatcher(Iterable<? extends HeaderMatcher> values) {
            if (this.passThroughMatcherBuilder_ == null) {
                this.ensurePassThroughMatcherIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.passThroughMatcher_);
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPassThroughMatcher() {
            if (this.passThroughMatcherBuilder_ == null) {
                this.passThroughMatcher_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.clear();
            }
            return this;
        }

        public Builder removePassThroughMatcher(int index) {
            if (this.passThroughMatcherBuilder_ == null) {
                this.ensurePassThroughMatcherIsMutable();
                this.passThroughMatcher_.remove(index);
                this.onChanged();
            } else {
                this.passThroughMatcherBuilder_.remove(index);
            }
            return this;
        }

        public HeaderMatcher.Builder getPassThroughMatcherBuilder(int index) {
            return (HeaderMatcher.Builder)this.getPassThroughMatcherFieldBuilder().getBuilder(index);
        }

        @Override
        public HeaderMatcherOrBuilder getPassThroughMatcherOrBuilder(int index) {
            if (this.passThroughMatcherBuilder_ == null) {
                return this.passThroughMatcher_.get(index);
            }
            return (HeaderMatcherOrBuilder)this.passThroughMatcherBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends HeaderMatcherOrBuilder> getPassThroughMatcherOrBuilderList() {
            if (this.passThroughMatcherBuilder_ != null) {
                return this.passThroughMatcherBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.passThroughMatcher_);
        }

        public HeaderMatcher.Builder addPassThroughMatcherBuilder() {
            return (HeaderMatcher.Builder)this.getPassThroughMatcherFieldBuilder().addBuilder((AbstractMessage)HeaderMatcher.getDefaultInstance());
        }

        public HeaderMatcher.Builder addPassThroughMatcherBuilder(int index) {
            return (HeaderMatcher.Builder)this.getPassThroughMatcherFieldBuilder().addBuilder(index, (AbstractMessage)HeaderMatcher.getDefaultInstance());
        }

        public List<HeaderMatcher.Builder> getPassThroughMatcherBuilderList() {
            return this.getPassThroughMatcherFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<HeaderMatcher, HeaderMatcher.Builder, HeaderMatcherOrBuilder> getPassThroughMatcherFieldBuilder() {
            if (this.passThroughMatcherBuilder_ == null) {
                this.passThroughMatcherBuilder_ = new RepeatedFieldBuilderV3(this.passThroughMatcher_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.passThroughMatcher_ = null;
            }
            return this.passThroughMatcherBuilder_;
        }

        private void ensureAuthScopesIsMutable() {
            if (!this.authScopes_.isModifiable()) {
                this.authScopes_ = new LazyStringArrayList((LazyStringList)this.authScopes_);
            }
            this.bitField0_ |= 0x100;
        }

        public ProtocolStringList getAuthScopesList() {
            this.authScopes_.makeImmutable();
            return this.authScopes_;
        }

        @Override
        public int getAuthScopesCount() {
            return this.authScopes_.size();
        }

        @Override
        public String getAuthScopes(int index) {
            return this.authScopes_.get(index);
        }

        @Override
        public ByteString getAuthScopesBytes(int index) {
            return this.authScopes_.getByteString(index);
        }

        public Builder setAuthScopes(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAuthScopesIsMutable();
            this.authScopes_.set(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAuthScopes(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAuthScopesIsMutable();
            this.authScopes_.add((Object)value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllAuthScopes(Iterable<String> values) {
            this.ensureAuthScopesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.authScopes_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearAuthScopes() {
            this.authScopes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addAuthScopesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OAuth2Config.checkByteStringIsUtf8((ByteString)value);
            this.ensureAuthScopesIsMutable();
            this.authScopes_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureResourcesIsMutable() {
            if (!this.resources_.isModifiable()) {
                this.resources_ = new LazyStringArrayList((LazyStringList)this.resources_);
            }
            this.bitField0_ |= 0x200;
        }

        public ProtocolStringList getResourcesList() {
            this.resources_.makeImmutable();
            return this.resources_;
        }

        @Override
        public int getResourcesCount() {
            return this.resources_.size();
        }

        @Override
        public String getResources(int index) {
            return this.resources_.get(index);
        }

        @Override
        public ByteString getResourcesBytes(int index) {
            return this.resources_.getByteString(index);
        }

        public Builder setResources(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureResourcesIsMutable();
            this.resources_.set(index, value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addResources(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureResourcesIsMutable();
            this.resources_.add((Object)value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addAllResources(Iterable<String> values) {
            this.ensureResourcesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.resources_);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearResources() {
            this.resources_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder addResourcesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OAuth2Config.checkByteStringIsUtf8((ByteString)value);
            this.ensureResourcesIsMutable();
            this.resources_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public int getAuthTypeValue() {
            return this.authType_;
        }

        public Builder setAuthTypeValue(int value) {
            this.authType_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public AuthType getAuthType() {
            AuthType result = AuthType.forNumber(this.authType_);
            return result == null ? AuthType.UNRECOGNIZED : result;
        }

        public Builder setAuthType(AuthType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.authType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAuthType() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.authType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasUseRefreshToken() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public BoolValue getUseRefreshToken() {
            if (this.useRefreshTokenBuilder_ == null) {
                return this.useRefreshToken_ == null ? BoolValue.getDefaultInstance() : this.useRefreshToken_;
            }
            return (BoolValue)this.useRefreshTokenBuilder_.getMessage();
        }

        public Builder setUseRefreshToken(BoolValue value) {
            if (this.useRefreshTokenBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.useRefreshToken_ = value;
            } else {
                this.useRefreshTokenBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setUseRefreshToken(BoolValue.Builder builderForValue) {
            if (this.useRefreshTokenBuilder_ == null) {
                this.useRefreshToken_ = builderForValue.build();
            } else {
                this.useRefreshTokenBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeUseRefreshToken(BoolValue value) {
            if (this.useRefreshTokenBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.useRefreshToken_ != null && this.useRefreshToken_ != BoolValue.getDefaultInstance()) {
                    this.getUseRefreshTokenBuilder().mergeFrom(value);
                } else {
                    this.useRefreshToken_ = value;
                }
            } else {
                this.useRefreshTokenBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.useRefreshToken_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUseRefreshToken() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.useRefreshToken_ = null;
            if (this.useRefreshTokenBuilder_ != null) {
                this.useRefreshTokenBuilder_.dispose();
                this.useRefreshTokenBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BoolValue.Builder getUseRefreshTokenBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (BoolValue.Builder)this.getUseRefreshTokenFieldBuilder().getBuilder();
        }

        @Override
        public BoolValueOrBuilder getUseRefreshTokenOrBuilder() {
            if (this.useRefreshTokenBuilder_ != null) {
                return (BoolValueOrBuilder)this.useRefreshTokenBuilder_.getMessageOrBuilder();
            }
            return this.useRefreshToken_ == null ? BoolValue.getDefaultInstance() : this.useRefreshToken_;
        }

        private SingleFieldBuilderV3<BoolValue, BoolValue.Builder, BoolValueOrBuilder> getUseRefreshTokenFieldBuilder() {
            if (this.useRefreshTokenBuilder_ == null) {
                this.useRefreshTokenBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUseRefreshToken(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.useRefreshToken_ = null;
            }
            return this.useRefreshTokenBuilder_;
        }

        @Override
        public boolean hasDefaultExpiresIn() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public Duration getDefaultExpiresIn() {
            if (this.defaultExpiresInBuilder_ == null) {
                return this.defaultExpiresIn_ == null ? Duration.getDefaultInstance() : this.defaultExpiresIn_;
            }
            return (Duration)this.defaultExpiresInBuilder_.getMessage();
        }

        public Builder setDefaultExpiresIn(Duration value) {
            if (this.defaultExpiresInBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.defaultExpiresIn_ = value;
            } else {
                this.defaultExpiresInBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setDefaultExpiresIn(Duration.Builder builderForValue) {
            if (this.defaultExpiresInBuilder_ == null) {
                this.defaultExpiresIn_ = builderForValue.build();
            } else {
                this.defaultExpiresInBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeDefaultExpiresIn(Duration value) {
            if (this.defaultExpiresInBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.defaultExpiresIn_ != null && this.defaultExpiresIn_ != Duration.getDefaultInstance()) {
                    this.getDefaultExpiresInBuilder().mergeFrom(value);
                } else {
                    this.defaultExpiresIn_ = value;
                }
            } else {
                this.defaultExpiresInBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.defaultExpiresIn_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDefaultExpiresIn() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.defaultExpiresIn_ = null;
            if (this.defaultExpiresInBuilder_ != null) {
                this.defaultExpiresInBuilder_.dispose();
                this.defaultExpiresInBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getDefaultExpiresInBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (Duration.Builder)this.getDefaultExpiresInFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getDefaultExpiresInOrBuilder() {
            if (this.defaultExpiresInBuilder_ != null) {
                return (DurationOrBuilder)this.defaultExpiresInBuilder_.getMessageOrBuilder();
            }
            return this.defaultExpiresIn_ == null ? Duration.getDefaultInstance() : this.defaultExpiresIn_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getDefaultExpiresInFieldBuilder() {
            if (this.defaultExpiresInBuilder_ == null) {
                this.defaultExpiresInBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDefaultExpiresIn(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.defaultExpiresIn_ = null;
            }
            return this.defaultExpiresInBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum AuthType implements ProtocolMessageEnum
    {
        URL_ENCODED_BODY(0),
        BASIC_AUTH(1),
        UNRECOGNIZED(-1);

        public static final int URL_ENCODED_BODY_VALUE = 0;
        public static final int BASIC_AUTH_VALUE = 1;
        private static final Internal.EnumLiteMap<AuthType> internalValueMap;
        private static final AuthType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AuthType valueOf(int value) {
            return AuthType.forNumber(value);
        }

        public static AuthType forNumber(int value) {
            switch (value) {
                case 0: {
                    return URL_ENCODED_BODY;
                }
                case 1: {
                    return BASIC_AUTH;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AuthType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AuthType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AuthType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)OAuth2Config.getDescriptor().getEnumTypes().get(0);
        }

        public static AuthType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AuthType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AuthType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<AuthType>(){

                public AuthType findValueByNumber(int number) {
                    return AuthType.forNumber(number);
                }
            };
            VALUES = AuthType.values();
        }
    }
}

