// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: opentelemetry/proto/metrics/v1/metrics.proto

// Protobuf Java Version: 3.25.1
package io.opentelemetry.proto.metrics.v1;

/**
 * <pre>
 * HistogramDataPoint is a single data point in a timeseries that describes the
 * time-varying values of a Histogram. A Histogram contains summary statistics
 * for a population of values, it may optionally contain the distribution of
 * those values across a set of buckets.
 *
 * If the histogram contains the distribution of values, then both
 * "explicit_bounds" and "bucket counts" fields must be defined.
 * If the histogram does not contain the distribution of values, then both
 * "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
 * "sum" are known.
 * </pre>
 *
 * Protobuf type {@code opentelemetry.proto.metrics.v1.HistogramDataPoint}
 */
public final class HistogramDataPoint extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opentelemetry.proto.metrics.v1.HistogramDataPoint)
    HistogramDataPointOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HistogramDataPoint.newBuilder() to construct.
  private HistogramDataPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HistogramDataPoint() {
    attributes_ = java.util.Collections.emptyList();
    bucketCounts_ = emptyLongList();
    explicitBounds_ = emptyDoubleList();
    exemplars_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new HistogramDataPoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_HistogramDataPoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_HistogramDataPoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opentelemetry.proto.metrics.v1.HistogramDataPoint.class, io.opentelemetry.proto.metrics.v1.HistogramDataPoint.Builder.class);
  }

  private int bitField0_;
  public static final int ATTRIBUTES_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private java.util.List<io.opentelemetry.proto.common.v1.KeyValue> attributes_;
  /**
   * <pre>
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<io.opentelemetry.proto.common.v1.KeyValue> getAttributesList() {
    return attributes_;
  }
  /**
   * <pre>
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
      getAttributesOrBuilderList() {
    return attributes_;
  }
  /**
   * <pre>
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
   */
  @java.lang.Override
  public int getAttributesCount() {
    return attributes_.size();
  }
  /**
   * <pre>
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.common.v1.KeyValue getAttributes(int index) {
    return attributes_.get(index);
  }
  /**
   * <pre>
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.common.v1.KeyValueOrBuilder getAttributesOrBuilder(
      int index) {
    return attributes_.get(index);
  }

  public static final int START_TIME_UNIX_NANO_FIELD_NUMBER = 2;
  private long startTimeUnixNano_ = 0L;
  /**
   * <pre>
   * StartTimeUnixNano is optional but strongly encouraged, see the
   * the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   * </pre>
   *
   * <code>fixed64 start_time_unix_nano = 2;</code>
   * @return The startTimeUnixNano.
   */
  @java.lang.Override
  public long getStartTimeUnixNano() {
    return startTimeUnixNano_;
  }

  public static final int TIME_UNIX_NANO_FIELD_NUMBER = 3;
  private long timeUnixNano_ = 0L;
  /**
   * <pre>
   * TimeUnixNano is required, see the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   * </pre>
   *
   * <code>fixed64 time_unix_nano = 3;</code>
   * @return The timeUnixNano.
   */
  @java.lang.Override
  public long getTimeUnixNano() {
    return timeUnixNano_;
  }

  public static final int COUNT_FIELD_NUMBER = 4;
  private long count_ = 0L;
  /**
   * <pre>
   * count is the number of values in the population. Must be non-negative. This
   * value must be equal to the sum of the "count" fields in buckets if a
   * histogram is provided.
   * </pre>
   *
   * <code>fixed64 count = 4;</code>
   * @return The count.
   */
  @java.lang.Override
  public long getCount() {
    return count_;
  }

  public static final int SUM_FIELD_NUMBER = 5;
  private double sum_ = 0D;
  /**
   * <pre>
   * sum of the values in the population. If count is zero then this field
   * must be zero.
   *
   * Note: Sum should only be filled out when measuring non-negative discrete
   * events, and is assumed to be monotonic over the values of these events.
   * Negative events *can* be recorded, but sum should not be filled out when
   * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
   * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
   * </pre>
   *
   * <code>optional double sum = 5;</code>
   * @return Whether the sum field is set.
   */
  @java.lang.Override
  public boolean hasSum() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * sum of the values in the population. If count is zero then this field
   * must be zero.
   *
   * Note: Sum should only be filled out when measuring non-negative discrete
   * events, and is assumed to be monotonic over the values of these events.
   * Negative events *can* be recorded, but sum should not be filled out when
   * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
   * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
   * </pre>
   *
   * <code>optional double sum = 5;</code>
   * @return The sum.
   */
  @java.lang.Override
  public double getSum() {
    return sum_;
  }

  public static final int BUCKET_COUNTS_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList bucketCounts_ =
      emptyLongList();
  /**
   * <pre>
   * bucket_counts is an optional field contains the count values of histogram
   * for each bucket.
   *
   * The sum of the bucket_counts must equal the value in the count field.
   *
   * The number of elements in bucket_counts array must be by one greater than
   * the number of elements in explicit_bounds array.
   * </pre>
   *
   * <code>repeated fixed64 bucket_counts = 6;</code>
   * @return A list containing the bucketCounts.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long>
      getBucketCountsList() {
    return bucketCounts_;
  }
  /**
   * <pre>
   * bucket_counts is an optional field contains the count values of histogram
   * for each bucket.
   *
   * The sum of the bucket_counts must equal the value in the count field.
   *
   * The number of elements in bucket_counts array must be by one greater than
   * the number of elements in explicit_bounds array.
   * </pre>
   *
   * <code>repeated fixed64 bucket_counts = 6;</code>
   * @return The count of bucketCounts.
   */
  public int getBucketCountsCount() {
    return bucketCounts_.size();
  }
  /**
   * <pre>
   * bucket_counts is an optional field contains the count values of histogram
   * for each bucket.
   *
   * The sum of the bucket_counts must equal the value in the count field.
   *
   * The number of elements in bucket_counts array must be by one greater than
   * the number of elements in explicit_bounds array.
   * </pre>
   *
   * <code>repeated fixed64 bucket_counts = 6;</code>
   * @param index The index of the element to return.
   * @return The bucketCounts at the given index.
   */
  public long getBucketCounts(int index) {
    return bucketCounts_.getLong(index);
  }
  private int bucketCountsMemoizedSerializedSize = -1;

  public static final int EXPLICIT_BOUNDS_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList explicitBounds_ =
      emptyDoubleList();
  /**
   * <pre>
   * explicit_bounds specifies buckets with explicitly defined bounds for values.
   *
   * The boundaries for bucket at index i are:
   *
   * (-infinity, explicit_bounds[i]] for i == 0
   * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
   * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
   *
   * The values in the explicit_bounds array must be strictly increasing.
   *
   * Histogram buckets are inclusive of their upper boundary, except the last
   * bucket where the boundary is at infinity. This format is intentionally
   * compatible with the OpenMetrics histogram definition.
   * </pre>
   *
   * <code>repeated double explicit_bounds = 7;</code>
   * @return A list containing the explicitBounds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getExplicitBoundsList() {
    return explicitBounds_;
  }
  /**
   * <pre>
   * explicit_bounds specifies buckets with explicitly defined bounds for values.
   *
   * The boundaries for bucket at index i are:
   *
   * (-infinity, explicit_bounds[i]] for i == 0
   * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
   * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
   *
   * The values in the explicit_bounds array must be strictly increasing.
   *
   * Histogram buckets are inclusive of their upper boundary, except the last
   * bucket where the boundary is at infinity. This format is intentionally
   * compatible with the OpenMetrics histogram definition.
   * </pre>
   *
   * <code>repeated double explicit_bounds = 7;</code>
   * @return The count of explicitBounds.
   */
  public int getExplicitBoundsCount() {
    return explicitBounds_.size();
  }
  /**
   * <pre>
   * explicit_bounds specifies buckets with explicitly defined bounds for values.
   *
   * The boundaries for bucket at index i are:
   *
   * (-infinity, explicit_bounds[i]] for i == 0
   * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
   * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
   *
   * The values in the explicit_bounds array must be strictly increasing.
   *
   * Histogram buckets are inclusive of their upper boundary, except the last
   * bucket where the boundary is at infinity. This format is intentionally
   * compatible with the OpenMetrics histogram definition.
   * </pre>
   *
   * <code>repeated double explicit_bounds = 7;</code>
   * @param index The index of the element to return.
   * @return The explicitBounds at the given index.
   */
  public double getExplicitBounds(int index) {
    return explicitBounds_.getDouble(index);
  }
  private int explicitBoundsMemoizedSerializedSize = -1;

  public static final int EXEMPLARS_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private java.util.List<io.opentelemetry.proto.metrics.v1.Exemplar> exemplars_;
  /**
   * <pre>
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
   */
  @java.lang.Override
  public java.util.List<io.opentelemetry.proto.metrics.v1.Exemplar> getExemplarsList() {
    return exemplars_;
  }
  /**
   * <pre>
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder> 
      getExemplarsOrBuilderList() {
    return exemplars_;
  }
  /**
   * <pre>
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
   */
  @java.lang.Override
  public int getExemplarsCount() {
    return exemplars_.size();
  }
  /**
   * <pre>
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Exemplar getExemplars(int index) {
    return exemplars_.get(index);
  }
  /**
   * <pre>
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder getExemplarsOrBuilder(
      int index) {
    return exemplars_.get(index);
  }

  public static final int FLAGS_FIELD_NUMBER = 10;
  private int flags_ = 0;
  /**
   * <pre>
   * Flags that apply to this specific data point.  See DataPointFlags
   * for the available flags and their meaning.
   * </pre>
   *
   * <code>uint32 flags = 10;</code>
   * @return The flags.
   */
  @java.lang.Override
  public int getFlags() {
    return flags_;
  }

  public static final int MIN_FIELD_NUMBER = 11;
  private double min_ = 0D;
  /**
   * <pre>
   * min is the minimum value over (start_time, end_time].
   * </pre>
   *
   * <code>optional double min = 11;</code>
   * @return Whether the min field is set.
   */
  @java.lang.Override
  public boolean hasMin() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * min is the minimum value over (start_time, end_time].
   * </pre>
   *
   * <code>optional double min = 11;</code>
   * @return The min.
   */
  @java.lang.Override
  public double getMin() {
    return min_;
  }

  public static final int MAX_FIELD_NUMBER = 12;
  private double max_ = 0D;
  /**
   * <pre>
   * max is the maximum value over (start_time, end_time].
   * </pre>
   *
   * <code>optional double max = 12;</code>
   * @return Whether the max field is set.
   */
  @java.lang.Override
  public boolean hasMax() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * max is the maximum value over (start_time, end_time].
   * </pre>
   *
   * <code>optional double max = 12;</code>
   * @return The max.
   */
  @java.lang.Override
  public double getMax() {
    return max_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (startTimeUnixNano_ != 0L) {
      output.writeFixed64(2, startTimeUnixNano_);
    }
    if (timeUnixNano_ != 0L) {
      output.writeFixed64(3, timeUnixNano_);
    }
    if (count_ != 0L) {
      output.writeFixed64(4, count_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(5, sum_);
    }
    if (getBucketCountsList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(bucketCountsMemoizedSerializedSize);
    }
    for (int i = 0; i < bucketCounts_.size(); i++) {
      output.writeFixed64NoTag(bucketCounts_.getLong(i));
    }
    if (getExplicitBoundsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(explicitBoundsMemoizedSerializedSize);
    }
    for (int i = 0; i < explicitBounds_.size(); i++) {
      output.writeDoubleNoTag(explicitBounds_.getDouble(i));
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      output.writeMessage(8, exemplars_.get(i));
    }
    for (int i = 0; i < attributes_.size(); i++) {
      output.writeMessage(9, attributes_.get(i));
    }
    if (flags_ != 0) {
      output.writeUInt32(10, flags_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(11, min_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeDouble(12, max_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTimeUnixNano_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeFixed64Size(2, startTimeUnixNano_);
    }
    if (timeUnixNano_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeFixed64Size(3, timeUnixNano_);
    }
    if (count_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeFixed64Size(4, count_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(5, sum_);
    }
    {
      int dataSize = 0;
      dataSize = 8 * getBucketCountsList().size();
      size += dataSize;
      if (!getBucketCountsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      bucketCountsMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 8 * getExplicitBoundsList().size();
      size += dataSize;
      if (!getExplicitBoundsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      explicitBoundsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, exemplars_.get(i));
    }
    for (int i = 0; i < attributes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, attributes_.get(i));
    }
    if (flags_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(10, flags_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(11, min_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(12, max_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opentelemetry.proto.metrics.v1.HistogramDataPoint)) {
      return super.equals(obj);
    }
    io.opentelemetry.proto.metrics.v1.HistogramDataPoint other = (io.opentelemetry.proto.metrics.v1.HistogramDataPoint) obj;

    if (!getAttributesList()
        .equals(other.getAttributesList())) return false;
    if (getStartTimeUnixNano()
        != other.getStartTimeUnixNano()) return false;
    if (getTimeUnixNano()
        != other.getTimeUnixNano()) return false;
    if (getCount()
        != other.getCount()) return false;
    if (hasSum() != other.hasSum()) return false;
    if (hasSum()) {
      if (java.lang.Double.doubleToLongBits(getSum())
          != java.lang.Double.doubleToLongBits(
              other.getSum())) return false;
    }
    if (!getBucketCountsList()
        .equals(other.getBucketCountsList())) return false;
    if (!getExplicitBoundsList()
        .equals(other.getExplicitBoundsList())) return false;
    if (!getExemplarsList()
        .equals(other.getExemplarsList())) return false;
    if (getFlags()
        != other.getFlags()) return false;
    if (hasMin() != other.hasMin()) return false;
    if (hasMin()) {
      if (java.lang.Double.doubleToLongBits(getMin())
          != java.lang.Double.doubleToLongBits(
              other.getMin())) return false;
    }
    if (hasMax() != other.hasMax()) return false;
    if (hasMax()) {
      if (java.lang.Double.doubleToLongBits(getMax())
          != java.lang.Double.doubleToLongBits(
              other.getMax())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAttributesCount() > 0) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAttributesList().hashCode();
    }
    hash = (37 * hash) + START_TIME_UNIX_NANO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getStartTimeUnixNano());
    hash = (37 * hash) + TIME_UNIX_NANO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getTimeUnixNano());
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getCount());
    if (hasSum()) {
      hash = (37 * hash) + SUM_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSum()));
    }
    if (getBucketCountsCount() > 0) {
      hash = (37 * hash) + BUCKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketCountsList().hashCode();
    }
    if (getExplicitBoundsCount() > 0) {
      hash = (37 * hash) + EXPLICIT_BOUNDS_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitBoundsList().hashCode();
    }
    if (getExemplarsCount() > 0) {
      hash = (37 * hash) + EXEMPLARS_FIELD_NUMBER;
      hash = (53 * hash) + getExemplarsList().hashCode();
    }
    hash = (37 * hash) + FLAGS_FIELD_NUMBER;
    hash = (53 * hash) + getFlags();
    if (hasMin()) {
      hash = (37 * hash) + MIN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMin()));
    }
    if (hasMax()) {
      hash = (37 * hash) + MAX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMax()));
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opentelemetry.proto.metrics.v1.HistogramDataPoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * HistogramDataPoint is a single data point in a timeseries that describes the
   * time-varying values of a Histogram. A Histogram contains summary statistics
   * for a population of values, it may optionally contain the distribution of
   * those values across a set of buckets.
   *
   * If the histogram contains the distribution of values, then both
   * "explicit_bounds" and "bucket counts" fields must be defined.
   * If the histogram does not contain the distribution of values, then both
   * "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
   * "sum" are known.
   * </pre>
   *
   * Protobuf type {@code opentelemetry.proto.metrics.v1.HistogramDataPoint}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opentelemetry.proto.metrics.v1.HistogramDataPoint)
      io.opentelemetry.proto.metrics.v1.HistogramDataPointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_HistogramDataPoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_HistogramDataPoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opentelemetry.proto.metrics.v1.HistogramDataPoint.class, io.opentelemetry.proto.metrics.v1.HistogramDataPoint.Builder.class);
    }

    // Construct using io.opentelemetry.proto.metrics.v1.HistogramDataPoint.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
      } else {
        attributes_ = null;
        attributesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      startTimeUnixNano_ = 0L;
      timeUnixNano_ = 0L;
      count_ = 0L;
      sum_ = 0D;
      bucketCounts_ = emptyLongList();
      explicitBounds_ = emptyDoubleList();
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
      } else {
        exemplars_ = null;
        exemplarsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      flags_ = 0;
      min_ = 0D;
      max_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_HistogramDataPoint_descriptor;
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.HistogramDataPoint getDefaultInstanceForType() {
      return io.opentelemetry.proto.metrics.v1.HistogramDataPoint.getDefaultInstance();
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.HistogramDataPoint build() {
      io.opentelemetry.proto.metrics.v1.HistogramDataPoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.HistogramDataPoint buildPartial() {
      io.opentelemetry.proto.metrics.v1.HistogramDataPoint result = new io.opentelemetry.proto.metrics.v1.HistogramDataPoint(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.opentelemetry.proto.metrics.v1.HistogramDataPoint result) {
      if (attributesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attributes_ = java.util.Collections.unmodifiableList(attributes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attributes_ = attributes_;
      } else {
        result.attributes_ = attributesBuilder_.build();
      }
      if (exemplarsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          exemplars_ = java.util.Collections.unmodifiableList(exemplars_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.exemplars_ = exemplars_;
      } else {
        result.exemplars_ = exemplarsBuilder_.build();
      }
    }

    private void buildPartial0(io.opentelemetry.proto.metrics.v1.HistogramDataPoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTimeUnixNano_ = startTimeUnixNano_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeUnixNano_ = timeUnixNano_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.count_ = count_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sum_ = sum_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        bucketCounts_.makeImmutable();
        result.bucketCounts_ = bucketCounts_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        explicitBounds_.makeImmutable();
        result.explicitBounds_ = explicitBounds_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.flags_ = flags_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.min_ = min_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.max_ = max_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opentelemetry.proto.metrics.v1.HistogramDataPoint) {
        return mergeFrom((io.opentelemetry.proto.metrics.v1.HistogramDataPoint)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opentelemetry.proto.metrics.v1.HistogramDataPoint other) {
      if (other == io.opentelemetry.proto.metrics.v1.HistogramDataPoint.getDefaultInstance()) return this;
      if (attributesBuilder_ == null) {
        if (!other.attributes_.isEmpty()) {
          if (attributes_.isEmpty()) {
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttributesIsMutable();
            attributes_.addAll(other.attributes_);
          }
          onChanged();
        }
      } else {
        if (!other.attributes_.isEmpty()) {
          if (attributesBuilder_.isEmpty()) {
            attributesBuilder_.dispose();
            attributesBuilder_ = null;
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attributesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getAttributesFieldBuilder() : null;
          } else {
            attributesBuilder_.addAllMessages(other.attributes_);
          }
        }
      }
      if (other.getStartTimeUnixNano() != 0L) {
        setStartTimeUnixNano(other.getStartTimeUnixNano());
      }
      if (other.getTimeUnixNano() != 0L) {
        setTimeUnixNano(other.getTimeUnixNano());
      }
      if (other.getCount() != 0L) {
        setCount(other.getCount());
      }
      if (other.hasSum()) {
        setSum(other.getSum());
      }
      if (!other.bucketCounts_.isEmpty()) {
        if (bucketCounts_.isEmpty()) {
          bucketCounts_ = other.bucketCounts_;
          bucketCounts_.makeImmutable();
          bitField0_ |= 0x00000020;
        } else {
          ensureBucketCountsIsMutable();
          bucketCounts_.addAll(other.bucketCounts_);
        }
        onChanged();
      }
      if (!other.explicitBounds_.isEmpty()) {
        if (explicitBounds_.isEmpty()) {
          explicitBounds_ = other.explicitBounds_;
          explicitBounds_.makeImmutable();
          bitField0_ |= 0x00000040;
        } else {
          ensureExplicitBoundsIsMutable();
          explicitBounds_.addAll(other.explicitBounds_);
        }
        onChanged();
      }
      if (exemplarsBuilder_ == null) {
        if (!other.exemplars_.isEmpty()) {
          if (exemplars_.isEmpty()) {
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureExemplarsIsMutable();
            exemplars_.addAll(other.exemplars_);
          }
          onChanged();
        }
      } else {
        if (!other.exemplars_.isEmpty()) {
          if (exemplarsBuilder_.isEmpty()) {
            exemplarsBuilder_.dispose();
            exemplarsBuilder_ = null;
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000080);
            exemplarsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getExemplarsFieldBuilder() : null;
          } else {
            exemplarsBuilder_.addAllMessages(other.exemplars_);
          }
        }
      }
      if (other.getFlags() != 0) {
        setFlags(other.getFlags());
      }
      if (other.hasMin()) {
        setMin(other.getMin());
      }
      if (other.hasMax()) {
        setMax(other.getMax());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 17: {
              startTimeUnixNano_ = input.readFixed64();
              bitField0_ |= 0x00000002;
              break;
            } // case 17
            case 25: {
              timeUnixNano_ = input.readFixed64();
              bitField0_ |= 0x00000004;
              break;
            } // case 25
            case 33: {
              count_ = input.readFixed64();
              bitField0_ |= 0x00000008;
              break;
            } // case 33
            case 41: {
              sum_ = input.readDouble();
              bitField0_ |= 0x00000010;
              break;
            } // case 41
            case 49: {
              long v = input.readFixed64();
              ensureBucketCountsIsMutable();
              bucketCounts_.addLong(v);
              break;
            } // case 49
            case 50: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureBucketCountsIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                bucketCounts_.addLong(input.readFixed64());
              }
              input.popLimit(limit);
              break;
            } // case 50
            case 57: {
              double v = input.readDouble();
              ensureExplicitBoundsIsMutable();
              explicitBounds_.addDouble(v);
              break;
            } // case 57
            case 58: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              int alloc = length > 4096 ? 4096 : length;
              ensureExplicitBoundsIsMutable(alloc / 8);
              while (input.getBytesUntilLimit() > 0) {
                explicitBounds_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 58
            case 66: {
              io.opentelemetry.proto.metrics.v1.Exemplar m =
                  input.readMessage(
                      io.opentelemetry.proto.metrics.v1.Exemplar.parser(),
                      extensionRegistry);
              if (exemplarsBuilder_ == null) {
                ensureExemplarsIsMutable();
                exemplars_.add(m);
              } else {
                exemplarsBuilder_.addMessage(m);
              }
              break;
            } // case 66
            case 74: {
              io.opentelemetry.proto.common.v1.KeyValue m =
                  input.readMessage(
                      io.opentelemetry.proto.common.v1.KeyValue.parser(),
                      extensionRegistry);
              if (attributesBuilder_ == null) {
                ensureAttributesIsMutable();
                attributes_.add(m);
              } else {
                attributesBuilder_.addMessage(m);
              }
              break;
            } // case 74
            case 80: {
              flags_ = input.readUInt32();
              bitField0_ |= 0x00000100;
              break;
            } // case 80
            case 89: {
              min_ = input.readDouble();
              bitField0_ |= 0x00000200;
              break;
            } // case 89
            case 97: {
              max_ = input.readDouble();
              bitField0_ |= 0x00000400;
              break;
            } // case 97
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.util.List<io.opentelemetry.proto.common.v1.KeyValue> attributes_ =
      java.util.Collections.emptyList();
    private void ensureAttributesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attributes_ = new java.util.ArrayList<io.opentelemetry.proto.common.v1.KeyValue>(attributes_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder> attributesBuilder_;

    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public java.util.List<io.opentelemetry.proto.common.v1.KeyValue> getAttributesList() {
      if (attributesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributes_);
      } else {
        return attributesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public int getAttributesCount() {
      if (attributesBuilder_ == null) {
        return attributes_.size();
      } else {
        return attributesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue getAttributes(int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder setAttributes(
        int index, io.opentelemetry.proto.common.v1.KeyValue value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.set(index, value);
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder setAttributes(
        int index, io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder addAttributes(io.opentelemetry.proto.common.v1.KeyValue value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder addAttributes(
        int index, io.opentelemetry.proto.common.v1.KeyValue value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(index, value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder addAttributes(
        io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder addAttributes(
        int index, io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder addAllAttributes(
        java.lang.Iterable<? extends io.opentelemetry.proto.common.v1.KeyValue> values) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, attributes_);
        onChanged();
      } else {
        attributesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder clearAttributes() {
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attributesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public Builder removeAttributes(int index) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.remove(index);
        onChanged();
      } else {
        attributesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder getAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValueOrBuilder getAttributesOrBuilder(
        int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);  } else {
        return attributesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public java.util.List<? extends io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
         getAttributesOrBuilderList() {
      if (attributesBuilder_ != null) {
        return attributesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributes_);
      }
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder addAttributesBuilder() {
      return getAttributesFieldBuilder().addBuilder(
          io.opentelemetry.proto.common.v1.KeyValue.getDefaultInstance());
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder addAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder().addBuilder(
          index, io.opentelemetry.proto.common.v1.KeyValue.getDefaultInstance());
    }
    /**
     * <pre>
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    public java.util.List<io.opentelemetry.proto.common.v1.KeyValue.Builder> 
         getAttributesBuilderList() {
      return getAttributesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
        getAttributesFieldBuilder() {
      if (attributesBuilder_ == null) {
        attributesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder>(
                attributes_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        attributes_ = null;
      }
      return attributesBuilder_;
    }

    private long startTimeUnixNano_ ;
    /**
     * <pre>
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 start_time_unix_nano = 2;</code>
     * @return The startTimeUnixNano.
     */
    @java.lang.Override
    public long getStartTimeUnixNano() {
      return startTimeUnixNano_;
    }
    /**
     * <pre>
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 start_time_unix_nano = 2;</code>
     * @param value The startTimeUnixNano to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimeUnixNano(long value) {

      startTimeUnixNano_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 start_time_unix_nano = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearStartTimeUnixNano() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTimeUnixNano_ = 0L;
      onChanged();
      return this;
    }

    private long timeUnixNano_ ;
    /**
     * <pre>
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 time_unix_nano = 3;</code>
     * @return The timeUnixNano.
     */
    @java.lang.Override
    public long getTimeUnixNano() {
      return timeUnixNano_;
    }
    /**
     * <pre>
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 time_unix_nano = 3;</code>
     * @param value The timeUnixNano to set.
     * @return This builder for chaining.
     */
    public Builder setTimeUnixNano(long value) {

      timeUnixNano_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     * </pre>
     *
     * <code>fixed64 time_unix_nano = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearTimeUnixNano() {
      bitField0_ = (bitField0_ & ~0x00000004);
      timeUnixNano_ = 0L;
      onChanged();
      return this;
    }

    private long count_ ;
    /**
     * <pre>
     * count is the number of values in the population. Must be non-negative. This
     * value must be equal to the sum of the "count" fields in buckets if a
     * histogram is provided.
     * </pre>
     *
     * <code>fixed64 count = 4;</code>
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }
    /**
     * <pre>
     * count is the number of values in the population. Must be non-negative. This
     * value must be equal to the sum of the "count" fields in buckets if a
     * histogram is provided.
     * </pre>
     *
     * <code>fixed64 count = 4;</code>
     * @param value The count to set.
     * @return This builder for chaining.
     */
    public Builder setCount(long value) {

      count_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * count is the number of values in the population. Must be non-negative. This
     * value must be equal to the sum of the "count" fields in buckets if a
     * histogram is provided.
     * </pre>
     *
     * <code>fixed64 count = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      count_ = 0L;
      onChanged();
      return this;
    }

    private double sum_ ;
    /**
     * <pre>
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     * </pre>
     *
     * <code>optional double sum = 5;</code>
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     * </pre>
     *
     * <code>optional double sum = 5;</code>
     * @return The sum.
     */
    @java.lang.Override
    public double getSum() {
      return sum_;
    }
    /**
     * <pre>
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     * </pre>
     *
     * <code>optional double sum = 5;</code>
     * @param value The sum to set.
     * @return This builder for chaining.
     */
    public Builder setSum(double value) {

      sum_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     * </pre>
     *
     * <code>optional double sum = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearSum() {
      bitField0_ = (bitField0_ & ~0x00000010);
      sum_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList bucketCounts_ = emptyLongList();
    private void ensureBucketCountsIsMutable() {
      if (!bucketCounts_.isModifiable()) {
        bucketCounts_ = makeMutableCopy(bucketCounts_);
      }
      bitField0_ |= 0x00000020;
    }
    private void ensureBucketCountsIsMutable(int capacity) {
      if (!bucketCounts_.isModifiable()) {
        bucketCounts_ = makeMutableCopy(bucketCounts_, capacity);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @return A list containing the bucketCounts.
     */
    public java.util.List<java.lang.Long>
        getBucketCountsList() {
      bucketCounts_.makeImmutable();
      return bucketCounts_;
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @return The count of bucketCounts.
     */
    public int getBucketCountsCount() {
      return bucketCounts_.size();
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @param index The index of the element to return.
     * @return The bucketCounts at the given index.
     */
    public long getBucketCounts(int index) {
      return bucketCounts_.getLong(index);
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @param index The index to set the value at.
     * @param value The bucketCounts to set.
     * @return This builder for chaining.
     */
    public Builder setBucketCounts(
        int index, long value) {

      ensureBucketCountsIsMutable();
      bucketCounts_.setLong(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @param value The bucketCounts to add.
     * @return This builder for chaining.
     */
    public Builder addBucketCounts(long value) {

      ensureBucketCountsIsMutable();
      bucketCounts_.addLong(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @param values The bucketCounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllBucketCounts(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureBucketCountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, bucketCounts_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     * </pre>
     *
     * <code>repeated fixed64 bucket_counts = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearBucketCounts() {
      bucketCounts_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList explicitBounds_ = emptyDoubleList();
    private void ensureExplicitBoundsIsMutable() {
      if (!explicitBounds_.isModifiable()) {
        explicitBounds_ = makeMutableCopy(explicitBounds_);
      }
      bitField0_ |= 0x00000040;
    }
    private void ensureExplicitBoundsIsMutable(int capacity) {
      if (!explicitBounds_.isModifiable()) {
        explicitBounds_ = makeMutableCopy(explicitBounds_, capacity);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @return A list containing the explicitBounds.
     */
    public java.util.List<java.lang.Double>
        getExplicitBoundsList() {
      explicitBounds_.makeImmutable();
      return explicitBounds_;
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @return The count of explicitBounds.
     */
    public int getExplicitBoundsCount() {
      return explicitBounds_.size();
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @param index The index of the element to return.
     * @return The explicitBounds at the given index.
     */
    public double getExplicitBounds(int index) {
      return explicitBounds_.getDouble(index);
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @param index The index to set the value at.
     * @param value The explicitBounds to set.
     * @return This builder for chaining.
     */
    public Builder setExplicitBounds(
        int index, double value) {

      ensureExplicitBoundsIsMutable();
      explicitBounds_.setDouble(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @param value The explicitBounds to add.
     * @return This builder for chaining.
     */
    public Builder addExplicitBounds(double value) {

      ensureExplicitBoundsIsMutable();
      explicitBounds_.addDouble(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @param values The explicitBounds to add.
     * @return This builder for chaining.
     */
    public Builder addAllExplicitBounds(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureExplicitBoundsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, explicitBounds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 &lt; i &lt; size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     * </pre>
     *
     * <code>repeated double explicit_bounds = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearExplicitBounds() {
      explicitBounds_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    private java.util.List<io.opentelemetry.proto.metrics.v1.Exemplar> exemplars_ =
      java.util.Collections.emptyList();
    private void ensureExemplarsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        exemplars_ = new java.util.ArrayList<io.opentelemetry.proto.metrics.v1.Exemplar>(exemplars_);
        bitField0_ |= 0x00000080;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opentelemetry.proto.metrics.v1.Exemplar, io.opentelemetry.proto.metrics.v1.Exemplar.Builder, io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder> exemplarsBuilder_;

    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public java.util.List<io.opentelemetry.proto.metrics.v1.Exemplar> getExemplarsList() {
      if (exemplarsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(exemplars_);
      } else {
        return exemplarsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public int getExemplarsCount() {
      if (exemplarsBuilder_ == null) {
        return exemplars_.size();
      } else {
        return exemplarsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Exemplar getExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);
      } else {
        return exemplarsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder setExemplars(
        int index, io.opentelemetry.proto.metrics.v1.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.set(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder setExemplars(
        int index, io.opentelemetry.proto.metrics.v1.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.set(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder addExemplars(io.opentelemetry.proto.metrics.v1.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder addExemplars(
        int index, io.opentelemetry.proto.metrics.v1.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder addExemplars(
        io.opentelemetry.proto.metrics.v1.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder addExemplars(
        int index, io.opentelemetry.proto.metrics.v1.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder addAllExemplars(
        java.lang.Iterable<? extends io.opentelemetry.proto.metrics.v1.Exemplar> values) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exemplars_);
        onChanged();
      } else {
        exemplarsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder clearExemplars() {
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        exemplarsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public Builder removeExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.remove(index);
        onChanged();
      } else {
        exemplarsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Exemplar.Builder getExemplarsBuilder(
        int index) {
      return getExemplarsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder getExemplarsOrBuilder(
        int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);  } else {
        return exemplarsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public java.util.List<? extends io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder> 
         getExemplarsOrBuilderList() {
      if (exemplarsBuilder_ != null) {
        return exemplarsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(exemplars_);
      }
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Exemplar.Builder addExemplarsBuilder() {
      return getExemplarsFieldBuilder().addBuilder(
          io.opentelemetry.proto.metrics.v1.Exemplar.getDefaultInstance());
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Exemplar.Builder addExemplarsBuilder(
        int index) {
      return getExemplarsFieldBuilder().addBuilder(
          index, io.opentelemetry.proto.metrics.v1.Exemplar.getDefaultInstance());
    }
    /**
     * <pre>
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.metrics.v1.Exemplar exemplars = 8;</code>
     */
    public java.util.List<io.opentelemetry.proto.metrics.v1.Exemplar.Builder> 
         getExemplarsBuilderList() {
      return getExemplarsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opentelemetry.proto.metrics.v1.Exemplar, io.opentelemetry.proto.metrics.v1.Exemplar.Builder, io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder> 
        getExemplarsFieldBuilder() {
      if (exemplarsBuilder_ == null) {
        exemplarsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opentelemetry.proto.metrics.v1.Exemplar, io.opentelemetry.proto.metrics.v1.Exemplar.Builder, io.opentelemetry.proto.metrics.v1.ExemplarOrBuilder>(
                exemplars_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        exemplars_ = null;
      }
      return exemplarsBuilder_;
    }

    private int flags_ ;
    /**
     * <pre>
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     * </pre>
     *
     * <code>uint32 flags = 10;</code>
     * @return The flags.
     */
    @java.lang.Override
    public int getFlags() {
      return flags_;
    }
    /**
     * <pre>
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     * </pre>
     *
     * <code>uint32 flags = 10;</code>
     * @param value The flags to set.
     * @return This builder for chaining.
     */
    public Builder setFlags(int value) {

      flags_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     * </pre>
     *
     * <code>uint32 flags = 10;</code>
     * @return This builder for chaining.
     */
    public Builder clearFlags() {
      bitField0_ = (bitField0_ & ~0x00000100);
      flags_ = 0;
      onChanged();
      return this;
    }

    private double min_ ;
    /**
     * <pre>
     * min is the minimum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double min = 11;</code>
     * @return Whether the min field is set.
     */
    @java.lang.Override
    public boolean hasMin() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * min is the minimum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double min = 11;</code>
     * @return The min.
     */
    @java.lang.Override
    public double getMin() {
      return min_;
    }
    /**
     * <pre>
     * min is the minimum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double min = 11;</code>
     * @param value The min to set.
     * @return This builder for chaining.
     */
    public Builder setMin(double value) {

      min_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * min is the minimum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double min = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearMin() {
      bitField0_ = (bitField0_ & ~0x00000200);
      min_ = 0D;
      onChanged();
      return this;
    }

    private double max_ ;
    /**
     * <pre>
     * max is the maximum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double max = 12;</code>
     * @return Whether the max field is set.
     */
    @java.lang.Override
    public boolean hasMax() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * max is the maximum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double max = 12;</code>
     * @return The max.
     */
    @java.lang.Override
    public double getMax() {
      return max_;
    }
    /**
     * <pre>
     * max is the maximum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double max = 12;</code>
     * @param value The max to set.
     * @return This builder for chaining.
     */
    public Builder setMax(double value) {

      max_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * max is the maximum value over (start_time, end_time].
     * </pre>
     *
     * <code>optional double max = 12;</code>
     * @return This builder for chaining.
     */
    public Builder clearMax() {
      bitField0_ = (bitField0_ & ~0x00000400);
      max_ = 0D;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opentelemetry.proto.metrics.v1.HistogramDataPoint)
  }

  // @@protoc_insertion_point(class_scope:opentelemetry.proto.metrics.v1.HistogramDataPoint)
  private static final io.opentelemetry.proto.metrics.v1.HistogramDataPoint DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opentelemetry.proto.metrics.v1.HistogramDataPoint();
  }

  public static io.opentelemetry.proto.metrics.v1.HistogramDataPoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HistogramDataPoint>
      PARSER = new com.google.protobuf.AbstractParser<HistogramDataPoint>() {
    @java.lang.Override
    public HistogramDataPoint parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<HistogramDataPoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HistogramDataPoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.HistogramDataPoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

