// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.proto

// Protobuf Java Version: 3.25.1
package io.envoyproxy.envoy.extensions.transport_sockets.tls.v3;

/**
 * <pre>
 * Configuration specific to the `SPIFFE &lt;https://github.com/spiffe/spiffe&gt;`_ certificate validator.
 *
 * Example:
 *
 * .. validated-code-block:: yaml
 *   :type-name: envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext
 *
 *   custom_validator_config:
 *     name: envoy.tls.cert_validator.spiffe
 *     typed_config:
 *       "&#64;type": type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig
 *       trust_domains:
 *       - name: foo.com
 *         trust_bundle:
 *           filename: "foo.pem"
 *       - name: envoy.com
 *         trust_bundle:
 *           filename: "envoy.pem"
 *
 * In this example, a presented peer certificate whose SAN matches ``spiffe://foo.com/&#42;*`` is validated against
 * the "foo.pem" x.509 certificate. All the trust bundles are isolated from each other, so no trust domain can mint
 * a SVID belonging to another trust domain. That means, in this example, a SVID signed by ``envoy.com``'s CA with ``spiffe://foo.com/&#42;*``
 * SAN would be rejected since Envoy selects the trust bundle according to the presented SAN before validate the certificate.
 *
 * Note that SPIFFE validator inherits and uses the following options from :ref:`CertificateValidationContext &lt;envoy_v3_api_msg_extensions.transport_sockets.tls.v3.CertificateValidationContext&gt;`.
 *
 * - :ref:`allow_expired_certificate &lt;envoy_v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidationContext.allow_expired_certificate&gt;` to allow expired certificates.
 * - :ref:`match_typed_subject_alt_names &lt;envoy_v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidationContext.match_typed_subject_alt_names&gt;` to match **URI** SAN of certificates. Unlike the default validator, SPIFFE validator only matches **URI** SAN (which equals to SVID in SPIFFE terminology) and ignore other SAN types.
 * </pre>
 *
 * Protobuf type {@code envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig}
 */
public final class SPIFFECertValidatorConfig extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)
    SPIFFECertValidatorConfigOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SPIFFECertValidatorConfig.newBuilder() to construct.
  private SPIFFECertValidatorConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SPIFFECertValidatorConfig() {
    trustDomains_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new SPIFFECertValidatorConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.class, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.Builder.class);
  }

  public interface TrustDomainOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
     * Note that this must *not* have "spiffe://" prefix.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
     * Note that this must *not* have "spiffe://" prefix.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     * @return Whether the trustBundle field is set.
     */
    boolean hasTrustBundle();
    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     * @return The trustBundle.
     */
    io.envoyproxy.envoy.config.core.v3.DataSource getTrustBundle();
    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     */
    io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder getTrustBundleOrBuilder();
  }
  /**
   * Protobuf type {@code envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain}
   */
  public static final class TrustDomain extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)
      TrustDomainOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TrustDomain.newBuilder() to construct.
    private TrustDomain(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TrustDomain() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TrustDomain();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_TrustDomain_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_TrustDomain_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.class, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
     * Note that this must *not* have "spiffe://" prefix.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
     * Note that this must *not* have "spiffe://" prefix.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TRUST_BUNDLE_FIELD_NUMBER = 2;
    private io.envoyproxy.envoy.config.core.v3.DataSource trustBundle_;
    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     * @return Whether the trustBundle field is set.
     */
    @java.lang.Override
    public boolean hasTrustBundle() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     * @return The trustBundle.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.DataSource getTrustBundle() {
      return trustBundle_ == null ? io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance() : trustBundle_;
    }
    /**
     * <pre>
     * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
     * </pre>
     *
     * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder getTrustBundleOrBuilder() {
      return trustBundle_ == null ? io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance() : trustBundle_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getTrustBundle());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getTrustBundle());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain other = (io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (hasTrustBundle() != other.hasTrustBundle()) return false;
      if (hasTrustBundle()) {
        if (!getTrustBundle()
            .equals(other.getTrustBundle())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasTrustBundle()) {
        hash = (37 * hash) + TRUST_BUNDLE_FIELD_NUMBER;
        hash = (53 * hash) + getTrustBundle().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_TrustDomain_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_TrustDomain_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.class, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTrustBundleFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        trustBundle_ = null;
        if (trustBundleBuilder_ != null) {
          trustBundleBuilder_.dispose();
          trustBundleBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_TrustDomain_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain getDefaultInstanceForType() {
        return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain build() {
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain buildPartial() {
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain result = new io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.trustBundle_ = trustBundleBuilder_ == null
              ? trustBundle_
              : trustBundleBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain) {
          return mergeFrom((io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain other) {
        if (other == io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasTrustBundle()) {
          mergeTrustBundle(other.getTrustBundle());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getTrustBundleFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
       * Note that this must *not* have "spiffe://" prefix.
       * </pre>
       *
       * <code>string name = 1 [(.validate.rules) = { ... }</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
       * Note that this must *not* have "spiffe://" prefix.
       * </pre>
       *
       * <code>string name = 1 [(.validate.rules) = { ... }</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
       * Note that this must *not* have "spiffe://" prefix.
       * </pre>
       *
       * <code>string name = 1 [(.validate.rules) = { ... }</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
       * Note that this must *not* have "spiffe://" prefix.
       * </pre>
       *
       * <code>string name = 1 [(.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
       * Note that this must *not* have "spiffe://" prefix.
       * </pre>
       *
       * <code>string name = 1 [(.validate.rules) = { ... }</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private io.envoyproxy.envoy.config.core.v3.DataSource trustBundle_;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder> trustBundleBuilder_;
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       * @return Whether the trustBundle field is set.
       */
      public boolean hasTrustBundle() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       * @return The trustBundle.
       */
      public io.envoyproxy.envoy.config.core.v3.DataSource getTrustBundle() {
        if (trustBundleBuilder_ == null) {
          return trustBundle_ == null ? io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance() : trustBundle_;
        } else {
          return trustBundleBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public Builder setTrustBundle(io.envoyproxy.envoy.config.core.v3.DataSource value) {
        if (trustBundleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trustBundle_ = value;
        } else {
          trustBundleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public Builder setTrustBundle(
          io.envoyproxy.envoy.config.core.v3.DataSource.Builder builderForValue) {
        if (trustBundleBuilder_ == null) {
          trustBundle_ = builderForValue.build();
        } else {
          trustBundleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public Builder mergeTrustBundle(io.envoyproxy.envoy.config.core.v3.DataSource value) {
        if (trustBundleBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            trustBundle_ != null &&
            trustBundle_ != io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance()) {
            getTrustBundleBuilder().mergeFrom(value);
          } else {
            trustBundle_ = value;
          }
        } else {
          trustBundleBuilder_.mergeFrom(value);
        }
        if (trustBundle_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public Builder clearTrustBundle() {
        bitField0_ = (bitField0_ & ~0x00000002);
        trustBundle_ = null;
        if (trustBundleBuilder_ != null) {
          trustBundleBuilder_.dispose();
          trustBundleBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.DataSource.Builder getTrustBundleBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTrustBundleFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder getTrustBundleOrBuilder() {
        if (trustBundleBuilder_ != null) {
          return trustBundleBuilder_.getMessageOrBuilder();
        } else {
          return trustBundle_ == null ?
              io.envoyproxy.envoy.config.core.v3.DataSource.getDefaultInstance() : trustBundle_;
        }
      }
      /**
       * <pre>
       * Specify a data source holding x.509 trust bundle used for validating incoming SVID(s) in this trust domain.
       * </pre>
       *
       * <code>.envoy.config.core.v3.DataSource trust_bundle = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder> 
          getTrustBundleFieldBuilder() {
        if (trustBundleBuilder_ == null) {
          trustBundleBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.envoyproxy.envoy.config.core.v3.DataSource, io.envoyproxy.envoy.config.core.v3.DataSource.Builder, io.envoyproxy.envoy.config.core.v3.DataSourceOrBuilder>(
                  getTrustBundle(),
                  getParentForChildren(),
                  isClean());
          trustBundle_ = null;
        }
        return trustBundleBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)
    }

    // @@protoc_insertion_point(class_scope:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain)
    private static final io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain();
    }

    public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrustDomain>
        PARSER = new com.google.protobuf.AbstractParser<TrustDomain>() {
      @java.lang.Override
      public TrustDomain parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TrustDomain> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrustDomain> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int TRUST_DOMAINS_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain> trustDomains_;
  /**
   * <pre>
   * This field specifies trust domains used for validating incoming X.509-SVID(s).
   * </pre>
   *
   * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain> getTrustDomainsList() {
    return trustDomains_;
  }
  /**
   * <pre>
   * This field specifies trust domains used for validating incoming X.509-SVID(s).
   * </pre>
   *
   * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder> 
      getTrustDomainsOrBuilderList() {
    return trustDomains_;
  }
  /**
   * <pre>
   * This field specifies trust domains used for validating incoming X.509-SVID(s).
   * </pre>
   *
   * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public int getTrustDomainsCount() {
    return trustDomains_.size();
  }
  /**
   * <pre>
   * This field specifies trust domains used for validating incoming X.509-SVID(s).
   * </pre>
   *
   * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain getTrustDomains(int index) {
    return trustDomains_.get(index);
  }
  /**
   * <pre>
   * This field specifies trust domains used for validating incoming X.509-SVID(s).
   * </pre>
   *
   * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder getTrustDomainsOrBuilder(
      int index) {
    return trustDomains_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < trustDomains_.size(); i++) {
      output.writeMessage(1, trustDomains_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < trustDomains_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, trustDomains_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig other = (io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig) obj;

    if (!getTrustDomainsList()
        .equals(other.getTrustDomainsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTrustDomainsCount() > 0) {
      hash = (37 * hash) + TRUST_DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getTrustDomainsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Configuration specific to the `SPIFFE &lt;https://github.com/spiffe/spiffe&gt;`_ certificate validator.
   *
   * Example:
   *
   * .. validated-code-block:: yaml
   *   :type-name: envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext
   *
   *   custom_validator_config:
   *     name: envoy.tls.cert_validator.spiffe
   *     typed_config:
   *       "&#64;type": type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig
   *       trust_domains:
   *       - name: foo.com
   *         trust_bundle:
   *           filename: "foo.pem"
   *       - name: envoy.com
   *         trust_bundle:
   *           filename: "envoy.pem"
   *
   * In this example, a presented peer certificate whose SAN matches ``spiffe://foo.com/&#42;*`` is validated against
   * the "foo.pem" x.509 certificate. All the trust bundles are isolated from each other, so no trust domain can mint
   * a SVID belonging to another trust domain. That means, in this example, a SVID signed by ``envoy.com``'s CA with ``spiffe://foo.com/&#42;*``
   * SAN would be rejected since Envoy selects the trust bundle according to the presented SAN before validate the certificate.
   *
   * Note that SPIFFE validator inherits and uses the following options from :ref:`CertificateValidationContext &lt;envoy_v3_api_msg_extensions.transport_sockets.tls.v3.CertificateValidationContext&gt;`.
   *
   * - :ref:`allow_expired_certificate &lt;envoy_v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidationContext.allow_expired_certificate&gt;` to allow expired certificates.
   * - :ref:`match_typed_subject_alt_names &lt;envoy_v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidationContext.match_typed_subject_alt_names&gt;` to match **URI** SAN of certificates. Unlike the default validator, SPIFFE validator only matches **URI** SAN (which equals to SVID in SPIFFE terminology) and ignore other SAN types.
   * </pre>
   *
   * Protobuf type {@code envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)
      io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.class, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (trustDomainsBuilder_ == null) {
        trustDomains_ = java.util.Collections.emptyList();
      } else {
        trustDomains_ = null;
        trustDomainsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsSpiffeValidatorConfigProto.internal_static_envoy_extensions_transport_sockets_tls_v3_SPIFFECertValidatorConfig_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig getDefaultInstanceForType() {
      return io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig build() {
      io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig buildPartial() {
      io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig result = new io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig result) {
      if (trustDomainsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          trustDomains_ = java.util.Collections.unmodifiableList(trustDomains_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.trustDomains_ = trustDomains_;
      } else {
        result.trustDomains_ = trustDomainsBuilder_.build();
      }
    }

    private void buildPartial0(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig) {
        return mergeFrom((io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig other) {
      if (other == io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.getDefaultInstance()) return this;
      if (trustDomainsBuilder_ == null) {
        if (!other.trustDomains_.isEmpty()) {
          if (trustDomains_.isEmpty()) {
            trustDomains_ = other.trustDomains_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTrustDomainsIsMutable();
            trustDomains_.addAll(other.trustDomains_);
          }
          onChanged();
        }
      } else {
        if (!other.trustDomains_.isEmpty()) {
          if (trustDomainsBuilder_.isEmpty()) {
            trustDomainsBuilder_.dispose();
            trustDomainsBuilder_ = null;
            trustDomains_ = other.trustDomains_;
            bitField0_ = (bitField0_ & ~0x00000001);
            trustDomainsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTrustDomainsFieldBuilder() : null;
          } else {
            trustDomainsBuilder_.addAllMessages(other.trustDomains_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain m =
                  input.readMessage(
                      io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.parser(),
                      extensionRegistry);
              if (trustDomainsBuilder_ == null) {
                ensureTrustDomainsIsMutable();
                trustDomains_.add(m);
              } else {
                trustDomainsBuilder_.addMessage(m);
              }
              break;
            } // case 10
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.util.List<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain> trustDomains_ =
      java.util.Collections.emptyList();
    private void ensureTrustDomainsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        trustDomains_ = new java.util.ArrayList<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain>(trustDomains_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder> trustDomainsBuilder_;

    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain> getTrustDomainsList() {
      if (trustDomainsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trustDomains_);
      } else {
        return trustDomainsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public int getTrustDomainsCount() {
      if (trustDomainsBuilder_ == null) {
        return trustDomains_.size();
      } else {
        return trustDomainsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain getTrustDomains(int index) {
      if (trustDomainsBuilder_ == null) {
        return trustDomains_.get(index);
      } else {
        return trustDomainsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setTrustDomains(
        int index, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain value) {
      if (trustDomainsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustDomainsIsMutable();
        trustDomains_.set(index, value);
        onChanged();
      } else {
        trustDomainsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder setTrustDomains(
        int index, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder builderForValue) {
      if (trustDomainsBuilder_ == null) {
        ensureTrustDomainsIsMutable();
        trustDomains_.set(index, builderForValue.build());
        onChanged();
      } else {
        trustDomainsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addTrustDomains(io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain value) {
      if (trustDomainsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustDomainsIsMutable();
        trustDomains_.add(value);
        onChanged();
      } else {
        trustDomainsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addTrustDomains(
        int index, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain value) {
      if (trustDomainsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustDomainsIsMutable();
        trustDomains_.add(index, value);
        onChanged();
      } else {
        trustDomainsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addTrustDomains(
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder builderForValue) {
      if (trustDomainsBuilder_ == null) {
        ensureTrustDomainsIsMutable();
        trustDomains_.add(builderForValue.build());
        onChanged();
      } else {
        trustDomainsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addTrustDomains(
        int index, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder builderForValue) {
      if (trustDomainsBuilder_ == null) {
        ensureTrustDomainsIsMutable();
        trustDomains_.add(index, builderForValue.build());
        onChanged();
      } else {
        trustDomainsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder addAllTrustDomains(
        java.lang.Iterable<? extends io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain> values) {
      if (trustDomainsBuilder_ == null) {
        ensureTrustDomainsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, trustDomains_);
        onChanged();
      } else {
        trustDomainsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder clearTrustDomains() {
      if (trustDomainsBuilder_ == null) {
        trustDomains_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        trustDomainsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public Builder removeTrustDomains(int index) {
      if (trustDomainsBuilder_ == null) {
        ensureTrustDomainsIsMutable();
        trustDomains_.remove(index);
        onChanged();
      } else {
        trustDomainsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder getTrustDomainsBuilder(
        int index) {
      return getTrustDomainsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder getTrustDomainsOrBuilder(
        int index) {
      if (trustDomainsBuilder_ == null) {
        return trustDomains_.get(index);  } else {
        return trustDomainsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder> 
         getTrustDomainsOrBuilderList() {
      if (trustDomainsBuilder_ != null) {
        return trustDomainsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trustDomains_);
      }
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder addTrustDomainsBuilder() {
      return getTrustDomainsFieldBuilder().addBuilder(
          io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.getDefaultInstance());
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder addTrustDomainsBuilder(
        int index) {
      return getTrustDomainsFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.getDefaultInstance());
    }
    /**
     * <pre>
     * This field specifies trust domains used for validating incoming X.509-SVID(s).
     * </pre>
     *
     * <code>repeated .envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain trust_domains = 1 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder> 
         getTrustDomainsBuilderList() {
      return getTrustDomainsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder> 
        getTrustDomainsFieldBuilder() {
      if (trustDomainsBuilder_ == null) {
        trustDomainsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomain.Builder, io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig.TrustDomainOrBuilder>(
                trustDomains_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        trustDomains_ = null;
      }
      return trustDomainsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)
  }

  // @@protoc_insertion_point(class_scope:envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig)
  private static final io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig();
  }

  public static io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SPIFFECertValidatorConfig>
      PARSER = new com.google.protobuf.AbstractParser<SPIFFECertValidatorConfig>() {
    @java.lang.Override
    public SPIFFECertValidatorConfig parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<SPIFFECertValidatorConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SPIFFECertValidatorConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SPIFFECertValidatorConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

