// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/extensions/filters/http/jwt_authn/v3/config.proto

// Protobuf Java Version: 3.25.1
package io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3;

/**
 * <pre>
 * This message specifies a Jwt requirement. An empty message means JWT verification is not
 * required. Here are some config examples:
 *
 * .. code-block:: yaml
 *
 *  # Example 1: not required with an empty message
 *
 *  # Example 2: require A
 *  provider_name: provider-A
 *
 *  # Example 3: require A or B
 *  requires_any:
 *    requirements:
 *      - provider_name: provider-A
 *      - provider_name: provider-B
 *
 *  # Example 4: require A and B
 *  requires_all:
 *    requirements:
 *      - provider_name: provider-A
 *      - provider_name: provider-B
 *
 *  # Example 5: require A and (B or C)
 *  requires_all:
 *    requirements:
 *      - provider_name: provider-A
 *      - requires_any:
 *        requirements:
 *          - provider_name: provider-B
 *          - provider_name: provider-C
 *
 *  # Example 6: require A or (B and C)
 *  requires_any:
 *    requirements:
 *      - provider_name: provider-A
 *      - requires_all:
 *        requirements:
 *          - provider_name: provider-B
 *          - provider_name: provider-C
 *
 *  # Example 7: A is optional (if token from A is provided, it must be valid, but also allows
 *  missing token.)
 *  requires_any:
 *    requirements:
 *    - provider_name: provider-A
 *    - allow_missing: {}
 *
 *  # Example 8: A is optional and B is required.
 *  requires_all:
 *    requirements:
 *    - requires_any:
 *        requirements:
 *        - provider_name: provider-A
 *        - allow_missing: {}
 *    - provider_name: provider-B
 *
 * [#next-free-field: 7]
 * </pre>
 *
 * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement}
 */
public final class JwtRequirement extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)
    JwtRequirementOrBuilder {
private static final long serialVersionUID = 0L;
  // Use JwtRequirement.newBuilder() to construct.
  private JwtRequirement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private JwtRequirement() {
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new JwtRequirement();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtRequirement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtRequirement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.Builder.class);
  }

  private int requiresTypeCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object requiresType_;
  public enum RequiresTypeCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROVIDER_NAME(1),
    PROVIDER_AND_AUDIENCES(2),
    REQUIRES_ANY(3),
    REQUIRES_ALL(4),
    ALLOW_MISSING_OR_FAILED(5),
    ALLOW_MISSING(6),
    REQUIRESTYPE_NOT_SET(0);
    private final int value;
    private RequiresTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequiresTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequiresTypeCase forNumber(int value) {
      switch (value) {
        case 1: return PROVIDER_NAME;
        case 2: return PROVIDER_AND_AUDIENCES;
        case 3: return REQUIRES_ANY;
        case 4: return REQUIRES_ALL;
        case 5: return ALLOW_MISSING_OR_FAILED;
        case 6: return ALLOW_MISSING;
        case 0: return REQUIRESTYPE_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public RequiresTypeCase
  getRequiresTypeCase() {
    return RequiresTypeCase.forNumber(
        requiresTypeCase_);
  }

  public static final int PROVIDER_NAME_FIELD_NUMBER = 1;
  /**
   * <pre>
   * Specify a required provider name.
   * </pre>
   *
   * <code>string provider_name = 1;</code>
   * @return Whether the providerName field is set.
   */
  public boolean hasProviderName() {
    return requiresTypeCase_ == 1;
  }
  /**
   * <pre>
   * Specify a required provider name.
   * </pre>
   *
   * <code>string provider_name = 1;</code>
   * @return The providerName.
   */
  public java.lang.String getProviderName() {
    java.lang.Object ref = "";
    if (requiresTypeCase_ == 1) {
      ref = requiresType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (requiresTypeCase_ == 1) {
        requiresType_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Specify a required provider name.
   * </pre>
   *
   * <code>string provider_name = 1;</code>
   * @return The bytes for providerName.
   */
  public com.google.protobuf.ByteString
      getProviderNameBytes() {
    java.lang.Object ref = "";
    if (requiresTypeCase_ == 1) {
      ref = requiresType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (requiresTypeCase_ == 1) {
        requiresType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROVIDER_AND_AUDIENCES_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Specify a required provider with audiences.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
   * @return Whether the providerAndAudiences field is set.
   */
  @java.lang.Override
  public boolean hasProviderAndAudiences() {
    return requiresTypeCase_ == 2;
  }
  /**
   * <pre>
   * Specify a required provider with audiences.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
   * @return The providerAndAudiences.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences getProviderAndAudiences() {
    if (requiresTypeCase_ == 2) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify a required provider with audiences.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiencesOrBuilder getProviderAndAudiencesOrBuilder() {
    if (requiresTypeCase_ == 2) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
  }

  public static final int REQUIRES_ANY_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are OR-ed.
   * If any one of them passes, the result is passed.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
   * @return Whether the requiresAny field is set.
   */
  @java.lang.Override
  public boolean hasRequiresAny() {
    return requiresTypeCase_ == 3;
  }
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are OR-ed.
   * If any one of them passes, the result is passed.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
   * @return The requiresAny.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList getRequiresAny() {
    if (requiresTypeCase_ == 3) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are OR-ed.
   * If any one of them passes, the result is passed.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrListOrBuilder getRequiresAnyOrBuilder() {
    if (requiresTypeCase_ == 3) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
  }

  public static final int REQUIRES_ALL_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are AND-ed.
   * All of them must pass, if one of them fails or missing, it fails.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
   * @return Whether the requiresAll field is set.
   */
  @java.lang.Override
  public boolean hasRequiresAll() {
    return requiresTypeCase_ == 4;
  }
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are AND-ed.
   * All of them must pass, if one of them fails or missing, it fails.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
   * @return The requiresAll.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList getRequiresAll() {
    if (requiresTypeCase_ == 4) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify list of JwtRequirement. Their results are AND-ed.
   * All of them must pass, if one of them fails or missing, it fails.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndListOrBuilder getRequiresAllOrBuilder() {
    if (requiresTypeCase_ == 4) {
       return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_;
    }
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
  }

  public static final int ALLOW_MISSING_OR_FAILED_FIELD_NUMBER = 5;
  /**
   * <pre>
   * The requirement is always satisfied even if JWT is missing or the JWT
   * verification fails. A typical usage is: this filter is used to only verify
   * JWTs and pass the verified JWT payloads to another filter, the other filter
   * will make decision. In this mode, all JWT tokens will be verified.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
   * @return Whether the allowMissingOrFailed field is set.
   */
  @java.lang.Override
  public boolean hasAllowMissingOrFailed() {
    return requiresTypeCase_ == 5;
  }
  /**
   * <pre>
   * The requirement is always satisfied even if JWT is missing or the JWT
   * verification fails. A typical usage is: this filter is used to only verify
   * JWTs and pass the verified JWT payloads to another filter, the other filter
   * will make decision. In this mode, all JWT tokens will be verified.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
   * @return The allowMissingOrFailed.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getAllowMissingOrFailed() {
    if (requiresTypeCase_ == 5) {
       return (com.google.protobuf.Empty) requiresType_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   * <pre>
   * The requirement is always satisfied even if JWT is missing or the JWT
   * verification fails. A typical usage is: this filter is used to only verify
   * JWTs and pass the verified JWT payloads to another filter, the other filter
   * will make decision. In this mode, all JWT tokens will be verified.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getAllowMissingOrFailedOrBuilder() {
    if (requiresTypeCase_ == 5) {
       return (com.google.protobuf.Empty) requiresType_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  public static final int ALLOW_MISSING_FIELD_NUMBER = 6;
  /**
   * <pre>
   * The requirement is satisfied if JWT is missing, but failed if JWT is
   * presented but invalid. Similar to allow_missing_or_failed, this is used
   * to only verify JWTs and pass the verified payload to another filter. The
   * different is this mode will reject requests with invalid tokens.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing = 6;</code>
   * @return Whether the allowMissing field is set.
   */
  @java.lang.Override
  public boolean hasAllowMissing() {
    return requiresTypeCase_ == 6;
  }
  /**
   * <pre>
   * The requirement is satisfied if JWT is missing, but failed if JWT is
   * presented but invalid. Similar to allow_missing_or_failed, this is used
   * to only verify JWTs and pass the verified payload to another filter. The
   * different is this mode will reject requests with invalid tokens.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing = 6;</code>
   * @return The allowMissing.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getAllowMissing() {
    if (requiresTypeCase_ == 6) {
       return (com.google.protobuf.Empty) requiresType_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   * <pre>
   * The requirement is satisfied if JWT is missing, but failed if JWT is
   * presented but invalid. Similar to allow_missing_or_failed, this is used
   * to only verify JWTs and pass the verified payload to another filter. The
   * different is this mode will reject requests with invalid tokens.
   * </pre>
   *
   * <code>.google.protobuf.Empty allow_missing = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getAllowMissingOrBuilder() {
    if (requiresTypeCase_ == 6) {
       return (com.google.protobuf.Empty) requiresType_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (requiresTypeCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requiresType_);
    }
    if (requiresTypeCase_ == 2) {
      output.writeMessage(2, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_);
    }
    if (requiresTypeCase_ == 3) {
      output.writeMessage(3, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_);
    }
    if (requiresTypeCase_ == 4) {
      output.writeMessage(4, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_);
    }
    if (requiresTypeCase_ == 5) {
      output.writeMessage(5, (com.google.protobuf.Empty) requiresType_);
    }
    if (requiresTypeCase_ == 6) {
      output.writeMessage(6, (com.google.protobuf.Empty) requiresType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (requiresTypeCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requiresType_);
    }
    if (requiresTypeCase_ == 2) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_);
    }
    if (requiresTypeCase_ == 3) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_);
    }
    if (requiresTypeCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_);
    }
    if (requiresTypeCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.google.protobuf.Empty) requiresType_);
    }
    if (requiresTypeCase_ == 6) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, (com.google.protobuf.Empty) requiresType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement other = (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement) obj;

    if (!getRequiresTypeCase().equals(other.getRequiresTypeCase())) return false;
    switch (requiresTypeCase_) {
      case 1:
        if (!getProviderName()
            .equals(other.getProviderName())) return false;
        break;
      case 2:
        if (!getProviderAndAudiences()
            .equals(other.getProviderAndAudiences())) return false;
        break;
      case 3:
        if (!getRequiresAny()
            .equals(other.getRequiresAny())) return false;
        break;
      case 4:
        if (!getRequiresAll()
            .equals(other.getRequiresAll())) return false;
        break;
      case 5:
        if (!getAllowMissingOrFailed()
            .equals(other.getAllowMissingOrFailed())) return false;
        break;
      case 6:
        if (!getAllowMissing()
            .equals(other.getAllowMissing())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (requiresTypeCase_) {
      case 1:
        hash = (37 * hash) + PROVIDER_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getProviderName().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PROVIDER_AND_AUDIENCES_FIELD_NUMBER;
        hash = (53 * hash) + getProviderAndAudiences().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REQUIRES_ANY_FIELD_NUMBER;
        hash = (53 * hash) + getRequiresAny().hashCode();
        break;
      case 4:
        hash = (37 * hash) + REQUIRES_ALL_FIELD_NUMBER;
        hash = (53 * hash) + getRequiresAll().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ALLOW_MISSING_OR_FAILED_FIELD_NUMBER;
        hash = (53 * hash) + getAllowMissingOrFailed().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ALLOW_MISSING_FIELD_NUMBER;
        hash = (53 * hash) + getAllowMissing().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This message specifies a Jwt requirement. An empty message means JWT verification is not
   * required. Here are some config examples:
   *
   * .. code-block:: yaml
   *
   *  # Example 1: not required with an empty message
   *
   *  # Example 2: require A
   *  provider_name: provider-A
   *
   *  # Example 3: require A or B
   *  requires_any:
   *    requirements:
   *      - provider_name: provider-A
   *      - provider_name: provider-B
   *
   *  # Example 4: require A and B
   *  requires_all:
   *    requirements:
   *      - provider_name: provider-A
   *      - provider_name: provider-B
   *
   *  # Example 5: require A and (B or C)
   *  requires_all:
   *    requirements:
   *      - provider_name: provider-A
   *      - requires_any:
   *        requirements:
   *          - provider_name: provider-B
   *          - provider_name: provider-C
   *
   *  # Example 6: require A or (B and C)
   *  requires_any:
   *    requirements:
   *      - provider_name: provider-A
   *      - requires_all:
   *        requirements:
   *          - provider_name: provider-B
   *          - provider_name: provider-C
   *
   *  # Example 7: A is optional (if token from A is provided, it must be valid, but also allows
   *  missing token.)
   *  requires_any:
   *    requirements:
   *    - provider_name: provider-A
   *    - allow_missing: {}
   *
   *  # Example 8: A is optional and B is required.
   *  requires_all:
   *    requirements:
   *    - requires_any:
   *        requirements:
   *        - provider_name: provider-A
   *        - allow_missing: {}
   *    - provider_name: provider-B
   *
   * [#next-free-field: 7]
   * </pre>
   *
   * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtRequirement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtRequirement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (providerAndAudiencesBuilder_ != null) {
        providerAndAudiencesBuilder_.clear();
      }
      if (requiresAnyBuilder_ != null) {
        requiresAnyBuilder_.clear();
      }
      if (requiresAllBuilder_ != null) {
        requiresAllBuilder_.clear();
      }
      if (allowMissingOrFailedBuilder_ != null) {
        allowMissingOrFailedBuilder_.clear();
      }
      if (allowMissingBuilder_ != null) {
        allowMissingBuilder_.clear();
      }
      requiresTypeCase_ = 0;
      requiresType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtRequirement_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement getDefaultInstanceForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement build() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement buildPartial() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement result = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement result) {
      result.requiresTypeCase_ = requiresTypeCase_;
      result.requiresType_ = this.requiresType_;
      if (requiresTypeCase_ == 2 &&
          providerAndAudiencesBuilder_ != null) {
        result.requiresType_ = providerAndAudiencesBuilder_.build();
      }
      if (requiresTypeCase_ == 3 &&
          requiresAnyBuilder_ != null) {
        result.requiresType_ = requiresAnyBuilder_.build();
      }
      if (requiresTypeCase_ == 4 &&
          requiresAllBuilder_ != null) {
        result.requiresType_ = requiresAllBuilder_.build();
      }
      if (requiresTypeCase_ == 5 &&
          allowMissingOrFailedBuilder_ != null) {
        result.requiresType_ = allowMissingOrFailedBuilder_.build();
      }
      if (requiresTypeCase_ == 6 &&
          allowMissingBuilder_ != null) {
        result.requiresType_ = allowMissingBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement) {
        return mergeFrom((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement other) {
      if (other == io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.getDefaultInstance()) return this;
      switch (other.getRequiresTypeCase()) {
        case PROVIDER_NAME: {
          requiresTypeCase_ = 1;
          requiresType_ = other.requiresType_;
          onChanged();
          break;
        }
        case PROVIDER_AND_AUDIENCES: {
          mergeProviderAndAudiences(other.getProviderAndAudiences());
          break;
        }
        case REQUIRES_ANY: {
          mergeRequiresAny(other.getRequiresAny());
          break;
        }
        case REQUIRES_ALL: {
          mergeRequiresAll(other.getRequiresAll());
          break;
        }
        case ALLOW_MISSING_OR_FAILED: {
          mergeAllowMissingOrFailed(other.getAllowMissingOrFailed());
          break;
        }
        case ALLOW_MISSING: {
          mergeAllowMissing(other.getAllowMissing());
          break;
        }
        case REQUIRESTYPE_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();
              requiresTypeCase_ = 1;
              requiresType_ = s;
              break;
            } // case 10
            case 18: {
              input.readMessage(
                  getProviderAndAudiencesFieldBuilder().getBuilder(),
                  extensionRegistry);
              requiresTypeCase_ = 2;
              break;
            } // case 18
            case 26: {
              input.readMessage(
                  getRequiresAnyFieldBuilder().getBuilder(),
                  extensionRegistry);
              requiresTypeCase_ = 3;
              break;
            } // case 26
            case 34: {
              input.readMessage(
                  getRequiresAllFieldBuilder().getBuilder(),
                  extensionRegistry);
              requiresTypeCase_ = 4;
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getAllowMissingOrFailedFieldBuilder().getBuilder(),
                  extensionRegistry);
              requiresTypeCase_ = 5;
              break;
            } // case 42
            case 50: {
              input.readMessage(
                  getAllowMissingFieldBuilder().getBuilder(),
                  extensionRegistry);
              requiresTypeCase_ = 6;
              break;
            } // case 50
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int requiresTypeCase_ = 0;
    private java.lang.Object requiresType_;
    public RequiresTypeCase
        getRequiresTypeCase() {
      return RequiresTypeCase.forNumber(
          requiresTypeCase_);
    }

    public Builder clearRequiresType() {
      requiresTypeCase_ = 0;
      requiresType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @return Whether the providerName field is set.
     */
    @java.lang.Override
    public boolean hasProviderName() {
      return requiresTypeCase_ == 1;
    }
    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @return The providerName.
     */
    @java.lang.Override
    public java.lang.String getProviderName() {
      java.lang.Object ref = "";
      if (requiresTypeCase_ == 1) {
        ref = requiresType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (requiresTypeCase_ == 1) {
          requiresType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @return The bytes for providerName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getProviderNameBytes() {
      java.lang.Object ref = "";
      if (requiresTypeCase_ == 1) {
        ref = requiresType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (requiresTypeCase_ == 1) {
          requiresType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @param value The providerName to set.
     * @return This builder for chaining.
     */
    public Builder setProviderName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      requiresTypeCase_ = 1;
      requiresType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearProviderName() {
      if (requiresTypeCase_ == 1) {
        requiresTypeCase_ = 0;
        requiresType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a required provider name.
     * </pre>
     *
     * <code>string provider_name = 1;</code>
     * @param value The bytes for providerName to set.
     * @return This builder for chaining.
     */
    public Builder setProviderNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      requiresTypeCase_ = 1;
      requiresType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiencesOrBuilder> providerAndAudiencesBuilder_;
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     * @return Whether the providerAndAudiences field is set.
     */
    @java.lang.Override
    public boolean hasProviderAndAudiences() {
      return requiresTypeCase_ == 2;
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     * @return The providerAndAudiences.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences getProviderAndAudiences() {
      if (providerAndAudiencesBuilder_ == null) {
        if (requiresTypeCase_ == 2) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
      } else {
        if (requiresTypeCase_ == 2) {
          return providerAndAudiencesBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    public Builder setProviderAndAudiences(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences value) {
      if (providerAndAudiencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requiresType_ = value;
        onChanged();
      } else {
        providerAndAudiencesBuilder_.setMessage(value);
      }
      requiresTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    public Builder setProviderAndAudiences(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.Builder builderForValue) {
      if (providerAndAudiencesBuilder_ == null) {
        requiresType_ = builderForValue.build();
        onChanged();
      } else {
        providerAndAudiencesBuilder_.setMessage(builderForValue.build());
      }
      requiresTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    public Builder mergeProviderAndAudiences(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences value) {
      if (providerAndAudiencesBuilder_ == null) {
        if (requiresTypeCase_ == 2 &&
            requiresType_ != io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance()) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.newBuilder((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_)
              .mergeFrom(value).buildPartial();
        } else {
          requiresType_ = value;
        }
        onChanged();
      } else {
        if (requiresTypeCase_ == 2) {
          providerAndAudiencesBuilder_.mergeFrom(value);
        } else {
          providerAndAudiencesBuilder_.setMessage(value);
        }
      }
      requiresTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    public Builder clearProviderAndAudiences() {
      if (providerAndAudiencesBuilder_ == null) {
        if (requiresTypeCase_ == 2) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
          onChanged();
        }
      } else {
        if (requiresTypeCase_ == 2) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
        }
        providerAndAudiencesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.Builder getProviderAndAudiencesBuilder() {
      return getProviderAndAudiencesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiencesOrBuilder getProviderAndAudiencesOrBuilder() {
      if ((requiresTypeCase_ == 2) && (providerAndAudiencesBuilder_ != null)) {
        return providerAndAudiencesBuilder_.getMessageOrBuilder();
      } else {
        if (requiresTypeCase_ == 2) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a required provider with audiences.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences provider_and_audiences = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiencesOrBuilder> 
        getProviderAndAudiencesFieldBuilder() {
      if (providerAndAudiencesBuilder_ == null) {
        if (!(requiresTypeCase_ == 2)) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.getDefaultInstance();
        }
        providerAndAudiencesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiencesOrBuilder>(
                (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences) requiresType_,
                getParentForChildren(),
                isClean());
        requiresType_ = null;
      }
      requiresTypeCase_ = 2;
      onChanged();
      return providerAndAudiencesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrListOrBuilder> requiresAnyBuilder_;
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     * @return Whether the requiresAny field is set.
     */
    @java.lang.Override
    public boolean hasRequiresAny() {
      return requiresTypeCase_ == 3;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     * @return The requiresAny.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList getRequiresAny() {
      if (requiresAnyBuilder_ == null) {
        if (requiresTypeCase_ == 3) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
      } else {
        if (requiresTypeCase_ == 3) {
          return requiresAnyBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    public Builder setRequiresAny(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList value) {
      if (requiresAnyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requiresType_ = value;
        onChanged();
      } else {
        requiresAnyBuilder_.setMessage(value);
      }
      requiresTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    public Builder setRequiresAny(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.Builder builderForValue) {
      if (requiresAnyBuilder_ == null) {
        requiresType_ = builderForValue.build();
        onChanged();
      } else {
        requiresAnyBuilder_.setMessage(builderForValue.build());
      }
      requiresTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    public Builder mergeRequiresAny(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList value) {
      if (requiresAnyBuilder_ == null) {
        if (requiresTypeCase_ == 3 &&
            requiresType_ != io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance()) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.newBuilder((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_)
              .mergeFrom(value).buildPartial();
        } else {
          requiresType_ = value;
        }
        onChanged();
      } else {
        if (requiresTypeCase_ == 3) {
          requiresAnyBuilder_.mergeFrom(value);
        } else {
          requiresAnyBuilder_.setMessage(value);
        }
      }
      requiresTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    public Builder clearRequiresAny() {
      if (requiresAnyBuilder_ == null) {
        if (requiresTypeCase_ == 3) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
          onChanged();
        }
      } else {
        if (requiresTypeCase_ == 3) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
        }
        requiresAnyBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.Builder getRequiresAnyBuilder() {
      return getRequiresAnyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrListOrBuilder getRequiresAnyOrBuilder() {
      if ((requiresTypeCase_ == 3) && (requiresAnyBuilder_ != null)) {
        return requiresAnyBuilder_.getMessageOrBuilder();
      } else {
        if (requiresTypeCase_ == 3) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are OR-ed.
     * If any one of them passes, the result is passed.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList requires_any = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrListOrBuilder> 
        getRequiresAnyFieldBuilder() {
      if (requiresAnyBuilder_ == null) {
        if (!(requiresTypeCase_ == 3)) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.getDefaultInstance();
        }
        requiresAnyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrListOrBuilder>(
                (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList) requiresType_,
                getParentForChildren(),
                isClean());
        requiresType_ = null;
      }
      requiresTypeCase_ = 3;
      onChanged();
      return requiresAnyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndListOrBuilder> requiresAllBuilder_;
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     * @return Whether the requiresAll field is set.
     */
    @java.lang.Override
    public boolean hasRequiresAll() {
      return requiresTypeCase_ == 4;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     * @return The requiresAll.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList getRequiresAll() {
      if (requiresAllBuilder_ == null) {
        if (requiresTypeCase_ == 4) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
      } else {
        if (requiresTypeCase_ == 4) {
          return requiresAllBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    public Builder setRequiresAll(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList value) {
      if (requiresAllBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requiresType_ = value;
        onChanged();
      } else {
        requiresAllBuilder_.setMessage(value);
      }
      requiresTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    public Builder setRequiresAll(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.Builder builderForValue) {
      if (requiresAllBuilder_ == null) {
        requiresType_ = builderForValue.build();
        onChanged();
      } else {
        requiresAllBuilder_.setMessage(builderForValue.build());
      }
      requiresTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    public Builder mergeRequiresAll(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList value) {
      if (requiresAllBuilder_ == null) {
        if (requiresTypeCase_ == 4 &&
            requiresType_ != io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance()) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.newBuilder((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_)
              .mergeFrom(value).buildPartial();
        } else {
          requiresType_ = value;
        }
        onChanged();
      } else {
        if (requiresTypeCase_ == 4) {
          requiresAllBuilder_.mergeFrom(value);
        } else {
          requiresAllBuilder_.setMessage(value);
        }
      }
      requiresTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    public Builder clearRequiresAll() {
      if (requiresAllBuilder_ == null) {
        if (requiresTypeCase_ == 4) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
          onChanged();
        }
      } else {
        if (requiresTypeCase_ == 4) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
        }
        requiresAllBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.Builder getRequiresAllBuilder() {
      return getRequiresAllFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndListOrBuilder getRequiresAllOrBuilder() {
      if ((requiresTypeCase_ == 4) && (requiresAllBuilder_ != null)) {
        return requiresAllBuilder_.getMessageOrBuilder();
      } else {
        if (requiresTypeCase_ == 4) {
          return (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_;
        }
        return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify list of JwtRequirement. Their results are AND-ed.
     * All of them must pass, if one of them fails or missing, it fails.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList requires_all = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndListOrBuilder> 
        getRequiresAllFieldBuilder() {
      if (requiresAllBuilder_ == null) {
        if (!(requiresTypeCase_ == 4)) {
          requiresType_ = io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.getDefaultInstance();
        }
        requiresAllBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndListOrBuilder>(
                (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList) requiresType_,
                getParentForChildren(),
                isClean());
        requiresType_ = null;
      }
      requiresTypeCase_ = 4;
      onChanged();
      return requiresAllBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> allowMissingOrFailedBuilder_;
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     * @return Whether the allowMissingOrFailed field is set.
     */
    @java.lang.Override
    public boolean hasAllowMissingOrFailed() {
      return requiresTypeCase_ == 5;
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     * @return The allowMissingOrFailed.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getAllowMissingOrFailed() {
      if (allowMissingOrFailedBuilder_ == null) {
        if (requiresTypeCase_ == 5) {
          return (com.google.protobuf.Empty) requiresType_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (requiresTypeCase_ == 5) {
          return allowMissingOrFailedBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    public Builder setAllowMissingOrFailed(com.google.protobuf.Empty value) {
      if (allowMissingOrFailedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requiresType_ = value;
        onChanged();
      } else {
        allowMissingOrFailedBuilder_.setMessage(value);
      }
      requiresTypeCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    public Builder setAllowMissingOrFailed(
        com.google.protobuf.Empty.Builder builderForValue) {
      if (allowMissingOrFailedBuilder_ == null) {
        requiresType_ = builderForValue.build();
        onChanged();
      } else {
        allowMissingOrFailedBuilder_.setMessage(builderForValue.build());
      }
      requiresTypeCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    public Builder mergeAllowMissingOrFailed(com.google.protobuf.Empty value) {
      if (allowMissingOrFailedBuilder_ == null) {
        if (requiresTypeCase_ == 5 &&
            requiresType_ != com.google.protobuf.Empty.getDefaultInstance()) {
          requiresType_ = com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) requiresType_)
              .mergeFrom(value).buildPartial();
        } else {
          requiresType_ = value;
        }
        onChanged();
      } else {
        if (requiresTypeCase_ == 5) {
          allowMissingOrFailedBuilder_.mergeFrom(value);
        } else {
          allowMissingOrFailedBuilder_.setMessage(value);
        }
      }
      requiresTypeCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    public Builder clearAllowMissingOrFailed() {
      if (allowMissingOrFailedBuilder_ == null) {
        if (requiresTypeCase_ == 5) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
          onChanged();
        }
      } else {
        if (requiresTypeCase_ == 5) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
        }
        allowMissingOrFailedBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    public com.google.protobuf.Empty.Builder getAllowMissingOrFailedBuilder() {
      return getAllowMissingOrFailedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getAllowMissingOrFailedOrBuilder() {
      if ((requiresTypeCase_ == 5) && (allowMissingOrFailedBuilder_ != null)) {
        return allowMissingOrFailedBuilder_.getMessageOrBuilder();
      } else {
        if (requiresTypeCase_ == 5) {
          return (com.google.protobuf.Empty) requiresType_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The requirement is always satisfied even if JWT is missing or the JWT
     * verification fails. A typical usage is: this filter is used to only verify
     * JWTs and pass the verified JWT payloads to another filter, the other filter
     * will make decision. In this mode, all JWT tokens will be verified.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing_or_failed = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> 
        getAllowMissingOrFailedFieldBuilder() {
      if (allowMissingOrFailedBuilder_ == null) {
        if (!(requiresTypeCase_ == 5)) {
          requiresType_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        allowMissingOrFailedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) requiresType_,
                getParentForChildren(),
                isClean());
        requiresType_ = null;
      }
      requiresTypeCase_ = 5;
      onChanged();
      return allowMissingOrFailedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> allowMissingBuilder_;
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     * @return Whether the allowMissing field is set.
     */
    @java.lang.Override
    public boolean hasAllowMissing() {
      return requiresTypeCase_ == 6;
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     * @return The allowMissing.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getAllowMissing() {
      if (allowMissingBuilder_ == null) {
        if (requiresTypeCase_ == 6) {
          return (com.google.protobuf.Empty) requiresType_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (requiresTypeCase_ == 6) {
          return allowMissingBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    public Builder setAllowMissing(com.google.protobuf.Empty value) {
      if (allowMissingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requiresType_ = value;
        onChanged();
      } else {
        allowMissingBuilder_.setMessage(value);
      }
      requiresTypeCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    public Builder setAllowMissing(
        com.google.protobuf.Empty.Builder builderForValue) {
      if (allowMissingBuilder_ == null) {
        requiresType_ = builderForValue.build();
        onChanged();
      } else {
        allowMissingBuilder_.setMessage(builderForValue.build());
      }
      requiresTypeCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    public Builder mergeAllowMissing(com.google.protobuf.Empty value) {
      if (allowMissingBuilder_ == null) {
        if (requiresTypeCase_ == 6 &&
            requiresType_ != com.google.protobuf.Empty.getDefaultInstance()) {
          requiresType_ = com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) requiresType_)
              .mergeFrom(value).buildPartial();
        } else {
          requiresType_ = value;
        }
        onChanged();
      } else {
        if (requiresTypeCase_ == 6) {
          allowMissingBuilder_.mergeFrom(value);
        } else {
          allowMissingBuilder_.setMessage(value);
        }
      }
      requiresTypeCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    public Builder clearAllowMissing() {
      if (allowMissingBuilder_ == null) {
        if (requiresTypeCase_ == 6) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
          onChanged();
        }
      } else {
        if (requiresTypeCase_ == 6) {
          requiresTypeCase_ = 0;
          requiresType_ = null;
        }
        allowMissingBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    public com.google.protobuf.Empty.Builder getAllowMissingBuilder() {
      return getAllowMissingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getAllowMissingOrBuilder() {
      if ((requiresTypeCase_ == 6) && (allowMissingBuilder_ != null)) {
        return allowMissingBuilder_.getMessageOrBuilder();
      } else {
        if (requiresTypeCase_ == 6) {
          return (com.google.protobuf.Empty) requiresType_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The requirement is satisfied if JWT is missing, but failed if JWT is
     * presented but invalid. Similar to allow_missing_or_failed, this is used
     * to only verify JWTs and pass the verified payload to another filter. The
     * different is this mode will reject requests with invalid tokens.
     * </pre>
     *
     * <code>.google.protobuf.Empty allow_missing = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> 
        getAllowMissingFieldBuilder() {
      if (allowMissingBuilder_ == null) {
        if (!(requiresTypeCase_ == 6)) {
          requiresType_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        allowMissingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) requiresType_,
                getParentForChildren(),
                isClean());
        requiresType_ = null;
      }
      requiresTypeCase_ = 6;
      onChanged();
      return allowMissingBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)
  }

  // @@protoc_insertion_point(class_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement)
  private static final io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement();
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JwtRequirement>
      PARSER = new com.google.protobuf.AbstractParser<JwtRequirement>() {
    @java.lang.Override
    public JwtRequirement parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<JwtRequirement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JwtRequirement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

