// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/service/discovery/v4alpha/discovery.proto

package io.envoyproxy.envoy.service.discovery.v4alpha;

/**
 * <pre>
 * DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
 * endpoint for Delta xDS.
 * With Delta xDS, the DeltaDiscoveryResponses do not need to include a full
 * snapshot of the tracked resources. Instead, DeltaDiscoveryResponses are a
 * diff to the state of a xDS client.
 * In Delta XDS there are per-resource versions, which allow tracking state at
 * the resource granularity.
 * An xDS Delta session is always in the context of a gRPC bidirectional
 * stream. This allows the xDS server to keep track of the state of xDS clients
 * connected to it.
 * In Delta xDS the nonce field is required and used to pair
 * DeltaDiscoveryResponse to a DeltaDiscoveryRequest ACK or NACK.
 * Optionally, a response message level system_version_info is present for
 * debugging purposes only.
 * DeltaDiscoveryRequest plays two independent roles. Any DeltaDiscoveryRequest
 * can be either or both of: [1] informing the server of what resources the
 * client has gained/lost interest in (using resource_names_subscribe and
 * resource_names_unsubscribe), or [2] (N)ACKing an earlier resource update from
 * the server (using response_nonce, with presence of error_detail making it a NACK).
 * Additionally, the first message (for a given type_url) of a reconnected gRPC stream
 * has a third role: informing the server of the resources (and their versions)
 * that the client already possesses, using the initial_resource_versions field.
 * As with state-of-the-world, when multiple resource types are multiplexed (ADS),
 * all requests/acknowledgments/updates are logically walled off by type_url:
 * a Cluster ACK exists in a completely separate world from a prior Route NACK.
 * In particular, initial_resource_versions being sent at the "start" of every
 * gRPC stream actually entails a message for each type_url, each with its own
 * initial_resource_versions.
 * [#next-free-field: 8]
 * </pre>
 *
 * Protobuf type {@code envoy.service.discovery.v4alpha.DeltaDiscoveryRequest}
 */
public  final class DeltaDiscoveryRequest extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)
    DeltaDiscoveryRequestOrBuilder {
private static final long serialVersionUID = 0L;
  // Use DeltaDiscoveryRequest.newBuilder() to construct.
  private DeltaDiscoveryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private DeltaDiscoveryRequest() {
    typeUrl_ = "";
    resourceNamesSubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    resourceNamesUnsubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    responseNonce_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new DeltaDiscoveryRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private DeltaDiscoveryRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            io.envoyproxy.envoy.config.core.v4alpha.Node.Builder subBuilder = null;
            if (node_ != null) {
              subBuilder = node_.toBuilder();
            }
            node_ = input.readMessage(io.envoyproxy.envoy.config.core.v4alpha.Node.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(node_);
              node_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            typeUrl_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              resourceNamesSubscribe_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000001;
            }
            resourceNamesSubscribe_.add(s);
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              resourceNamesUnsubscribe_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            resourceNamesUnsubscribe_.add(s);
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000004) != 0)) {
              initialResourceVersions_ = com.google.protobuf.MapField.newMapField(
                  InitialResourceVersionsDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000004;
            }
            com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
            initialResourceVersions__ = input.readMessage(
                InitialResourceVersionsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            initialResourceVersions_.getMutableMap().put(
                initialResourceVersions__.getKey(), initialResourceVersions__.getValue());
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            responseNonce_ = s;
            break;
          }
          case 58: {
            com.google.rpc.Status.Builder subBuilder = null;
            if (errorDetail_ != null) {
              subBuilder = errorDetail_.toBuilder();
            }
            errorDetail_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(errorDetail_);
              errorDetail_ = subBuilder.buildPartial();
            }

            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        resourceNamesSubscribe_ = resourceNamesSubscribe_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        resourceNamesUnsubscribe_ = resourceNamesUnsubscribe_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 5:
        return internalGetInitialResourceVersions();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.class, io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.Builder.class);
  }

  public static final int NODE_FIELD_NUMBER = 1;
  private io.envoyproxy.envoy.config.core.v4alpha.Node node_;
  /**
   * <pre>
   * The node making the request.
   * </pre>
   *
   * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
   */
  public boolean hasNode() {
    return node_ != null;
  }
  /**
   * <pre>
   * The node making the request.
   * </pre>
   *
   * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.Node getNode() {
    return node_ == null ? io.envoyproxy.envoy.config.core.v4alpha.Node.getDefaultInstance() : node_;
  }
  /**
   * <pre>
   * The node making the request.
   * </pre>
   *
   * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.NodeOrBuilder getNodeOrBuilder() {
    return getNode();
  }

  public static final int TYPE_URL_FIELD_NUMBER = 2;
  private volatile java.lang.Object typeUrl_;
  /**
   * <pre>
   * Type of the resource that is being requested, e.g.
   * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
   * resources are only referenced via *xds_resource_subscribe* and
   * *xds_resources_unsubscribe*.
   * </pre>
   *
   * <code>string type_url = 2;</code>
   */
  public java.lang.String getTypeUrl() {
    java.lang.Object ref = typeUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      typeUrl_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Type of the resource that is being requested, e.g.
   * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
   * resources are only referenced via *xds_resource_subscribe* and
   * *xds_resources_unsubscribe*.
   * </pre>
   *
   * <code>string type_url = 2;</code>
   */
  public com.google.protobuf.ByteString
      getTypeUrlBytes() {
    java.lang.Object ref = typeUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      typeUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_NAMES_SUBSCRIBE_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList resourceNamesSubscribe_;
  /**
   * <pre>
   * DeltaDiscoveryRequests allow the client to add or remove individual
   * resources to the set of tracked resources in the context of a stream.
   * All resource names in the resource_names_subscribe list are added to the
   * set of tracked resources and all resource names in the resource_names_unsubscribe
   * list are removed from the set of tracked resources.
   * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
   * resource_names_unsubscribe list simply means that no resources are to be
   * added or removed to the resource list.
   * *Like* state-of-the-world xDS, the server must send updates for all tracked
   * resources, but can also send updates for resources the client has not subscribed to.
   * NOTE: the server must respond with all resources listed in resource_names_subscribe,
   * even if it believes the client has the most recent version of them. The reason:
   * the client may have dropped them, but then regained interest before it had a chance
   * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
   * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
   * and initial_resource_versions.
   * A list of Resource names to add to the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_subscribe = 3;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getResourceNamesSubscribeList() {
    return resourceNamesSubscribe_;
  }
  /**
   * <pre>
   * DeltaDiscoveryRequests allow the client to add or remove individual
   * resources to the set of tracked resources in the context of a stream.
   * All resource names in the resource_names_subscribe list are added to the
   * set of tracked resources and all resource names in the resource_names_unsubscribe
   * list are removed from the set of tracked resources.
   * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
   * resource_names_unsubscribe list simply means that no resources are to be
   * added or removed to the resource list.
   * *Like* state-of-the-world xDS, the server must send updates for all tracked
   * resources, but can also send updates for resources the client has not subscribed to.
   * NOTE: the server must respond with all resources listed in resource_names_subscribe,
   * even if it believes the client has the most recent version of them. The reason:
   * the client may have dropped them, but then regained interest before it had a chance
   * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
   * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
   * and initial_resource_versions.
   * A list of Resource names to add to the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_subscribe = 3;</code>
   */
  public int getResourceNamesSubscribeCount() {
    return resourceNamesSubscribe_.size();
  }
  /**
   * <pre>
   * DeltaDiscoveryRequests allow the client to add or remove individual
   * resources to the set of tracked resources in the context of a stream.
   * All resource names in the resource_names_subscribe list are added to the
   * set of tracked resources and all resource names in the resource_names_unsubscribe
   * list are removed from the set of tracked resources.
   * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
   * resource_names_unsubscribe list simply means that no resources are to be
   * added or removed to the resource list.
   * *Like* state-of-the-world xDS, the server must send updates for all tracked
   * resources, but can also send updates for resources the client has not subscribed to.
   * NOTE: the server must respond with all resources listed in resource_names_subscribe,
   * even if it believes the client has the most recent version of them. The reason:
   * the client may have dropped them, but then regained interest before it had a chance
   * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
   * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
   * and initial_resource_versions.
   * A list of Resource names to add to the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_subscribe = 3;</code>
   */
  public java.lang.String getResourceNamesSubscribe(int index) {
    return resourceNamesSubscribe_.get(index);
  }
  /**
   * <pre>
   * DeltaDiscoveryRequests allow the client to add or remove individual
   * resources to the set of tracked resources in the context of a stream.
   * All resource names in the resource_names_subscribe list are added to the
   * set of tracked resources and all resource names in the resource_names_unsubscribe
   * list are removed from the set of tracked resources.
   * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
   * resource_names_unsubscribe list simply means that no resources are to be
   * added or removed to the resource list.
   * *Like* state-of-the-world xDS, the server must send updates for all tracked
   * resources, but can also send updates for resources the client has not subscribed to.
   * NOTE: the server must respond with all resources listed in resource_names_subscribe,
   * even if it believes the client has the most recent version of them. The reason:
   * the client may have dropped them, but then regained interest before it had a chance
   * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
   * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
   * and initial_resource_versions.
   * A list of Resource names to add to the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_subscribe = 3;</code>
   */
  public com.google.protobuf.ByteString
      getResourceNamesSubscribeBytes(int index) {
    return resourceNamesSubscribe_.getByteString(index);
  }

  public static final int RESOURCE_NAMES_UNSUBSCRIBE_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList resourceNamesUnsubscribe_;
  /**
   * <pre>
   * A list of Resource names to remove from the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_unsubscribe = 4;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getResourceNamesUnsubscribeList() {
    return resourceNamesUnsubscribe_;
  }
  /**
   * <pre>
   * A list of Resource names to remove from the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_unsubscribe = 4;</code>
   */
  public int getResourceNamesUnsubscribeCount() {
    return resourceNamesUnsubscribe_.size();
  }
  /**
   * <pre>
   * A list of Resource names to remove from the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_unsubscribe = 4;</code>
   */
  public java.lang.String getResourceNamesUnsubscribe(int index) {
    return resourceNamesUnsubscribe_.get(index);
  }
  /**
   * <pre>
   * A list of Resource names to remove from the list of tracked resources.
   * </pre>
   *
   * <code>repeated string resource_names_unsubscribe = 4;</code>
   */
  public com.google.protobuf.ByteString
      getResourceNamesUnsubscribeBytes(int index) {
    return resourceNamesUnsubscribe_.getByteString(index);
  }

  public static final int INITIAL_RESOURCE_VERSIONS_FIELD_NUMBER = 5;
  private static final class InitialResourceVersionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, java.lang.String>newDefaultInstance(
                io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_InitialResourceVersionsEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
  }
  private com.google.protobuf.MapField<
      java.lang.String, java.lang.String> initialResourceVersions_;
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
  internalGetInitialResourceVersions() {
    if (initialResourceVersions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InitialResourceVersionsDefaultEntryHolder.defaultEntry);
    }
    return initialResourceVersions_;
  }

  public int getInitialResourceVersionsCount() {
    return internalGetInitialResourceVersions().getMap().size();
  }
  /**
   * <pre>
   * Informs the server of the versions of the resources the xDS client knows of, to enable the
   * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
   * It will not be populated: [1] in the very first stream of a session, since the client will
   * not yet have any resources,  [2] in any message after the first in a stream (for a given
   * type_url), since the server will already be correctly tracking the client's state.
   * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
   * The map's keys are names of xDS resources known to the xDS client.
   * The map's values are opaque resource versions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
   */

  public boolean containsInitialResourceVersions(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetInitialResourceVersions().getMap().containsKey(key);
  }
  /**
   * Use {@link #getInitialResourceVersionsMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getInitialResourceVersions() {
    return getInitialResourceVersionsMap();
  }
  /**
   * <pre>
   * Informs the server of the versions of the resources the xDS client knows of, to enable the
   * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
   * It will not be populated: [1] in the very first stream of a session, since the client will
   * not yet have any resources,  [2] in any message after the first in a stream (for a given
   * type_url), since the server will already be correctly tracking the client's state.
   * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
   * The map's keys are names of xDS resources known to the xDS client.
   * The map's values are opaque resource versions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
   */

  public java.util.Map<java.lang.String, java.lang.String> getInitialResourceVersionsMap() {
    return internalGetInitialResourceVersions().getMap();
  }
  /**
   * <pre>
   * Informs the server of the versions of the resources the xDS client knows of, to enable the
   * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
   * It will not be populated: [1] in the very first stream of a session, since the client will
   * not yet have any resources,  [2] in any message after the first in a stream (for a given
   * type_url), since the server will already be correctly tracking the client's state.
   * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
   * The map's keys are names of xDS resources known to the xDS client.
   * The map's values are opaque resource versions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
   */

  public java.lang.String getInitialResourceVersionsOrDefault(
      java.lang.String key,
      java.lang.String defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetInitialResourceVersions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Informs the server of the versions of the resources the xDS client knows of, to enable the
   * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
   * It will not be populated: [1] in the very first stream of a session, since the client will
   * not yet have any resources,  [2] in any message after the first in a stream (for a given
   * type_url), since the server will already be correctly tracking the client's state.
   * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
   * The map's keys are names of xDS resources known to the xDS client.
   * The map's values are opaque resource versions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
   */

  public java.lang.String getInitialResourceVersionsOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetInitialResourceVersions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESPONSE_NONCE_FIELD_NUMBER = 6;
  private volatile java.lang.Object responseNonce_;
  /**
   * <pre>
   * When the DeltaDiscoveryRequest is a ACK or NACK message in response
   * to a previous DeltaDiscoveryResponse, the response_nonce must be the
   * nonce in the DeltaDiscoveryResponse.
   * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
   * </pre>
   *
   * <code>string response_nonce = 6;</code>
   */
  public java.lang.String getResponseNonce() {
    java.lang.Object ref = responseNonce_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseNonce_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * When the DeltaDiscoveryRequest is a ACK or NACK message in response
   * to a previous DeltaDiscoveryResponse, the response_nonce must be the
   * nonce in the DeltaDiscoveryResponse.
   * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
   * </pre>
   *
   * <code>string response_nonce = 6;</code>
   */
  public com.google.protobuf.ByteString
      getResponseNonceBytes() {
    java.lang.Object ref = responseNonce_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      responseNonce_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_DETAIL_FIELD_NUMBER = 7;
  private com.google.rpc.Status errorDetail_;
  /**
   * <pre>
   * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
   * failed to update configuration. The *message* field in *error_details*
   * provides the Envoy internal exception related to the failure.
   * </pre>
   *
   * <code>.google.rpc.Status error_detail = 7;</code>
   */
  public boolean hasErrorDetail() {
    return errorDetail_ != null;
  }
  /**
   * <pre>
   * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
   * failed to update configuration. The *message* field in *error_details*
   * provides the Envoy internal exception related to the failure.
   * </pre>
   *
   * <code>.google.rpc.Status error_detail = 7;</code>
   */
  public com.google.rpc.Status getErrorDetail() {
    return errorDetail_ == null ? com.google.rpc.Status.getDefaultInstance() : errorDetail_;
  }
  /**
   * <pre>
   * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
   * failed to update configuration. The *message* field in *error_details*
   * provides the Envoy internal exception related to the failure.
   * </pre>
   *
   * <code>.google.rpc.Status error_detail = 7;</code>
   */
  public com.google.rpc.StatusOrBuilder getErrorDetailOrBuilder() {
    return getErrorDetail();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (node_ != null) {
      output.writeMessage(1, getNode());
    }
    if (!getTypeUrlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, typeUrl_);
    }
    for (int i = 0; i < resourceNamesSubscribe_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceNamesSubscribe_.getRaw(i));
    }
    for (int i = 0; i < resourceNamesUnsubscribe_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceNamesUnsubscribe_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetInitialResourceVersions(),
        InitialResourceVersionsDefaultEntryHolder.defaultEntry,
        5);
    if (!getResponseNonceBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, responseNonce_);
    }
    if (errorDetail_ != null) {
      output.writeMessage(7, getErrorDetail());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (node_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getNode());
    }
    if (!getTypeUrlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, typeUrl_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourceNamesSubscribe_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourceNamesSubscribe_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourceNamesSubscribeList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourceNamesUnsubscribe_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourceNamesUnsubscribe_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourceNamesUnsubscribeList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
         : internalGetInitialResourceVersions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
      initialResourceVersions__ = InitialResourceVersionsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, initialResourceVersions__);
    }
    if (!getResponseNonceBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, responseNonce_);
    }
    if (errorDetail_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getErrorDetail());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest other = (io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest) obj;

    if (hasNode() != other.hasNode()) return false;
    if (hasNode()) {
      if (!getNode()
          .equals(other.getNode())) return false;
    }
    if (!getTypeUrl()
        .equals(other.getTypeUrl())) return false;
    if (!getResourceNamesSubscribeList()
        .equals(other.getResourceNamesSubscribeList())) return false;
    if (!getResourceNamesUnsubscribeList()
        .equals(other.getResourceNamesUnsubscribeList())) return false;
    if (!internalGetInitialResourceVersions().equals(
        other.internalGetInitialResourceVersions())) return false;
    if (!getResponseNonce()
        .equals(other.getResponseNonce())) return false;
    if (hasErrorDetail() != other.hasErrorDetail()) return false;
    if (hasErrorDetail()) {
      if (!getErrorDetail()
          .equals(other.getErrorDetail())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNode()) {
      hash = (37 * hash) + NODE_FIELD_NUMBER;
      hash = (53 * hash) + getNode().hashCode();
    }
    hash = (37 * hash) + TYPE_URL_FIELD_NUMBER;
    hash = (53 * hash) + getTypeUrl().hashCode();
    if (getResourceNamesSubscribeCount() > 0) {
      hash = (37 * hash) + RESOURCE_NAMES_SUBSCRIBE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceNamesSubscribeList().hashCode();
    }
    if (getResourceNamesUnsubscribeCount() > 0) {
      hash = (37 * hash) + RESOURCE_NAMES_UNSUBSCRIBE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceNamesUnsubscribeList().hashCode();
    }
    if (!internalGetInitialResourceVersions().getMap().isEmpty()) {
      hash = (37 * hash) + INITIAL_RESOURCE_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInitialResourceVersions().hashCode();
    }
    hash = (37 * hash) + RESPONSE_NONCE_FIELD_NUMBER;
    hash = (53 * hash) + getResponseNonce().hashCode();
    if (hasErrorDetail()) {
      hash = (37 * hash) + ERROR_DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getErrorDetail().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
   * endpoint for Delta xDS.
   * With Delta xDS, the DeltaDiscoveryResponses do not need to include a full
   * snapshot of the tracked resources. Instead, DeltaDiscoveryResponses are a
   * diff to the state of a xDS client.
   * In Delta XDS there are per-resource versions, which allow tracking state at
   * the resource granularity.
   * An xDS Delta session is always in the context of a gRPC bidirectional
   * stream. This allows the xDS server to keep track of the state of xDS clients
   * connected to it.
   * In Delta xDS the nonce field is required and used to pair
   * DeltaDiscoveryResponse to a DeltaDiscoveryRequest ACK or NACK.
   * Optionally, a response message level system_version_info is present for
   * debugging purposes only.
   * DeltaDiscoveryRequest plays two independent roles. Any DeltaDiscoveryRequest
   * can be either or both of: [1] informing the server of what resources the
   * client has gained/lost interest in (using resource_names_subscribe and
   * resource_names_unsubscribe), or [2] (N)ACKing an earlier resource update from
   * the server (using response_nonce, with presence of error_detail making it a NACK).
   * Additionally, the first message (for a given type_url) of a reconnected gRPC stream
   * has a third role: informing the server of the resources (and their versions)
   * that the client already possesses, using the initial_resource_versions field.
   * As with state-of-the-world, when multiple resource types are multiplexed (ADS),
   * all requests/acknowledgments/updates are logically walled off by type_url:
   * a Cluster ACK exists in a completely separate world from a prior Route NACK.
   * In particular, initial_resource_versions being sent at the "start" of every
   * gRPC stream actually entails a message for each type_url, each with its own
   * initial_resource_versions.
   * [#next-free-field: 8]
   * </pre>
   *
   * Protobuf type {@code envoy.service.discovery.v4alpha.DeltaDiscoveryRequest}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)
      io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 5:
          return internalGetInitialResourceVersions();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableInitialResourceVersions();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.class, io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (nodeBuilder_ == null) {
        node_ = null;
      } else {
        node_ = null;
        nodeBuilder_ = null;
      }
      typeUrl_ = "";

      resourceNamesSubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceNamesUnsubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableInitialResourceVersions().clear();
      responseNonce_ = "";

      if (errorDetailBuilder_ == null) {
        errorDetail_ = null;
      } else {
        errorDetail_ = null;
        errorDetailBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.service.discovery.v4alpha.DiscoveryProto.internal_static_envoy_service_discovery_v4alpha_DeltaDiscoveryRequest_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest getDefaultInstanceForType() {
      return io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest build() {
      io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest buildPartial() {
      io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest result = new io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest(this);
      int from_bitField0_ = bitField0_;
      if (nodeBuilder_ == null) {
        result.node_ = node_;
      } else {
        result.node_ = nodeBuilder_.build();
      }
      result.typeUrl_ = typeUrl_;
      if (((bitField0_ & 0x00000001) != 0)) {
        resourceNamesSubscribe_ = resourceNamesSubscribe_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.resourceNamesSubscribe_ = resourceNamesSubscribe_;
      if (((bitField0_ & 0x00000002) != 0)) {
        resourceNamesUnsubscribe_ = resourceNamesUnsubscribe_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.resourceNamesUnsubscribe_ = resourceNamesUnsubscribe_;
      result.initialResourceVersions_ = internalGetInitialResourceVersions();
      result.initialResourceVersions_.makeImmutable();
      result.responseNonce_ = responseNonce_;
      if (errorDetailBuilder_ == null) {
        result.errorDetail_ = errorDetail_;
      } else {
        result.errorDetail_ = errorDetailBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest) {
        return mergeFrom((io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest other) {
      if (other == io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest.getDefaultInstance()) return this;
      if (other.hasNode()) {
        mergeNode(other.getNode());
      }
      if (!other.getTypeUrl().isEmpty()) {
        typeUrl_ = other.typeUrl_;
        onChanged();
      }
      if (!other.resourceNamesSubscribe_.isEmpty()) {
        if (resourceNamesSubscribe_.isEmpty()) {
          resourceNamesSubscribe_ = other.resourceNamesSubscribe_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureResourceNamesSubscribeIsMutable();
          resourceNamesSubscribe_.addAll(other.resourceNamesSubscribe_);
        }
        onChanged();
      }
      if (!other.resourceNamesUnsubscribe_.isEmpty()) {
        if (resourceNamesUnsubscribe_.isEmpty()) {
          resourceNamesUnsubscribe_ = other.resourceNamesUnsubscribe_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureResourceNamesUnsubscribeIsMutable();
          resourceNamesUnsubscribe_.addAll(other.resourceNamesUnsubscribe_);
        }
        onChanged();
      }
      internalGetMutableInitialResourceVersions().mergeFrom(
          other.internalGetInitialResourceVersions());
      if (!other.getResponseNonce().isEmpty()) {
        responseNonce_ = other.responseNonce_;
        onChanged();
      }
      if (other.hasErrorDetail()) {
        mergeErrorDetail(other.getErrorDetail());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private io.envoyproxy.envoy.config.core.v4alpha.Node node_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.Node, io.envoyproxy.envoy.config.core.v4alpha.Node.Builder, io.envoyproxy.envoy.config.core.v4alpha.NodeOrBuilder> nodeBuilder_;
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public boolean hasNode() {
      return nodeBuilder_ != null || node_ != null;
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.Node getNode() {
      if (nodeBuilder_ == null) {
        return node_ == null ? io.envoyproxy.envoy.config.core.v4alpha.Node.getDefaultInstance() : node_;
      } else {
        return nodeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public Builder setNode(io.envoyproxy.envoy.config.core.v4alpha.Node value) {
      if (nodeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        node_ = value;
        onChanged();
      } else {
        nodeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public Builder setNode(
        io.envoyproxy.envoy.config.core.v4alpha.Node.Builder builderForValue) {
      if (nodeBuilder_ == null) {
        node_ = builderForValue.build();
        onChanged();
      } else {
        nodeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public Builder mergeNode(io.envoyproxy.envoy.config.core.v4alpha.Node value) {
      if (nodeBuilder_ == null) {
        if (node_ != null) {
          node_ =
            io.envoyproxy.envoy.config.core.v4alpha.Node.newBuilder(node_).mergeFrom(value).buildPartial();
        } else {
          node_ = value;
        }
        onChanged();
      } else {
        nodeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public Builder clearNode() {
      if (nodeBuilder_ == null) {
        node_ = null;
        onChanged();
      } else {
        node_ = null;
        nodeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.Node.Builder getNodeBuilder() {
      
      onChanged();
      return getNodeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.NodeOrBuilder getNodeOrBuilder() {
      if (nodeBuilder_ != null) {
        return nodeBuilder_.getMessageOrBuilder();
      } else {
        return node_ == null ?
            io.envoyproxy.envoy.config.core.v4alpha.Node.getDefaultInstance() : node_;
      }
    }
    /**
     * <pre>
     * The node making the request.
     * </pre>
     *
     * <code>.envoy.config.core.v4alpha.Node node = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.Node, io.envoyproxy.envoy.config.core.v4alpha.Node.Builder, io.envoyproxy.envoy.config.core.v4alpha.NodeOrBuilder> 
        getNodeFieldBuilder() {
      if (nodeBuilder_ == null) {
        nodeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v4alpha.Node, io.envoyproxy.envoy.config.core.v4alpha.Node.Builder, io.envoyproxy.envoy.config.core.v4alpha.NodeOrBuilder>(
                getNode(),
                getParentForChildren(),
                isClean());
        node_ = null;
      }
      return nodeBuilder_;
    }

    private java.lang.Object typeUrl_ = "";
    /**
     * <pre>
     * Type of the resource that is being requested, e.g.
     * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
     * resources are only referenced via *xds_resource_subscribe* and
     * *xds_resources_unsubscribe*.
     * </pre>
     *
     * <code>string type_url = 2;</code>
     */
    public java.lang.String getTypeUrl() {
      java.lang.Object ref = typeUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        typeUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Type of the resource that is being requested, e.g.
     * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
     * resources are only referenced via *xds_resource_subscribe* and
     * *xds_resources_unsubscribe*.
     * </pre>
     *
     * <code>string type_url = 2;</code>
     */
    public com.google.protobuf.ByteString
        getTypeUrlBytes() {
      java.lang.Object ref = typeUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        typeUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Type of the resource that is being requested, e.g.
     * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
     * resources are only referenced via *xds_resource_subscribe* and
     * *xds_resources_unsubscribe*.
     * </pre>
     *
     * <code>string type_url = 2;</code>
     */
    public Builder setTypeUrl(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      typeUrl_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of the resource that is being requested, e.g.
     * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
     * resources are only referenced via *xds_resource_subscribe* and
     * *xds_resources_unsubscribe*.
     * </pre>
     *
     * <code>string type_url = 2;</code>
     */
    public Builder clearTypeUrl() {
      
      typeUrl_ = getDefaultInstance().getTypeUrl();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of the resource that is being requested, e.g.
     * "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This does not need to be set if
     * resources are only referenced via *xds_resource_subscribe* and
     * *xds_resources_unsubscribe*.
     * </pre>
     *
     * <code>string type_url = 2;</code>
     */
    public Builder setTypeUrlBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      typeUrl_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList resourceNamesSubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureResourceNamesSubscribeIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        resourceNamesSubscribe_ = new com.google.protobuf.LazyStringArrayList(resourceNamesSubscribe_);
        bitField0_ |= 0x00000001;
       }
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getResourceNamesSubscribeList() {
      return resourceNamesSubscribe_.getUnmodifiableView();
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public int getResourceNamesSubscribeCount() {
      return resourceNamesSubscribe_.size();
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public java.lang.String getResourceNamesSubscribe(int index) {
      return resourceNamesSubscribe_.get(index);
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public com.google.protobuf.ByteString
        getResourceNamesSubscribeBytes(int index) {
      return resourceNamesSubscribe_.getByteString(index);
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public Builder setResourceNamesSubscribe(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureResourceNamesSubscribeIsMutable();
      resourceNamesSubscribe_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public Builder addResourceNamesSubscribe(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureResourceNamesSubscribeIsMutable();
      resourceNamesSubscribe_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public Builder addAllResourceNamesSubscribe(
        java.lang.Iterable<java.lang.String> values) {
      ensureResourceNamesSubscribeIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, resourceNamesSubscribe_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public Builder clearResourceNamesSubscribe() {
      resourceNamesSubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DeltaDiscoveryRequests allow the client to add or remove individual
     * resources to the set of tracked resources in the context of a stream.
     * All resource names in the resource_names_subscribe list are added to the
     * set of tracked resources and all resource names in the resource_names_unsubscribe
     * list are removed from the set of tracked resources.
     * *Unlike* state-of-the-world xDS, an empty resource_names_subscribe or
     * resource_names_unsubscribe list simply means that no resources are to be
     * added or removed to the resource list.
     * *Like* state-of-the-world xDS, the server must send updates for all tracked
     * resources, but can also send updates for resources the client has not subscribed to.
     * NOTE: the server must respond with all resources listed in resource_names_subscribe,
     * even if it believes the client has the most recent version of them. The reason:
     * the client may have dropped them, but then regained interest before it had a chance
     * to send the unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd.
     * These two fields can be set in any DeltaDiscoveryRequest, including ACKs
     * and initial_resource_versions.
     * A list of Resource names to add to the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_subscribe = 3;</code>
     */
    public Builder addResourceNamesSubscribeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureResourceNamesSubscribeIsMutable();
      resourceNamesSubscribe_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList resourceNamesUnsubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureResourceNamesUnsubscribeIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        resourceNamesUnsubscribe_ = new com.google.protobuf.LazyStringArrayList(resourceNamesUnsubscribe_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getResourceNamesUnsubscribeList() {
      return resourceNamesUnsubscribe_.getUnmodifiableView();
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public int getResourceNamesUnsubscribeCount() {
      return resourceNamesUnsubscribe_.size();
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public java.lang.String getResourceNamesUnsubscribe(int index) {
      return resourceNamesUnsubscribe_.get(index);
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public com.google.protobuf.ByteString
        getResourceNamesUnsubscribeBytes(int index) {
      return resourceNamesUnsubscribe_.getByteString(index);
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public Builder setResourceNamesUnsubscribe(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureResourceNamesUnsubscribeIsMutable();
      resourceNamesUnsubscribe_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public Builder addResourceNamesUnsubscribe(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureResourceNamesUnsubscribeIsMutable();
      resourceNamesUnsubscribe_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public Builder addAllResourceNamesUnsubscribe(
        java.lang.Iterable<java.lang.String> values) {
      ensureResourceNamesUnsubscribeIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, resourceNamesUnsubscribe_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public Builder clearResourceNamesUnsubscribe() {
      resourceNamesUnsubscribe_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of Resource names to remove from the list of tracked resources.
     * </pre>
     *
     * <code>repeated string resource_names_unsubscribe = 4;</code>
     */
    public Builder addResourceNamesUnsubscribeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureResourceNamesUnsubscribeIsMutable();
      resourceNamesUnsubscribe_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> initialResourceVersions_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetInitialResourceVersions() {
      if (initialResourceVersions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InitialResourceVersionsDefaultEntryHolder.defaultEntry);
      }
      return initialResourceVersions_;
    }
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetMutableInitialResourceVersions() {
      onChanged();;
      if (initialResourceVersions_ == null) {
        initialResourceVersions_ = com.google.protobuf.MapField.newMapField(
            InitialResourceVersionsDefaultEntryHolder.defaultEntry);
      }
      if (!initialResourceVersions_.isMutable()) {
        initialResourceVersions_ = initialResourceVersions_.copy();
      }
      return initialResourceVersions_;
    }

    public int getInitialResourceVersionsCount() {
      return internalGetInitialResourceVersions().getMap().size();
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public boolean containsInitialResourceVersions(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetInitialResourceVersions().getMap().containsKey(key);
    }
    /**
     * Use {@link #getInitialResourceVersionsMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getInitialResourceVersions() {
      return getInitialResourceVersionsMap();
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public java.util.Map<java.lang.String, java.lang.String> getInitialResourceVersionsMap() {
      return internalGetInitialResourceVersions().getMap();
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public java.lang.String getInitialResourceVersionsOrDefault(
        java.lang.String key,
        java.lang.String defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetInitialResourceVersions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public java.lang.String getInitialResourceVersionsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetInitialResourceVersions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearInitialResourceVersions() {
      internalGetMutableInitialResourceVersions().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public Builder removeInitialResourceVersions(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableInitialResourceVersions().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String>
    getMutableInitialResourceVersions() {
      return internalGetMutableInitialResourceVersions().getMutableMap();
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */
    public Builder putInitialResourceVersions(
        java.lang.String key,
        java.lang.String value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableInitialResourceVersions().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Informs the server of the versions of the resources the xDS client knows of, to enable the
     * client to continue the same logical xDS session even in the face of gRPC stream reconnection.
     * It will not be populated: [1] in the very first stream of a session, since the client will
     * not yet have any resources,  [2] in any message after the first in a stream (for a given
     * type_url), since the server will already be correctly tracking the client's state.
     * (In ADS, the first message *of each type_url* of a reconnected stream populates this map.)
     * The map's keys are names of xDS resources known to the xDS client.
     * The map's values are opaque resource versions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; initial_resource_versions = 5;</code>
     */

    public Builder putAllInitialResourceVersions(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableInitialResourceVersions().getMutableMap()
          .putAll(values);
      return this;
    }

    private java.lang.Object responseNonce_ = "";
    /**
     * <pre>
     * When the DeltaDiscoveryRequest is a ACK or NACK message in response
     * to a previous DeltaDiscoveryResponse, the response_nonce must be the
     * nonce in the DeltaDiscoveryResponse.
     * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
     * </pre>
     *
     * <code>string response_nonce = 6;</code>
     */
    public java.lang.String getResponseNonce() {
      java.lang.Object ref = responseNonce_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseNonce_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * When the DeltaDiscoveryRequest is a ACK or NACK message in response
     * to a previous DeltaDiscoveryResponse, the response_nonce must be the
     * nonce in the DeltaDiscoveryResponse.
     * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
     * </pre>
     *
     * <code>string response_nonce = 6;</code>
     */
    public com.google.protobuf.ByteString
        getResponseNonceBytes() {
      java.lang.Object ref = responseNonce_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        responseNonce_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * When the DeltaDiscoveryRequest is a ACK or NACK message in response
     * to a previous DeltaDiscoveryResponse, the response_nonce must be the
     * nonce in the DeltaDiscoveryResponse.
     * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
     * </pre>
     *
     * <code>string response_nonce = 6;</code>
     */
    public Builder setResponseNonce(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      responseNonce_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When the DeltaDiscoveryRequest is a ACK or NACK message in response
     * to a previous DeltaDiscoveryResponse, the response_nonce must be the
     * nonce in the DeltaDiscoveryResponse.
     * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
     * </pre>
     *
     * <code>string response_nonce = 6;</code>
     */
    public Builder clearResponseNonce() {
      
      responseNonce_ = getDefaultInstance().getResponseNonce();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When the DeltaDiscoveryRequest is a ACK or NACK message in response
     * to a previous DeltaDiscoveryResponse, the response_nonce must be the
     * nonce in the DeltaDiscoveryResponse.
     * Otherwise (unlike in DiscoveryRequest) response_nonce must be omitted.
     * </pre>
     *
     * <code>string response_nonce = 6;</code>
     */
    public Builder setResponseNonceBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      responseNonce_ = value;
      onChanged();
      return this;
    }

    private com.google.rpc.Status errorDetail_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder> errorDetailBuilder_;
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public boolean hasErrorDetail() {
      return errorDetailBuilder_ != null || errorDetail_ != null;
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public com.google.rpc.Status getErrorDetail() {
      if (errorDetailBuilder_ == null) {
        return errorDetail_ == null ? com.google.rpc.Status.getDefaultInstance() : errorDetail_;
      } else {
        return errorDetailBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public Builder setErrorDetail(com.google.rpc.Status value) {
      if (errorDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorDetail_ = value;
        onChanged();
      } else {
        errorDetailBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public Builder setErrorDetail(
        com.google.rpc.Status.Builder builderForValue) {
      if (errorDetailBuilder_ == null) {
        errorDetail_ = builderForValue.build();
        onChanged();
      } else {
        errorDetailBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public Builder mergeErrorDetail(com.google.rpc.Status value) {
      if (errorDetailBuilder_ == null) {
        if (errorDetail_ != null) {
          errorDetail_ =
            com.google.rpc.Status.newBuilder(errorDetail_).mergeFrom(value).buildPartial();
        } else {
          errorDetail_ = value;
        }
        onChanged();
      } else {
        errorDetailBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public Builder clearErrorDetail() {
      if (errorDetailBuilder_ == null) {
        errorDetail_ = null;
        onChanged();
      } else {
        errorDetail_ = null;
        errorDetailBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public com.google.rpc.Status.Builder getErrorDetailBuilder() {
      
      onChanged();
      return getErrorDetailFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorDetailOrBuilder() {
      if (errorDetailBuilder_ != null) {
        return errorDetailBuilder_.getMessageOrBuilder();
      } else {
        return errorDetail_ == null ?
            com.google.rpc.Status.getDefaultInstance() : errorDetail_;
      }
    }
    /**
     * <pre>
     * This is populated when the previous :ref:`DiscoveryResponse &lt;envoy_api_msg_service.discovery.v4alpha.DiscoveryResponse&gt;`
     * failed to update configuration. The *message* field in *error_details*
     * provides the Envoy internal exception related to the failure.
     * </pre>
     *
     * <code>.google.rpc.Status error_detail = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder> 
        getErrorDetailFieldBuilder() {
      if (errorDetailBuilder_ == null) {
        errorDetailBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>(
                getErrorDetail(),
                getParentForChildren(),
                isClean());
        errorDetail_ = null;
      }
      return errorDetailBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)
  }

  // @@protoc_insertion_point(class_scope:envoy.service.discovery.v4alpha.DeltaDiscoveryRequest)
  private static final io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest();
  }

  public static io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeltaDiscoveryRequest>
      PARSER = new com.google.protobuf.AbstractParser<DeltaDiscoveryRequest>() {
    @java.lang.Override
    public DeltaDiscoveryRequest parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new DeltaDiscoveryRequest(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<DeltaDiscoveryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeltaDiscoveryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.service.discovery.v4alpha.DeltaDiscoveryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

