// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/rbac/v2/rbac.proto

package io.envoyproxy.envoy.config.rbac.v2;

/**
 * <pre>
 * Role Based Access Control (RBAC) provides service-level and method-level access control for a
 * service. RBAC policies are additive. The policies are examined in order. A request is allowed
 * once a matching policy is found (suppose the `action` is ALLOW).
 * Here is an example of RBAC configuration. It has two policies:
 * * Service account "cluster.local/ns/default/sa/admin" has full access to the service, and so
 *   does "cluster.local/ns/default/sa/superuser".
 * * Any user can read ("GET") the service at paths with prefix "/products", so long as the
 *   destination port is either 80 or 443.
 *  .. code-block:: yaml
 *   action: ALLOW
 *   policies:
 *     "service-admin":
 *       permissions:
 *         - any: true
 *       principals:
 *         - authenticated:
 *             principal_name:
 *               exact: "cluster.local/ns/default/sa/admin"
 *         - authenticated:
 *             principal_name:
 *               exact: "cluster.local/ns/default/sa/superuser"
 *     "product-viewer":
 *       permissions:
 *           - and_rules:
 *               rules:
 *                 - header: { name: ":method", exact_match: "GET" }
 *                 - url_path:
 *                     path: { prefix: "/products" }
 *                 - or_rules:
 *                     rules:
 *                       - destination_port: 80
 *                       - destination_port: 443
 *       principals:
 *         - any: true
 * </pre>
 *
 * Protobuf type {@code envoy.config.rbac.v2.RBAC}
 */
public  final class RBAC extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.rbac.v2.RBAC)
    RBACOrBuilder {
private static final long serialVersionUID = 0L;
  // Use RBAC.newBuilder() to construct.
  private RBAC(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private RBAC() {
    action_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new RBAC();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private RBAC(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {
            int rawValue = input.readEnum();

            action_ = rawValue;
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              policies_ = com.google.protobuf.MapField.newMapField(
                  PoliciesDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000001;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
            policies__ = input.readMessage(
                PoliciesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            policies_.getMutableMap().put(
                policies__.getKey(), policies__.getValue());
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 2:
        return internalGetPolicies();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.rbac.v2.RBAC.class, io.envoyproxy.envoy.config.rbac.v2.RBAC.Builder.class);
  }

  /**
   * <pre>
   * Should we do safe-list or block-list style access control?
   * </pre>
   *
   * Protobuf enum {@code envoy.config.rbac.v2.RBAC.Action}
   */
  public enum Action
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The policies grant access to principals. The rest is denied. This is safe-list style
     * access control. This is the default type.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    ALLOW(0),
    /**
     * <pre>
     * The policies deny access to principals. The rest is allowed. This is block-list style
     * access control.
     * </pre>
     *
     * <code>DENY = 1;</code>
     */
    DENY(1),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The policies grant access to principals. The rest is denied. This is safe-list style
     * access control. This is the default type.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    public static final int ALLOW_VALUE = 0;
    /**
     * <pre>
     * The policies deny access to principals. The rest is allowed. This is block-list style
     * access control.
     * </pre>
     *
     * <code>DENY = 1;</code>
     */
    public static final int DENY_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    public static Action forNumber(int value) {
      switch (value) {
        case 0: return ALLOW;
        case 1: return DENY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Action> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Action>() {
            public Action findValueByNumber(int number) {
              return Action.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.rbac.v2.RBAC.getDescriptor().getEnumTypes().get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.rbac.v2.RBAC.Action)
  }

  public static final int ACTION_FIELD_NUMBER = 1;
  private int action_;
  /**
   * <pre>
   * The action to take if a policy matches. The request is allowed if and only if:
   *   * `action` is "ALLOWED" and at least one policy matches
   *   * `action` is "DENY" and none of the policies match
   * </pre>
   *
   * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
   */
  public int getActionValue() {
    return action_;
  }
  /**
   * <pre>
   * The action to take if a policy matches. The request is allowed if and only if:
   *   * `action` is "ALLOWED" and at least one policy matches
   *   * `action` is "DENY" and none of the policies match
   * </pre>
   *
   * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
   */
  public io.envoyproxy.envoy.config.rbac.v2.RBAC.Action getAction() {
    @SuppressWarnings("deprecation")
    io.envoyproxy.envoy.config.rbac.v2.RBAC.Action result = io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.valueOf(action_);
    return result == null ? io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.UNRECOGNIZED : result;
  }

  public static final int POLICIES_FIELD_NUMBER = 2;
  private static final class PoliciesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>newDefaultInstance(
                io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_PoliciesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.envoyproxy.envoy.config.rbac.v2.Policy.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> policies_;
  private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
  internalGetPolicies() {
    if (policies_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PoliciesDefaultEntryHolder.defaultEntry);
    }
    return policies_;
  }

  public int getPoliciesCount() {
    return internalGetPolicies().getMap().size();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
   */

  public boolean containsPolicies(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetPolicies().getMap().containsKey(key);
  }
  /**
   * Use {@link #getPoliciesMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> getPolicies() {
    return getPoliciesMap();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
   */

  public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> getPoliciesMap() {
    return internalGetPolicies().getMap();
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
   */

  public io.envoyproxy.envoy.config.rbac.v2.Policy getPoliciesOrDefault(
      java.lang.String key,
      io.envoyproxy.envoy.config.rbac.v2.Policy defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> map =
        internalGetPolicies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Maps from policy name to policy. A match occurs when at least one policy matches the request.
   * </pre>
   *
   * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
   */

  public io.envoyproxy.envoy.config.rbac.v2.Policy getPoliciesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> map =
        internalGetPolicies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (action_ != io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.ALLOW.getNumber()) {
      output.writeEnum(1, action_);
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetPolicies(),
        PoliciesDefaultEntryHolder.defaultEntry,
        2);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (action_ != io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.ALLOW.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, action_);
    }
    for (java.util.Map.Entry<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> entry
         : internalGetPolicies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
      policies__ = PoliciesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, policies__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.rbac.v2.RBAC)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.rbac.v2.RBAC other = (io.envoyproxy.envoy.config.rbac.v2.RBAC) obj;

    if (action_ != other.action_) return false;
    if (!internalGetPolicies().equals(
        other.internalGetPolicies())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    if (!internalGetPolicies().getMap().isEmpty()) {
      hash = (37 * hash) + POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPolicies().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.rbac.v2.RBAC parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.rbac.v2.RBAC prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Role Based Access Control (RBAC) provides service-level and method-level access control for a
   * service. RBAC policies are additive. The policies are examined in order. A request is allowed
   * once a matching policy is found (suppose the `action` is ALLOW).
   * Here is an example of RBAC configuration. It has two policies:
   * * Service account "cluster.local/ns/default/sa/admin" has full access to the service, and so
   *   does "cluster.local/ns/default/sa/superuser".
   * * Any user can read ("GET") the service at paths with prefix "/products", so long as the
   *   destination port is either 80 or 443.
   *  .. code-block:: yaml
   *   action: ALLOW
   *   policies:
   *     "service-admin":
   *       permissions:
   *         - any: true
   *       principals:
   *         - authenticated:
   *             principal_name:
   *               exact: "cluster.local/ns/default/sa/admin"
   *         - authenticated:
   *             principal_name:
   *               exact: "cluster.local/ns/default/sa/superuser"
   *     "product-viewer":
   *       permissions:
   *           - and_rules:
   *               rules:
   *                 - header: { name: ":method", exact_match: "GET" }
   *                 - url_path:
   *                     path: { prefix: "/products" }
   *                 - or_rules:
   *                     rules:
   *                       - destination_port: 80
   *                       - destination_port: 443
   *       principals:
   *         - any: true
   * </pre>
   *
   * Protobuf type {@code envoy.config.rbac.v2.RBAC}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.rbac.v2.RBAC)
      io.envoyproxy.envoy.config.rbac.v2.RBACOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 2:
          return internalGetPolicies();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutablePolicies();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.rbac.v2.RBAC.class, io.envoyproxy.envoy.config.rbac.v2.RBAC.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.rbac.v2.RBAC.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      action_ = 0;

      internalGetMutablePolicies().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.rbac.v2.RbacProto.internal_static_envoy_config_rbac_v2_RBAC_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v2.RBAC getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.rbac.v2.RBAC.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v2.RBAC build() {
      io.envoyproxy.envoy.config.rbac.v2.RBAC result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.rbac.v2.RBAC buildPartial() {
      io.envoyproxy.envoy.config.rbac.v2.RBAC result = new io.envoyproxy.envoy.config.rbac.v2.RBAC(this);
      int from_bitField0_ = bitField0_;
      result.action_ = action_;
      result.policies_ = internalGetPolicies();
      result.policies_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.rbac.v2.RBAC) {
        return mergeFrom((io.envoyproxy.envoy.config.rbac.v2.RBAC)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.rbac.v2.RBAC other) {
      if (other == io.envoyproxy.envoy.config.rbac.v2.RBAC.getDefaultInstance()) return this;
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      internalGetMutablePolicies().mergeFrom(
          other.internalGetPolicies());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.config.rbac.v2.RBAC parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.config.rbac.v2.RBAC) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int action_ = 0;
    /**
     * <pre>
     * The action to take if a policy matches. The request is allowed if and only if:
     *   * `action` is "ALLOWED" and at least one policy matches
     *   * `action` is "DENY" and none of the policies match
     * </pre>
     *
     * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
     */
    public int getActionValue() {
      return action_;
    }
    /**
     * <pre>
     * The action to take if a policy matches. The request is allowed if and only if:
     *   * `action` is "ALLOWED" and at least one policy matches
     *   * `action` is "DENY" and none of the policies match
     * </pre>
     *
     * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
     */
    public Builder setActionValue(int value) {
      action_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The action to take if a policy matches. The request is allowed if and only if:
     *   * `action` is "ALLOWED" and at least one policy matches
     *   * `action` is "DENY" and none of the policies match
     * </pre>
     *
     * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
     */
    public io.envoyproxy.envoy.config.rbac.v2.RBAC.Action getAction() {
      @SuppressWarnings("deprecation")
      io.envoyproxy.envoy.config.rbac.v2.RBAC.Action result = io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.valueOf(action_);
      return result == null ? io.envoyproxy.envoy.config.rbac.v2.RBAC.Action.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The action to take if a policy matches. The request is allowed if and only if:
     *   * `action` is "ALLOWED" and at least one policy matches
     *   * `action` is "DENY" and none of the policies match
     * </pre>
     *
     * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
     */
    public Builder setAction(io.envoyproxy.envoy.config.rbac.v2.RBAC.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The action to take if a policy matches. The request is allowed if and only if:
     *   * `action` is "ALLOWED" and at least one policy matches
     *   * `action` is "DENY" and none of the policies match
     * </pre>
     *
     * <code>.envoy.config.rbac.v2.RBAC.Action action = 1;</code>
     */
    public Builder clearAction() {
      
      action_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> policies_;
    private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
    internalGetPolicies() {
      if (policies_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PoliciesDefaultEntryHolder.defaultEntry);
      }
      return policies_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
    internalGetMutablePolicies() {
      onChanged();;
      if (policies_ == null) {
        policies_ = com.google.protobuf.MapField.newMapField(
            PoliciesDefaultEntryHolder.defaultEntry);
      }
      if (!policies_.isMutable()) {
        policies_ = policies_.copy();
      }
      return policies_;
    }

    public int getPoliciesCount() {
      return internalGetPolicies().getMap().size();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public boolean containsPolicies(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetPolicies().getMap().containsKey(key);
    }
    /**
     * Use {@link #getPoliciesMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> getPolicies() {
      return getPoliciesMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> getPoliciesMap() {
      return internalGetPolicies().getMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public io.envoyproxy.envoy.config.rbac.v2.Policy getPoliciesOrDefault(
        java.lang.String key,
        io.envoyproxy.envoy.config.rbac.v2.Policy defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> map =
          internalGetPolicies().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public io.envoyproxy.envoy.config.rbac.v2.Policy getPoliciesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> map =
          internalGetPolicies().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPolicies() {
      internalGetMutablePolicies().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public Builder removePolicies(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePolicies().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy>
    getMutablePolicies() {
      return internalGetMutablePolicies().getMutableMap();
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */
    public Builder putPolicies(
        java.lang.String key,
        io.envoyproxy.envoy.config.rbac.v2.Policy value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutablePolicies().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Maps from policy name to policy. A match occurs when at least one policy matches the request.
     * </pre>
     *
     * <code>map&lt;string, .envoy.config.rbac.v2.Policy&gt; policies = 2;</code>
     */

    public Builder putAllPolicies(
        java.util.Map<java.lang.String, io.envoyproxy.envoy.config.rbac.v2.Policy> values) {
      internalGetMutablePolicies().getMutableMap()
          .putAll(values);
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.rbac.v2.RBAC)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.rbac.v2.RBAC)
  private static final io.envoyproxy.envoy.config.rbac.v2.RBAC DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.rbac.v2.RBAC();
  }

  public static io.envoyproxy.envoy.config.rbac.v2.RBAC getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RBAC>
      PARSER = new com.google.protobuf.AbstractParser<RBAC>() {
    @java.lang.Override
    public RBAC parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new RBAC(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<RBAC> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RBAC> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.rbac.v2.RBAC getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

