/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.joda.time;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.ScalarTypeBaseDate;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

class ScalarTypeJodaLocalDate
extends ScalarTypeBaseDate<LocalDate> {
    ScalarTypeJodaLocalDate(JsonConfig.Date mode) {
        super(mode, LocalDate.class, false, 91);
    }

    protected String toIsoFormat(LocalDate value) {
        return value.toString();
    }

    public LocalDate convertFromMillis(long systemTimeMillis) {
        return new LocalDate(systemTimeMillis);
    }

    public long convertToMillis(LocalDate value) {
        return value.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis();
    }

    public LocalDate convertFromDate(java.sql.Date date) {
        return LocalDate.fromDateFields((Date)date);
    }

    public java.sql.Date convertToDate(LocalDate value) {
        return new java.sql.Date(value.getYear() - 1900, value.getMonthOfYear() - 1, value.getDayOfMonth());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof LocalDate) {
            return this.convertToDate((LocalDate)value);
        }
        return BasicTypeConverter.toDate((Object)value);
    }

    public LocalDate toBeanType(Object value) {
        if (value instanceof Date) {
            return LocalDate.fromDateFields((Date)((Date)value));
        }
        return (LocalDate)value;
    }
}

