/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.jackson.mapper;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.ebean.annotation.MutationDetection;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarJsonManager;
import io.ebean.core.type.ScalarJsonMapper;
import io.ebean.core.type.ScalarJsonRequest;
import io.ebean.core.type.ScalarType;
import io.ebean.core.type.ScalarTypeBase;
import io.ebean.jackson.mapper.AnnotatedClassUtil;
import io.ebean.jackson.mapper.JacksonTypeHelper;
import io.ebean.jackson.mapper.JsonTrim;
import io.ebean.text.TextException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;

public final class ScalarJsonJacksonMapper
implements ScalarJsonMapper {
    private final Map<Class<?>, AnnotatedClass> jacksonClasses = new ConcurrentHashMap();

    public <A extends Annotation> Class<A> markerAnnotation() {
        return JacksonAnnotation.class;
    }

    public ScalarType<?> createType(ScalarJsonRequest req) {
        AnnotatedClass annotatedClass = this.annotatedClass(req);
        AnnotatedField field = this.annotatedField(annotatedClass, req);
        if (req.mode() == MutationDetection.NONE) {
            return new NoMutationDetection(req.manager(), field, req.dbType(), req.docType());
        }
        return new GenericObject(req.manager(), field, req.dbType(), req.docType());
    }

    private AnnotatedField annotatedField(AnnotatedClass annotatedClass, ScalarJsonRequest req) {
        for (AnnotatedField field : annotatedClass.fields()) {
            if (!field.getName().equals(req.name())) continue;
            return field;
        }
        throw new IllegalStateException("AnnotatedField not found to match " + req.name());
    }

    private AnnotatedClass annotatedClass(ScalarJsonRequest req) {
        return this.jacksonClasses.computeIfAbsent(req.beanType(), key -> {
            ObjectMapper mapper = (ObjectMapper)req.manager().mapper();
            return AnnotatedClassUtil.obtain(mapper, req.beanType());
        });
    }

    private static final class NoMutationDetection
    extends Base<Object> {
        NoMutationDetection(ScalarJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(Object.class, jsonManager, field, dbType, docType);
        }
    }

    private static final class GenericObject
    extends Base<Object> {
        private final boolean jsonb;

        GenericObject(ScalarJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(Object.class, jsonManager, field, dbType, docType);
            this.jsonb = "jsonb".equals(this.pgType);
        }

        public boolean mutable() {
            return true;
        }

        public boolean jsonMapper() {
            return true;
        }

        @Override
        public Object read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (this.jsonb) {
                json = JsonTrim.trim(json);
            }
            reader.pushJson(json);
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return this.objectReader.readValue(json, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, json, (Exception)e);
            }
        }

        @Override
        public void bind(DataBinder binder, Object value) throws SQLException {
            String rawJson = binder.popJson();
            if (rawJson == null && value != null) {
                rawJson = this.formatValue(value);
            }
            if (this.pgType != null) {
                binder.setObject(PostgresHelper.asObject((String)this.pgType, (String)rawJson));
            } else if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(rawJson);
            }
        }
    }

    private static abstract class Base<T>
    extends ScalarTypeBase<T> {
        protected final ObjectWriter objectWriter;
        protected final ObjectMapper objectReader;
        protected final JavaType deserType;
        protected final String pgType;
        private final DocPropertyType docType;

        Base(Class<T> cls, ScalarJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(cls, false, dbType);
            this.objectReader = (ObjectMapper)jsonManager.mapper();
            this.pgType = jsonManager.postgresType(dbType);
            this.docType = docType;
            JacksonTypeHelper helper = new JacksonTypeHelper(field, this.objectReader);
            this.deserType = helper.type();
            this.objectWriter = helper.objectWriter();
        }

        public T read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return (T)this.objectReader.readValue(json, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, json, (Exception)e);
            }
        }

        public void bind(DataBinder binder, T value) throws SQLException {
            if (this.pgType != null) {
                String rawJson = value == null ? null : this.formatValue(value);
                binder.setObject(PostgresHelper.asObject((String)this.pgType, (String)rawJson));
            } else if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(this.formatValue(value));
            }
        }

        public final Object toJdbcType(Object value) {
            return value;
        }

        public final T toBeanType(Object value) {
            return (T)value;
        }

        public final String formatValue(T value) {
            try {
                return this.objectWriter.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new PersistenceException("Unable to create JSON", (Throwable)e);
            }
        }

        public final T parse(String value) {
            try {
                return (T)this.objectReader.readValue(value, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, value, (Exception)e);
            }
        }

        public final DocPropertyType docType() {
            return this.docType;
        }

        public final T jsonRead(JsonParser parser) throws IOException {
            return (T)this.objectReader.readValue(parser, this.deserType);
        }

        public final void jsonWrite(JsonGenerator writer, T value) throws IOException {
            this.objectWriter.writeValue(writer, value);
        }

        public final T readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        public final void writeData(DataOutput dataOutput, T value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                dataOutput.writeUTF(this.format(value));
            }
        }
    }
}

